/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.google.errorprone.annotations.CheckReturnValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.jspecify.annotations.NonNull;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.Size;
import org.xhtmlrenderer.pdf.ITextFSImage;

public class SvgImage
extends ITextFSImage {
    public SvgImage(byte[] image, Size size, String uri) {
        super(image, size, uri);
    }

    @Override
    @CheckReturnValue
    public @NonNull FSImage scale(int width, int height) {
        return new SvgImage(this.image, this.size.scale(width, height), this.uri);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getImage() {
        PNGTranscoder transcoder = new PNGTranscoder();
        transcoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)Float.valueOf(1.0f * (float)this.getWidth()));
        transcoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)Float.valueOf(1.0f * (float)this.getHeight()));
        try (ByteArrayInputStream in = new ByteArrayInputStream(this.image);){
            byte[] byArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                transcoder.transcode(new TranscoderInput((InputStream)in), new TranscoderOutput((OutputStream)out));
                out.flush();
                byArray = out.toByteArray();
            }
            return byArray;
        }
        catch (IOException | TranscoderException e) {
            throw new RuntimeException("Failed to convert SVG to PNG (%s)".formatted(this.uri), e);
        }
    }
}

