/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.google.errorprone.annotations.CheckReturnValue;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.pdf.ITextFSImage;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.PDFAsImage;
import org.xhtmlrenderer.resource.ImageResource;
import org.xhtmlrenderer.swing.NaiveUserAgent;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.ContentTypeDetectingInputStreamWrapper;
import org.xhtmlrenderer.util.IOUtil;
import org.xhtmlrenderer.util.ImageUtil;
import org.xhtmlrenderer.util.XRLog;

public class ITextUserAgent
extends NaiveUserAgent {
    private static final int IMAGE_CACHE_CAPACITY = 32;
    private final ITextOutputDevice _outputDevice;
    private final int dotsPerPixel;

    public ITextUserAgent(ITextOutputDevice outputDevice, int dotsPerPixel) {
        super(Configuration.valueAsInt((String)"xr.image.cache-capacity", (int)32));
        this._outputDevice = outputDevice;
        this.dotsPerPixel = dotsPerPixel;
    }

    int getDotsPerPixel() {
        return this.dotsPerPixel;
    }

    @CheckReturnValue
    public ImageResource getImageResource(String uriStr) {
        ImageResource resource;
        String unresolvedUri = uriStr;
        if (!ImageUtil.isEmbeddedBase64Image((String)uriStr)) {
            uriStr = this.resolveURI(uriStr);
        }
        if ((resource = (ImageResource)this._imageCache.get(unresolvedUri)) == null) {
            resource = this.loadImageResource(uriStr);
            this._imageCache.put(unresolvedUri, resource);
        }
        if (resource != null) {
            FSImage image = resource.getImage();
            if (image instanceof ITextFSImage) {
                image = (FSImage)((ITextFSImage)resource.getImage()).clone();
            }
            return new ImageResource(resource.getImageUri(), image);
        }
        return new ImageResource(uriStr, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @CheckReturnValue
    private @Nullable ImageResource loadImageResource(String uriStr) {
        block16: {
            if (ImageUtil.isEmbeddedBase64Image((String)uriStr)) {
                return this.loadEmbeddedBase64ImageResource(uriStr);
            }
            try (InputStream is = this.resolveAndOpenStream(uriStr);){
                ContentTypeDetectingInputStreamWrapper cis;
                block17: {
                    ImageResource imageResource;
                    if (is == null) break block16;
                    cis = new ContentTypeDetectingInputStreamWrapper(is);
                    try {
                        if (!cis.isPdf()) break block17;
                        URI uri = new URI(uriStr);
                        PdfReader reader = this._outputDevice.getReader(uri);
                        PDFAsImage image = new PDFAsImage(uri);
                        Rectangle rect = reader.getPageSizeWithRotation(1);
                        image.setInitialWidth(rect.getWidth() * this._outputDevice.getDotsPerPoint());
                        image.setInitialHeight(rect.getHeight() * this._outputDevice.getDotsPerPoint());
                        imageResource = new ImageResource(uriStr, (FSImage)image);
                    }
                    catch (Throwable throwable) {
                        try {
                            cis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    cis.close();
                    return imageResource;
                }
                Image image = Image.getInstance((byte[])IOUtil.readBytes((InputStream)cis));
                this.scaleToOutputResolution(image);
                ImageResource imageResource = new ImageResource(uriStr, (FSImage)new ITextFSImage(image));
                cis.close();
                return imageResource;
            }
            catch (BadElementException | IOException | URISyntaxException e) {
                XRLog.exception((String)("Can't read image file; unexpected problem for URI '" + uriStr + "'"), (Throwable)e);
            }
        }
        return null;
    }

    private ImageResource loadEmbeddedBase64ImageResource(String uri) {
        try {
            byte[] buffer = ImageUtil.getEmbeddedBase64Image((String)uri);
            Image image = Image.getInstance((byte[])buffer);
            this.scaleToOutputResolution(image);
            return new ImageResource(null, (FSImage)new ITextFSImage(image));
        }
        catch (BadElementException | IOException e) {
            XRLog.exception((String)"Can't read XHTML embedded image.", (Throwable)e);
            return new ImageResource(null, null);
        }
    }

    private void scaleToOutputResolution(Image image) {
        float factor = this.dotsPerPixel;
        if (factor != 1.0f) {
            image.scaleAbsolute(image.getPlainWidth() * factor, image.getPlainHeight() * factor);
        }
    }
}

