/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.log4j;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.xhtmlrenderer.util.XRLog;
import org.xhtmlrenderer.util.XRLogger;

public class Log4JXRLogger
implements XRLogger {
    private static final String DEFAULT_LOGGER_NAME = "org.xhtmlrenderer.other";
    private static final Map LOGGER_NAME_MAP = new HashMap();
    private String defaultLoggerName = "org.xhtmlrenderer.other";
    private Map loggerNameMap = LOGGER_NAME_MAP;

    public void log(String where, java.util.logging.Level level, String msg) {
        LogManager.getLogger((String)this.getLoggerName(where)).log(this.toLog4JLevel(level), msg);
    }

    public void log(String where, java.util.logging.Level level, String msg, Throwable th) {
        LogManager.getLogger((String)this.getLoggerName(where)).log(this.toLog4JLevel(level), msg, th);
    }

    private Level toLog4JLevel(java.util.logging.Level level) {
        if (level == java.util.logging.Level.SEVERE) {
            return Level.ERROR;
        }
        if (level == java.util.logging.Level.WARNING) {
            return Level.WARN;
        }
        if (level == java.util.logging.Level.INFO) {
            return Level.INFO;
        }
        if (level == java.util.logging.Level.CONFIG) {
            return Level.INFO;
        }
        if (level == java.util.logging.Level.FINE || level == java.util.logging.Level.FINER || level == java.util.logging.Level.FINEST) {
            return Level.DEBUG;
        }
        return Level.INFO;
    }

    private String getLoggerName(String xrLoggerName) {
        String result = (String)this.loggerNameMap.get(xrLoggerName);
        if (result != null) {
            return result;
        }
        return this.defaultLoggerName;
    }

    public void setLevel(String logger, java.util.logging.Level level) {
        throw new UnsupportedOperationException("log4j should be not be configured here");
    }

    public Map getLoggerNameMap() {
        return this.loggerNameMap;
    }

    public void setLoggerNameMap(Map loggerNameMap) {
        this.loggerNameMap = loggerNameMap;
    }

    public String getDefaultLoggerName() {
        return this.defaultLoggerName;
    }

    public void setDefaultLoggerName(String defaultLoggerName) {
        this.defaultLoggerName = defaultLoggerName;
    }

    static {
        LOGGER_NAME_MAP.put(XRLog.CONFIG, "org.xhtmlrenderer.config");
        LOGGER_NAME_MAP.put(XRLog.EXCEPTION, "org.xhtmlrenderer.exception");
        LOGGER_NAME_MAP.put(XRLog.GENERAL, "org.xhtmlrenderer.general");
        LOGGER_NAME_MAP.put(XRLog.INIT, "org.xhtmlrenderer.init");
        LOGGER_NAME_MAP.put(XRLog.JUNIT, "org.xhtmlrenderer.junit");
        LOGGER_NAME_MAP.put(XRLog.LOAD, "org.xhtmlrenderer.load");
        LOGGER_NAME_MAP.put(XRLog.MATCH, "org.xhtmlrenderer.match");
        LOGGER_NAME_MAP.put(XRLog.CASCADE, "org.xhtmlrenderer.cascade");
        LOGGER_NAME_MAP.put(XRLog.XML_ENTITIES, "org.xhtmlrenderer.load.xmlentities");
        LOGGER_NAME_MAP.put(XRLog.CSS_PARSE, "org.xhtmlrenderer.cssparse");
        LOGGER_NAME_MAP.put(XRLog.LAYOUT, "org.xhtmlrenderer.layout");
        LOGGER_NAME_MAP.put(XRLog.RENDER, "org.xhtmlrenderer.render");
    }
}

