/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.log4j;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.xhtmlrenderer.util.XRLog;
import org.xhtmlrenderer.util.XRLogger;

public class Log4JXRLogger
implements XRLogger {
    private static final String DEFAULT_LOGGER_NAME = "org.xhtmlrenderer.other";
    private static final Map LOGGER_NAME_MAP = new HashMap();
    private String _defaultLoggerName = "org.xhtmlrenderer.other";
    private Map _loggerNameMap = LOGGER_NAME_MAP;

    public void log(String where, Level level, String msg) {
        Logger.getLogger((String)this.getLoggerName(where)).log((Priority)this.toLog4JLevel(level), (Object)msg);
    }

    public void log(String where, Level level, String msg, Throwable th) {
        Logger.getLogger((String)this.getLoggerName(where)).log((Priority)this.toLog4JLevel(level), (Object)msg, th);
    }

    private org.apache.log4j.Level toLog4JLevel(Level level) {
        if (level == Level.SEVERE) {
            return org.apache.log4j.Level.ERROR;
        }
        if (level == Level.WARNING) {
            return org.apache.log4j.Level.WARN;
        }
        if (level == Level.INFO) {
            return org.apache.log4j.Level.INFO;
        }
        if (level == Level.CONFIG) {
            return org.apache.log4j.Level.INFO;
        }
        if (level == Level.FINE || level == Level.FINER || level == Level.FINEST) {
            return org.apache.log4j.Level.DEBUG;
        }
        return org.apache.log4j.Level.INFO;
    }

    private String getLoggerName(String xrLoggerName) {
        String result = (String)this._loggerNameMap.get(xrLoggerName);
        if (result != null) {
            return result;
        }
        return this._defaultLoggerName;
    }

    public void setLevel(String logger, Level level) {
        throw new UnsupportedOperationException("log4j should be not be configured here");
    }

    public Map getLoggerNameMap() {
        return this._loggerNameMap;
    }

    public void setLoggerNameMap(Map loggerNameMap) {
        this._loggerNameMap = loggerNameMap;
    }

    public String getDefaultLoggerName() {
        return this._defaultLoggerName;
    }

    public void setDefaultLoggerName(String defaultLoggerName) {
        this._defaultLoggerName = defaultLoggerName;
    }

    static {
        LOGGER_NAME_MAP.put(XRLog.CONFIG, "org.xhtmlrenderer.config");
        LOGGER_NAME_MAP.put(XRLog.EXCEPTION, "org.xhtmlrenderer.exception");
        LOGGER_NAME_MAP.put(XRLog.GENERAL, "org.xhtmlrenderer.general");
        LOGGER_NAME_MAP.put(XRLog.INIT, "org.xhtmlrenderer.init");
        LOGGER_NAME_MAP.put(XRLog.JUNIT, "org.xhtmlrenderer.junit");
        LOGGER_NAME_MAP.put(XRLog.LOAD, "org.xhtmlrenderer.load");
        LOGGER_NAME_MAP.put(XRLog.MATCH, "org.xhtmlrenderer.match");
        LOGGER_NAME_MAP.put(XRLog.CASCADE, "org.xhtmlrenderer.cascade");
        LOGGER_NAME_MAP.put(XRLog.XML_ENTITIES, "org.xhtmlrenderer.load.xmlentities");
        LOGGER_NAME_MAP.put(XRLog.CSS_PARSE, "org.xhtmlrenderer.cssparse");
        LOGGER_NAME_MAP.put(XRLog.LAYOUT, "org.xhtmlrenderer.layout");
        LOGGER_NAME_MAP.put(XRLog.RENDER, "org.xhtmlrenderer.render");
    }
}

