/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.fop.nbsp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.xhtmlrenderer.fop.nbsp.NonBreakPointsLoader;

@ParametersAreNonnullByDefault
public class NonBreakPointsLoaderImpl
implements NonBreakPointsLoader {
    @Override
    @Nonnull
    @CheckReturnValue
    public List<String> loadNBSP(@Nullable String lang) {
        if (lang == null || lang.isEmpty()) {
            throw new IllegalArgumentException("Lang must be filled to search for file!");
        }
        List<String> result = this.loadForKey(lang);
        if (result == null) {
            int index = lang.indexOf(95);
            if (index < 0) {
                return Collections.emptyList();
            }
            result = this.loadForKey(lang.substring(0, index));
        }
        return result == null ? Collections.emptyList() : result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @CheckReturnValue
    private List<String> loadForKey(String lang) {
        String path = "non-break-spaces/" + lang + ".nbsp";
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);){
            String line;
            if (is == null) {
                List<String> list = null;
                return list;
            }
            BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            ArrayList<String> result = new ArrayList<String>();
            while ((line = r.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("#")) continue;
                result.add(line);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while loading nbsp file from path " + path, e);
        }
    }
}

