/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.fop;

import java.util.Arrays;
import java.util.TreeSet;
import org.apache.fop.hyphenation.Hyphenation;
import org.apache.fop.hyphenation.HyphenationTree;
import org.apache.fop.hyphenation.Hyphenator;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.fop.nbsp.NonBreakPointsEnhancer;
import org.xhtmlrenderer.layout.breaker.BreakPoint;
import org.xhtmlrenderer.layout.breaker.BreakPointsProvider;
import org.xhtmlrenderer.layout.breaker.LineBreakingStrategy;
import org.xhtmlrenderer.layout.breaker.ListBreakPointsProvider;
import org.xhtmlrenderer.layout.breaker.UrlAwareLineBreakIterator;

public class FOPLineBreakingStrategy
implements LineBreakingStrategy {
    private static final int SOFT_HYPHEN = 173;

    private TreeSet<BreakPoint> getPoints(String text, String lang, CalculatedStyle style) {
        int p;
        text = new NonBreakPointsEnhancer().enhance(text, lang);
        UrlAwareLineBreakIterator breakIt = new UrlAwareLineBreakIterator(text);
        TreeSet<BreakPoint> points = new TreeSet<BreakPoint>();
        while ((p = breakIt.next()) != -1) {
            points.add(new BreakPoint(p));
        }
        if (style.getHyphens() == IdentValue.NONE) {
            return points;
        }
        if (style.getHyphens() == IdentValue.MANUAL) {
            int index = text.indexOf(173);
            while (index >= 0) {
                BreakPoint point = new BreakPoint(index);
                this.addHyphen(point);
                points.add(point);
                index = text.indexOf(173, index + 1);
            }
            return points;
        }
        if (style.getHyphens() == IdentValue.AUTO) {
            HyphenationTree tree = Hyphenator.getFopHyphenationTree((String)lang);
            Hyphenation s = tree.hyphenate(text, 2, 2);
            if (s == null) {
                return points;
            }
            for (int i = 0; i < s.getHyphenationPoints().length; ++i) {
                int position = s.getHyphenationPoints()[i];
                BreakPoint point = new BreakPoint(position);
                this.addHyphen(point);
                points.add(point);
            }
        }
        return points;
    }

    public BreakPointsProvider getBreakPointsProvider(String text, String lang, CalculatedStyle style) {
        return new ListBreakPointsProvider(Arrays.asList(this.getPoints(text, lang, style).toArray(new BreakPoint[0])));
    }

    private void addHyphen(BreakPoint p) {
        p.setHyphen("-");
    }
}

