/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.fop.nbsp;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xhtmlrenderer.fop.nbsp.NonBreakPointsLoader;
import org.xhtmlrenderer.fop.nbsp.NonBreakPointsLoaderImpl;

public class NonBreakPointsEnhancer {
    private NonBreakPointsLoader loader;

    public NonBreakPointsEnhancer() {
        this(new NonBreakPointsLoaderImpl());
    }

    NonBreakPointsEnhancer(NonBreakPointsLoader loader) {
        this.loader = loader;
    }

    public String enhance(String input, String lang) {
        if (input == null) {
            return null;
        }
        if (input.isEmpty()) {
            return "";
        }
        if (lang == null || lang.isEmpty()) {
            return input;
        }
        List<String> rules = this.loader.loadNBSP(lang);
        if (rules == null) {
            return input;
        }
        for (String r : rules) {
            Matcher m = Pattern.compile(r).matcher(input);
            if (m.groupCount() != 3) {
                throw new IllegalArgumentException("Expression must contain exactly 3 groups! " + r);
            }
            if (!m.find()) continue;
            input = m.replaceAll("$1\u00a0$3");
        }
        return input;
    }
}

