/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.fop.nbsp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.xhtmlrenderer.fop.nbsp.NonBreakPointsLoader;

public class NonBreakPointsLoaderImpl
implements NonBreakPointsLoader {
    @Override
    public List<String> loadNBSP(String lang) {
        if (lang == null || lang.isEmpty()) {
            throw new IllegalArgumentException("Lang must be filled to search for file!");
        }
        List<String> result = this.loadForKey(lang);
        if (result == null) {
            int index = lang.indexOf(95);
            if (index < 0) {
                return null;
            }
            result = this.loadForKey(lang.substring(0, index));
        }
        return result;
    }

    private List<String> loadForKey(String lang) {
        String path = "non-break-spaces/" + lang + ".nbsp";
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (is == null) {
            return null;
        }
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            ArrayList<String> result = new ArrayList<String>();
            String line = null;
            while ((line = r.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("#")) continue;
                result.add(line);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while loading nbsp file from path " + path, e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }
}

