/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.fop.nbsp;

import com.google.errorprone.annotations.CheckReturnValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.fop.nbsp.NonBreakPointsLoader;

public class NonBreakPointsLoaderImpl
implements NonBreakPointsLoader {
    @Override
    @CheckReturnValue
    public List<String> loadNBSP(@Nullable String lang) {
        if (lang == null || lang.isEmpty()) {
            throw new IllegalArgumentException("Lang must be filled to search for file!");
        }
        List<String> result = this.loadForKey(lang);
        if (result == null) {
            int index = lang.indexOf(95);
            if (index < 0) {
                return Collections.emptyList();
            }
            result = this.loadForKey(lang.substring(0, index));
        }
        return result == null ? Collections.emptyList() : result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @CheckReturnValue
    private @Nullable List<String> loadForKey(String lang) {
        String path = "non-break-spaces/" + lang + ".nbsp";
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);){
            List<String> list;
            if (is == null) {
                List<String> list2 = null;
                return list2;
            }
            try (BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                list = r.lines().filter(line -> !line.isEmpty()).filter(line -> !line.startsWith("#")).toList();
            }
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while loading nbsp file from path " + path, e);
        }
    }
}

