/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.demo.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.xhtmlrenderer.demo.browser.BrowserStartup;
import org.xhtmlrenderer.demo.browser.ScaleFactor;
import org.xhtmlrenderer.demo.browser.actions.ZoomAction;
import org.xhtmlrenderer.swing.BasicPanel;
import org.xhtmlrenderer.swing.DOMInspector;
import org.xhtmlrenderer.swing.FSMouseListener;
import org.xhtmlrenderer.swing.LinkListener;
import org.xhtmlrenderer.swing.ScalableXHTMLPanel;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.Uu;

public class BrowserMenuBar
extends JMenuBar {
    private final BrowserStartup root;
    private JMenu file;
    private JMenu edit;
    private JMenu view;
    private JMenu go;
    private JMenu debug;
    private JMenu demos;
    private String lastDemoOpened;
    private Map<String, String> allDemos;
    private JMenu help;

    public BrowserMenuBar(BrowserStartup root) {
        this.root = root;
    }

    public void init() {
        this.file = new JMenu("Browser");
        this.file.setMnemonic('B');
        this.debug = new JMenu("Debug");
        this.debug.setMnemonic('U');
        this.demos = new JMenu("Demos");
        this.demos.setMnemonic('D');
        this.view = new JMenu("View");
        this.view.setMnemonic('V');
        this.help = new JMenu("Help");
        this.help.setMnemonic('H');
        JMenuItem view_source = new JMenuItem("Page Source");
        view_source.setEnabled(false);
        this.view.add(this.root.actions.stop);
        this.view.add(this.root.actions.refresh);
        this.view.add(this.root.actions.reload);
        this.view.add(new JSeparator());
        JMenu text_size = new JMenu("Text Size");
        text_size.setMnemonic('T');
        text_size.add(this.root.actions.increase_font);
        text_size.add(this.root.actions.decrease_font);
        text_size.add(new JSeparator());
        text_size.add(this.root.actions.reset_font);
        this.view.add(text_size);
        this.go = new JMenu("Go");
        this.go.setMnemonic('G');
    }

    public void createLayout() {
        ScalableXHTMLPanel panel = this.root.panel.view;
        this.file.add(this.root.actions.open_file);
        this.file.add(new JSeparator());
        this.file.add(this.root.actions.export_pdf);
        this.file.add(new JSeparator());
        this.file.add(this.root.actions.quit);
        this.add(this.file);
        JMenu zoom = new JMenu("Zoom");
        zoom.setMnemonic('Z');
        ScaleFactor[] factors = this.initializeScales();
        ButtonGroup zoomGroup = new ButtonGroup();
        for (ScaleFactor factor : factors) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(new ZoomAction(panel, factor));
            if (factor.isNotZoomed()) {
                item.setSelected(true);
            }
            zoomGroup.add(item);
            zoom.add(item);
        }
        this.view.add(new JSeparator());
        this.view.add(zoom);
        this.view.add(new JSeparator());
        this.view.add(new JCheckBoxMenuItem(this.root.actions.print_preview));
        this.add(this.view);
        this.go.add(this.root.actions.forward);
        this.go.add(this.root.actions.backward);
        this.add(this.go);
        this.demos.add(new NextDemoAction());
        this.demos.add(new PriorDemoAction());
        this.demos.add(new JSeparator());
        this.allDemos = new LinkedHashMap<String, String>();
        this.populateDemoList();
        for (Map.Entry entry : this.allDemos.entrySet()) {
            this.demos.add(new LoadAction((String)entry.getKey(), (String)entry.getValue()));
        }
        this.add(this.demos);
        JMenu debugShow = new JMenu("Show");
        this.debug.add(debugShow);
        debugShow.setMnemonic('S');
        debugShow.add(new JCheckBoxMenuItem(new BoxOutlinesAction()));
        debugShow.add(new JCheckBoxMenuItem(new LineBoxOutlinesAction()));
        debugShow.add(new JCheckBoxMenuItem(new InlineBoxesAction()));
        debugShow.add(new JCheckBoxMenuItem(new FontMetricsAction()));
        JMenu jMenu = new JMenu("Anti Aliasing");
        ButtonGroup anti_level = new ButtonGroup();
        this.addLevel(jMenu, anti_level, "None", -1);
        this.addLevel(jMenu, anti_level, "Low", 25).setSelected(true);
        this.addLevel(jMenu, anti_level, "Medium", 12);
        this.addLevel(jMenu, anti_level, "High", 0);
        this.debug.add(jMenu);
        this.debug.add(new ShowDOMInspectorAction());
        this.debug.add(new AbstractAction("Validation Console"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (BrowserMenuBar.this.root.validation_console == null) {
                    JFrame frame = BrowserMenuBar.this.root.validation_console = new JFrame("Validation Console");
                    JTextArea jta = new JTextArea();
                    BrowserMenuBar.this.root.error_handler.setTextArea(jta);
                    jta.setEditable(false);
                    jta.setLineWrap(true);
                    jta.setText("Validation Console: XML Parsing Error Messages");
                    frame.getContentPane().setLayout(new BorderLayout());
                    frame.getContentPane().add((Component)new JScrollPane(jta), "Center");
                    JButton close = new JButton("Close");
                    frame.getContentPane().add((Component)close, "South");
                    close.addActionListener(evt1 -> BrowserMenuBar.this.root.validation_console.setVisible(false));
                    frame.pack();
                    frame.setSize(400, 300);
                }
                BrowserMenuBar.this.root.validation_console.setVisible(true);
            }
        });
        this.debug.add(this.root.actions.generate_diff);
        this.add(this.debug);
        this.help.add(this.root.actions.usersManual);
        this.help.add(new JSeparator());
        this.help.add(this.root.actions.aboutPage);
        this.add(this.help);
    }

    private void populateDemoList() {
        ArrayList<String> demoList = new ArrayList<String>();
        URL url = BrowserMenuBar.class.getResource("/demos/file-list.txt");
        if (url != null) {
            try (InputStream is = url.openStream();){
                InputStreamReader reader = new InputStreamReader(is);
                try (LineNumberReader lnr = new LineNumberReader(reader);){
                    String line;
                    while ((line = lnr.readLine()) != null) {
                        demoList.add(line);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (String s : demoList) {
                String[] s1 = s.split(",");
                this.allDemos.put(s1[0], s1[1]);
            }
        }
    }

    private JRadioButtonMenuItem addLevel(JMenu menu, ButtonGroup group, String title, int level) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(new AntiAliasedAction(title, level));
        group.add(item);
        menu.add(item);
        return item;
    }

    public void createActions() {
        if (Configuration.isTrue((String)"xr.use.listeners", (boolean)true)) {
            List l = this.root.panel.view.getMouseTrackingListeners();
            for (FSMouseListener listener : l) {
                if (!(listener instanceof LinkListener)) continue;
                this.root.panel.view.removeMouseTrackingListener(listener);
            }
            this.root.panel.view.addMouseTrackingListener((FSMouseListener)new LinkListener(){

                public void linkClicked(BasicPanel panel, String uri) {
                    if (uri.startsWith("demoNav")) {
                        String pg = uri.split(":")[1];
                        if (pg.equals("back")) {
                            BrowserMenuBar.this.navigateToPriorDemo();
                        } else {
                            BrowserMenuBar.this.navigateToNextDemo();
                        }
                    } else {
                        super.linkClicked(panel, uri);
                    }
                }
            });
        }
    }

    private ScaleFactor[] initializeScales() {
        ScaleFactor[] scales = new ScaleFactor[11];
        int i = 0;
        scales[i++] = new ScaleFactor(1.0, "Normal (100%)");
        scales[i++] = new ScaleFactor(2.0, "200%");
        scales[i++] = new ScaleFactor(1.5, "150%");
        scales[i++] = new ScaleFactor(0.85, "85%");
        scales[i++] = new ScaleFactor(0.75, "75%");
        scales[i++] = new ScaleFactor(0.5, "50%");
        scales[i++] = new ScaleFactor(0.33, "33%");
        scales[i++] = new ScaleFactor(0.25, "25%");
        scales[i++] = new ScaleFactor(-2.0, "Page width");
        scales[i++] = new ScaleFactor(-3.0, "Page height");
        scales[i++] = new ScaleFactor(-4.0, "Whole page");
        return scales;
    }

    public void navigateToNextDemo() {
        String nextPage = null;
        Iterator<String> iter = this.allDemos.keySet().iterator();
        while (iter.hasNext()) {
            String s = iter.next();
            if (!s.equals(this.lastDemoOpened) || !iter.hasNext()) continue;
            nextPage = iter.next();
            break;
        }
        if (nextPage == null) {
            iter = this.allDemos.keySet().iterator();
            nextPage = iter.next();
        }
        try {
            this.root.panel.loadPage(this.allDemos.get(nextPage));
            this.lastDemoOpened = nextPage;
        }
        catch (Exception ex) {
            Uu.p((Object)ex);
        }
    }

    public void navigateToPriorDemo() {
        String priorPage = null;
        for (String s : this.allDemos.keySet()) {
            if (s.equals(this.lastDemoOpened)) break;
            priorPage = s;
        }
        if (priorPage == null) {
            Iterator<String> iterator = this.allDemos.keySet().iterator();
            while (iterator.hasNext()) {
                String s;
                priorPage = s = iterator.next();
            }
        }
        try {
            this.root.panel.loadPage(this.allDemos.get(priorPage));
            this.lastDemoOpened = priorPage;
        }
        catch (Exception ex) {
            Uu.p((Object)ex);
        }
    }

    final class NextDemoAction
    extends AbstractAction {
        NextDemoAction() {
            super("Next Demo Page");
            this.putValue("MnemonicKey", 78);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BrowserMenuBar.this.navigateToNextDemo();
        }
    }

    final class PriorDemoAction
    extends AbstractAction {
        PriorDemoAction() {
            super("Prior Demo Page");
            this.putValue("MnemonicKey", 80);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BrowserMenuBar.this.navigateToPriorDemo();
        }
    }

    class LoadAction
    extends AbstractAction {
        private final String url;
        private final String pageName;

        LoadAction(String name, String url) {
            super(name);
            this.pageName = name;
            this.url = url;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                BrowserMenuBar.this.root.panel.loadPage(this.url);
                BrowserMenuBar.this.lastDemoOpened = this.pageName;
            }
            catch (Exception ex) {
                Uu.p((Object)ex);
            }
        }
    }

    final class BoxOutlinesAction
    extends AbstractAction {
        BoxOutlinesAction() {
            super("Show Box Outlines");
            this.putValue("MnemonicKey", 66);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            BrowserMenuBar.this.root.panel.view.getSharedContext().setDebug_draw_boxes(!BrowserMenuBar.this.root.panel.view.getSharedContext().debugDrawBoxes());
            BrowserMenuBar.this.root.panel.view.repaint();
        }
    }

    final class LineBoxOutlinesAction
    extends AbstractAction {
        LineBoxOutlinesAction() {
            super("Show Line Box Outlines");
            this.putValue("MnemonicKey", 76);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            BrowserMenuBar.this.root.panel.view.getSharedContext().setDebug_draw_line_boxes(!BrowserMenuBar.this.root.panel.view.getSharedContext().debugDrawLineBoxes());
            BrowserMenuBar.this.root.panel.view.repaint();
        }
    }

    final class InlineBoxesAction
    extends AbstractAction {
        InlineBoxesAction() {
            super("Show Inline Boxes");
            this.putValue("MnemonicKey", 73);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            BrowserMenuBar.this.root.panel.view.getSharedContext().setDebug_draw_inline_boxes(!BrowserMenuBar.this.root.panel.view.getSharedContext().debugDrawInlineBoxes());
            BrowserMenuBar.this.root.panel.view.repaint();
        }
    }

    final class FontMetricsAction
    extends AbstractAction {
        FontMetricsAction() {
            super("Show Font Metrics");
            this.putValue("MnemonicKey", 70);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            BrowserMenuBar.this.root.panel.view.getSharedContext().setDebug_draw_font_metrics(!BrowserMenuBar.this.root.panel.view.getSharedContext().debugDrawFontMetrics());
            BrowserMenuBar.this.root.panel.view.repaint();
        }
    }

    final class ShowDOMInspectorAction
    extends AbstractAction {
        private DOMInspector inspector;
        private JFrame inspectorFrame;

        ShowDOMInspectorAction() {
            super("DOM Tree Inspector");
            this.putValue("MnemonicKey", 68);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.inspectorFrame == null) {
                this.inspectorFrame = new JFrame("DOM Tree Inspector");
            }
            if (this.inspector == null) {
                this.inspector = new DOMInspector(BrowserMenuBar.this.root.panel.view.getDocument(), BrowserMenuBar.this.root.panel.view.getSharedContext(), BrowserMenuBar.this.root.panel.view.getSharedContext().getCss());
                this.inspectorFrame.getContentPane().add((Component)this.inspector);
                this.inspectorFrame.pack();
                this.inspectorFrame.setSize(500, 600);
                this.inspectorFrame.setVisible(true);
            } else {
                this.inspector.setForDocument(BrowserMenuBar.this.root.panel.view.getDocument(), BrowserMenuBar.this.root.panel.view.getSharedContext(), BrowserMenuBar.this.root.panel.view.getSharedContext().getCss());
            }
            this.inspectorFrame.setVisible(true);
        }
    }

    class AntiAliasedAction
    extends AbstractAction {
        private final int fontSizeThreshold;

        AntiAliasedAction(String text, int fontSizeThreshold) {
            super(text);
            this.fontSizeThreshold = fontSizeThreshold;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            BrowserMenuBar.this.root.panel.view.getSharedContext().getTextRenderer().setSmoothingThreshold((float)this.fontSizeThreshold);
            BrowserMenuBar.this.root.panel.view.repaint();
        }
    }
}

