/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrintQuality;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import org.xhtmlrenderer.event.DocumentListener;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.swing.Java2DRenderer;
import org.xhtmlrenderer.swing.NaiveUserAgent;

@ParametersAreNonnullByDefault
public class Printer
implements Runnable,
DocumentListener,
Printable,
PrintJobListener {
    private static final String template = "printingtemplate.xhtml";
    private final String base;
    private final Logger log;
    private Thread runner;
    private Java2DRenderer j2dr;
    private final File file;
    private final UserAgentCallback uac;

    public Printer(File file) {
        this.file = file;
        this.log = LogManager.getLogManager().getLogger(Printer.class.getName());
        this.base = System.getProperty("user.dir") + File.separator + "config" + File.separator + "template" + File.separator;
        this.uac = new NaiveUserAgent();
        this.log.info("template printing");
        this.start();
    }

    public void start() {
        if (this.runner == null) {
            this.runner = new Thread((Runnable)this, "Runner");
            this.runner.start();
        }
    }

    @Override
    public void run() {
        File file = new File(this.base + template);
        try {
            if (file.exists()) {
                this.log.info("loading template from: " + file.getName());
                this.log.fine("--------------------------------");
                DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
                HashPrintRequestAttributeSet attrs = new HashPrintRequestAttributeSet();
                attrs.add(OrientationRequested.PORTRAIT);
                attrs.add(PrintQuality.HIGH);
                attrs.add(new JobName(file.getName() + ".rio", null));
                PrintService service = PrintServiceLookup.lookupDefaultPrintService();
                if (service != null) {
                    this.log.info("printer selected : " + service.getName());
                    DocPrintJob job = service.createPrintJob();
                    job.addPrintJobListener(this);
                    PrintJobAttributeSet attributes = job.getAttributes();
                    Attribute[] arr = attributes.toArray();
                    for (int i = 0; i < arr.length; ++i) {
                        this.log.fine("arr[" + i + "]= " + arr[0].getName());
                    }
                    SimpleDoc sdoc = new SimpleDoc(this, flavor, null);
                    SharedContext ctx = new SharedContext(this.uac);
                    ctx.setBaseURL(this.base);
                    job.print(sdoc, attrs);
                } else {
                    this.log.info("printer selection cancelled");
                }
            } else {
                this.log.severe("file " + file.getName() + " doesn't exist");
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "error loading file " + file.getName(), e);
            e.printStackTrace();
        }
        this.runner = null;
    }

    public static void main(String[] args) {
        System.out.println("test program for template printing");
        if (args.length > 0) {
            File file = new File(args[0]);
            System.out.println("printing file: " + file.getName());
            if (file.exists()) {
                new Printer(file);
            } else {
                System.out.println("file " + file.getAbsolutePath() + " doesn't exist!");
            }
        } else {
            System.out.println("usage: <filename>");
        }
    }

    public void documentStarted() {
    }

    public void documentLoaded() {
        this.log.info("document loaded");
    }

    public void onLayoutException(Throwable t) {
    }

    public void onRenderException(Throwable t) {
    }

    @Override
    public int print(Graphics graphics, PageFormat pf, int pi) {
        this.log.info("print");
        try {
            if (this.j2dr == null) {
                this.j2dr = new Java2DRenderer(this.file, 1024);
                SharedContext context = this.j2dr.getSharedContext();
                context.setPrint(true);
                context.setInteractive(false);
                context.setDPI(72.0f);
                context.getTextRenderer().setSmoothingThreshold(0.0f);
            }
            return 0;
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "error while printing: ", ex);
            return 1;
        }
    }

    @Override
    public void printDataTransferCompleted(PrintJobEvent pje) {
        this.log.info("print data transfer completed");
    }

    @Override
    public void printJobCanceled(PrintJobEvent pje) {
        this.log.info("print job cancelled");
    }

    @Override
    public void printJobCompleted(PrintJobEvent pje) {
        this.log.info("print job completed");
    }

    @Override
    public void printJobFailed(PrintJobEvent pje) {
        this.log.severe("print job failed");
    }

    @Override
    public void printJobNoMoreEvents(PrintJobEvent pje) {
        this.log.info("print job no more events");
    }

    @Override
    public void printJobRequiresAttention(PrintJobEvent pje) {
        this.log.info("print job requires attention");
    }
}

