/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xhtmlrenderer.extend.FSCanvas;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.swing.AWTFSImage;
import org.xhtmlrenderer.swing.SwingReplacedElement;
import org.xhtmlrenderer.swing.SwingReplacedElementFactory;
import org.xhtmlrenderer.util.XRLog;

public class ImageMapReplacedElementFactory
extends SwingReplacedElementFactory {
    private final ImageMapListener listener;
    private static final String IMG_USEMAP_ATTR = "usemap";
    private static final String MAP_ELT = "map";
    private static final String MAP_NAME_ATTR = "name";
    private static final String AREA_ELT = "area";
    private static final String AREA_SHAPE_ATTR = "shape";
    private static final String AREA_COORDS_ATTR = "coords";
    private static final String AREA_HREF_ATTR = "href";
    private static final String RECT_SHAPE = "rect";
    private static final String RECTANGLE_SHAPE = "rectangle";
    private static final String CIRC_SHAPE = "circ";
    private static final String CIRCLE_SHAPE = "circle";
    private static final String POLY_SHAPE = "poly";
    private static final String POLYGON_SHAPE = "polygon";

    public ImageMapReplacedElementFactory(ImageMapListener listener) {
        super(null);
        if (null == listener) {
            throw new IllegalArgumentException("listener required");
        }
        this.listener = listener;
    }

    public ReplacedElement createReplacedElement(LayoutContext context, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        Element e = box.getElement();
        if (e == null) {
            return null;
        }
        if (context.getNamespaceHandler().isImageElement(e)) {
            String usemapAttr = context.getNamespaceHandler().getAttributeValue(e, IMG_USEMAP_ATTR);
            if (this.isNotBlank(usemapAttr)) {
                FSCanvas canvas;
                ReplacedElement re = this.replaceImageMap(uac, context, e, usemapAttr, cssWidth, cssHeight);
                if (context.isInteractive() && re instanceof SwingReplacedElement && (canvas = context.getCanvas()) instanceof JComponent) {
                    ((JComponent)canvas).add(((SwingReplacedElement)re).getJComponent());
                }
                return re;
            }
            return this.replaceImage(uac, context, e, cssWidth, cssHeight);
        }
        return null;
    }

    private boolean isNotBlank(String _v) {
        if (_v == null || _v.isEmpty()) {
            return false;
        }
        for (int i = 0; i < _v.length(); ++i) {
            if (Character.isWhitespace(_v.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected ReplacedElement replaceImageMap(UserAgentCallback uac, LayoutContext context, Element elem, String usemapAttr, int cssWidth, int cssHeight) {
        Object re = this.lookupImageReplacedElement(elem, "");
        if (re == null) {
            BufferedImage im = null;
            String imageSrc = context.getNamespaceHandler().getImageSourceURI(elem);
            if (imageSrc == null || imageSrc.isEmpty()) {
                XRLog.layout((Level)Level.WARNING, (String)"No source provided for img element.");
                re = this.newIrreplaceableImageElement(cssWidth, cssHeight);
            } else {
                FSImage fsImage = uac.getImageResource(imageSrc).getImage();
                if (fsImage != null) {
                    im = ((AWTFSImage)fsImage).getImage();
                }
                if (im != null) {
                    String mapName = usemapAttr.substring(1);
                    Node map = elem.getOwnerDocument().getElementById(mapName);
                    if (null == map) {
                        NodeList maps = elem.getOwnerDocument().getElementsByTagName(MAP_ELT);
                        for (int i = 0; i < maps.getLength(); ++i) {
                            String mapAttr = ImageMapReplacedElement.getAttribute(maps.item(i).getAttributes(), MAP_NAME_ATTR);
                            if (!ImageMapReplacedElementFactory.areEqual(mapName, mapAttr)) continue;
                            map = maps.item(i);
                            break;
                        }
                        if (null == map) {
                            XRLog.layout((Level)Level.INFO, (String)("No map named: '" + mapName + "'"));
                        }
                    }
                    re = new ImageMapReplacedElement(im, map, cssWidth, cssHeight, this.listener);
                } else {
                    re = this.newIrreplaceableImageElement(cssWidth, cssHeight);
                }
            }
            this.storeImageReplacedElement(elem, (ReplacedElement)re, "", -1, -1);
        }
        return re;
    }

    private static boolean areEqual(String str1, String str2) {
        return str1 == null && str2 == null || str1 != null && str1.equals(str2);
    }

    private static boolean areEqualIgnoreCase(String str1, String str2) {
        return str1 == null && str2 == null || str1 != null && str1.equalsIgnoreCase(str2);
    }

    private static final class ImageMapReplacedElement
    extends SwingReplacedElement {
        private final Map<Shape, String> areas;

        private ImageMapReplacedElement(Image image, Node map, int targetWidth, int targetHeight, final ImageMapListener listener) {
            super(ImageMapReplacedElement.create(image, targetWidth, targetHeight));
            this.areas = ImageMapReplacedElement.parseMap(map);
            this.getJComponent().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Point point = e.getPoint();
                    Set set = areas.entrySet();
                    for (Map.Entry entry : set) {
                        if (!((Shape)entry.getKey()).contains(point)) continue;
                        listener.areaClicked(new ImageMapEvent(this, (String)entry.getValue()));
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    this.getJComponent().setCursor(Cursor.getDefaultCursor());
                }
            });
            this.getJComponent().addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    JComponent c = this.getJComponent();
                    Point point = e.getPoint();
                    Set set = areas.entrySet();
                    for (Map.Entry entry : set) {
                        if (!((Shape)entry.getKey()).contains(point)) continue;
                        ImageMapReplacedElement.updateCursor(c, Cursor.getPredefinedCursor(12));
                        return;
                    }
                    ImageMapReplacedElement.updateCursor(c, Cursor.getDefaultCursor());
                }
            });
        }

        private static void updateCursor(JComponent c, Cursor cursor) {
            if (!c.getCursor().equals(cursor)) {
                c.setCursor(cursor);
            }
        }

        private static Map<Shape, String> parseMap(Node map) {
            if (null == map) {
                return Collections.emptyMap();
            }
            if (map.hasChildNodes()) {
                NodeList children = map.getChildNodes();
                HashMap<Shape, String> areas = new HashMap<Shape, String>(children.getLength());
                for (int i = 0; i < children.getLength(); ++i) {
                    Shape shape;
                    Node area = children.item(i);
                    if (!ImageMapReplacedElementFactory.areEqualIgnoreCase(ImageMapReplacedElementFactory.AREA_ELT, area.getNodeName()) || !area.hasAttributes()) continue;
                    NamedNodeMap attrs = area.getAttributes();
                    String shapeAttr = ImageMapReplacedElement.getAttribute(attrs, ImageMapReplacedElementFactory.AREA_SHAPE_ATTR);
                    String[] coords = ImageMapReplacedElement.getAttribute(attrs, ImageMapReplacedElementFactory.AREA_COORDS_ATTR).split(",");
                    String href = ImageMapReplacedElement.getAttribute(attrs, ImageMapReplacedElementFactory.AREA_HREF_ATTR);
                    if (ImageMapReplacedElementFactory.areEqualIgnoreCase(ImageMapReplacedElementFactory.RECT_SHAPE, shapeAttr) || ImageMapReplacedElementFactory.areEqualIgnoreCase(ImageMapReplacedElementFactory.RECTANGLE_SHAPE, shapeAttr)) {
                        shape = ImageMapReplacedElement.getCoords(coords, 4);
                        if (null == shape) continue;
                        areas.put(shape, href);
                        continue;
                    }
                    if (ImageMapReplacedElementFactory.areEqualIgnoreCase(ImageMapReplacedElementFactory.CIRC_SHAPE, shapeAttr) || ImageMapReplacedElementFactory.areEqualIgnoreCase(ImageMapReplacedElementFactory.CIRCLE_SHAPE, shapeAttr)) {
                        shape = ImageMapReplacedElement.getCoords(coords, 3);
                        if (null == shape) continue;
                        areas.put(shape, href);
                        continue;
                    }
                    if (ImageMapReplacedElementFactory.areEqualIgnoreCase(ImageMapReplacedElementFactory.POLY_SHAPE, shapeAttr) || ImageMapReplacedElementFactory.areEqualIgnoreCase(ImageMapReplacedElementFactory.POLYGON_SHAPE, shapeAttr)) {
                        shape = ImageMapReplacedElement.getCoords(coords, -1);
                        if (null == shape) continue;
                        areas.put(shape, href);
                        continue;
                    }
                    if (!XRLog.isLoggingEnabled()) continue;
                    XRLog.layout((Level)Level.INFO, (String)("Unsupported shape: '" + shapeAttr + "'"));
                }
                return areas;
            }
            return Collections.emptyMap();
        }

        private static String getAttribute(NamedNodeMap attrs, String attrName) {
            Node node = attrs.getNamedItem(attrName);
            return null == node ? null : node.getNodeValue();
        }

        private static Shape getCoords(String[] coordValues, int length) {
            if (-1 == length && 0 == coordValues.length % 2 || length == coordValues.length) {
                int[] coords = new int[coordValues.length];
                int i = 0;
                for (String coord : coordValues) {
                    try {
                        coords[i++] = Integer.parseInt(coord.trim());
                    }
                    catch (NumberFormatException e) {
                        XRLog.layout((Level)Level.WARNING, (String)"Error while parsing shape coords", (Throwable)e);
                        return null;
                    }
                }
                if (4 == length) {
                    return new Rectangle2D.Float(coords[0], coords[1], coords[2] - coords[0], coords[3] - coords[1]);
                }
                if (3 == length) {
                    int radius = coords[2];
                    return new Ellipse2D.Float(coords[0] - radius, coords[1] - radius, radius * 2, radius * 2);
                }
                if (-1 == length) {
                    int npoints = coords.length / 2;
                    int[] xpoints = new int[npoints];
                    int[] ypoints = new int[npoints];
                    int c = 0;
                    for (int p = 0; p < npoints; ++p) {
                        xpoints[p] = coords[c++];
                        ypoints[p] = coords[c++];
                    }
                    return new Polygon(xpoints, ypoints, npoints);
                }
                XRLog.layout((Level)Level.INFO, (String)("Unsupported shape: '" + length + "'"));
                return null;
            }
            return null;
        }

        private static JComponent create(Image image, int targetWidth, int targetHeight) {
            JLabel component = new JLabel(new ImageIcon(image));
            component.setSize(component.getPreferredSize());
            return component;
        }
    }
}

