/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.demo.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.xhtmlrenderer.demo.browser.BrowserStartup;
import org.xhtmlrenderer.demo.browser.EmptyAction;
import org.xhtmlrenderer.demo.browser.PanelManager;
import org.xhtmlrenderer.demo.browser.actions.FontSizeAction;
import org.xhtmlrenderer.demo.browser.actions.GenerateDiffAction;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.swing.RepaintListener;
import org.xhtmlrenderer.util.Uu;

public class BrowserActions {
    public Action open_file;
    public Action export_pdf;
    public Action quit;
    public Action print;
    public Action forward;
    public Action backward;
    public Action refresh;
    public Action reload;
    public Action load;
    public Action stop;
    public Action print_preview;
    public Action goHome;
    public Action generate_diff;
    public Action usersManual;
    public Action aboutPage;
    public BrowserStartup root;
    public Action increase_font;
    public Action decrease_font;
    public Action reset_font;
    public Action goToPage;
    public static final Logger logger = Logger.getLogger("app.browser");

    public BrowserActions(BrowserStartup root) {
        this.root = root;
    }

    public void init() {
        URL url = BrowserActions.getImageUrl("images/process-stop.png");
        this.stop = new AbstractAction("Stop", new ImageIcon(url)){

            @Override
            public void actionPerformed(ActionEvent evt) {
                System.out.println("stop called");
            }
        };
        this.stop.putValue("MnemonicKey", 83);
        this.open_file = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserActions.this.openAndShowFile();
            }
        };
        this.open_file.putValue("Name", "Open File...");
        BrowserActions.setAccel(this.open_file, 79);
        BrowserActions.setMnemonic(this.open_file, 79);
        this.export_pdf = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserActions.this.exportToPdf();
            }
        };
        this.export_pdf.putValue("Name", "Export PDF...");
        try {
            Class.forName("com.lowagie.text.DocumentException");
        }
        catch (ClassNotFoundException ignore) {
            this.export_pdf.setEnabled(false);
        }
        this.quit = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                System.exit(0);
            }
        };
        BrowserActions.setName(this.quit, "Quit");
        BrowserActions.setAccel(this.quit, 81);
        BrowserActions.setMnemonic(this.quit, 81);
        url = BrowserActions.getImageUrl("images/go-previous.png");
        this.backward = new EmptyAction("Back", "Go back one page", new ImageIcon(url)){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    BrowserActions.this.root.panel.goBack();
                    BrowserActions.this.root.panel.view.repaint();
                }
                catch (Exception ex) {
                    Uu.p((Object)ex);
                }
            }
        };
        this.backward.setEnabled(false);
        this.backward.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, 8));
        url = BrowserActions.getImageUrl("images/go-next.png");
        this.forward = new EmptyAction("Forward", "Go forward one page", new ImageIcon(url)){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    BrowserActions.this.root.panel.goForward();
                    BrowserActions.this.root.panel.view.repaint();
                }
                catch (Exception ex) {
                    Uu.p((Object)ex);
                }
            }
        };
        this.forward.setEnabled(false);
        this.forward.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, 8));
        url = BrowserActions.getImageUrl("images/view-refresh.png");
        this.refresh = new EmptyAction("Refresh", "Refresh page", new ImageIcon(url)){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    BrowserActions.this.root.panel.view.invalidate();
                    BrowserActions.this.root.panel.view.repaint();
                }
                catch (Exception ex) {
                    Uu.p((Object)ex);
                }
            }
        };
        this.refresh.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F5"));
        url = BrowserActions.getImageUrl("images/view-refresh.png");
        this.reload = new EmptyAction("Reload", "Reload page", new ImageIcon(url)){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    BrowserActions.this.root.panel.reloadPage();
                    BrowserActions.this.root.panel.view.repaint();
                }
                catch (Exception ex) {
                    Uu.p((Object)ex);
                }
            }
        };
        this.reload.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 1));
        this.reload.putValue("MnemonicKey", 82);
        this.print_preview = new EmptyAction("Print Preview", "Print preview mode", null){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserActions.this.togglePrintPreview();
            }
        };
        this.print_preview.putValue("MnemonicKey", 86);
        this.load = new AbstractAction("Load"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    String url_text = BrowserActions.this.root.panel.url.getText();
                    BrowserActions.this.root.panel.loadPage(url_text);
                    BrowserActions.this.root.panel.view.repaint();
                }
                catch (Exception ex) {
                    Uu.p((Object)ex);
                }
            }
        };
        url = BrowserActions.getImageUrl("images/media-playback-start_16x16.png");
        this.goToPage = new EmptyAction("Go", "Go to URL in address bar", new ImageIcon(url)){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    String url_text = BrowserActions.this.root.panel.url.getText();
                    BrowserActions.this.root.panel.loadPage(url_text);
                    BrowserActions.this.root.panel.view.repaint();
                }
                catch (Exception ex) {
                    Uu.p((Object)ex);
                }
            }
        };
        url = BrowserActions.getImageUrl("images/go-home.png");
        this.goHome = new EmptyAction("Go Home", "Browser homepage", new ImageIcon(url)){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    BrowserActions.this.root.panel.loadPage(BrowserActions.this.root.startPage);
                    BrowserActions.this.root.panel.view.repaint();
                }
                catch (Exception ex) {
                    Uu.p((Object)ex);
                }
            }
        };
        this.usersManual = new EmptyAction("FS User's Guide", "Flying Saucer User's Guide", null){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    BrowserActions.this.root.panel.loadPage("/users-guide-r8.html");
                    BrowserActions.this.root.panel.view.repaint();
                }
                catch (Exception ex) {
                    Uu.p((Object)ex);
                }
            }
        };
        this.aboutPage = new EmptyAction("About", "About the Browser Demo", null){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    BrowserActions.this.showAboutDialog();
                }
                catch (Exception ex) {
                    Uu.p((Object)ex);
                }
            }
        };
        this.generate_diff = new GenerateDiffAction(this.root);
        this.increase_font = new FontSizeAction(this.root, 1);
        this.increase_font.putValue("AcceleratorKey", KeyStroke.getKeyStroke(521, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.increase_font.putValue("MnemonicKey", 73);
        this.reset_font = new FontSizeAction(this.root, 2);
        this.reset_font.putValue("AcceleratorKey", KeyStroke.getKeyStroke(48, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.reset_font.putValue("MnemonicKey", 78);
        this.decrease_font = new FontSizeAction(this.root, 0);
        this.decrease_font.putValue("AcceleratorKey", KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.decrease_font.putValue("MnemonicKey", 68);
        BrowserActions.setName(this.increase_font, "Increase");
        BrowserActions.setName(this.reset_font, "Normal");
        BrowserActions.setName(this.decrease_font, "Decrease");
    }

    private void showAboutDialog() {
        final JDialog aboutDlg = new JDialog(this.root.frame);
        aboutDlg.setSize(new Dimension(500, 450));
        PanelManager uac = new PanelManager();
        XHTMLPanel panel = new XHTMLPanel((UserAgentCallback)uac);
        uac.setRepaintListener((RepaintListener)panel);
        panel.setOpaque(false);
        panel.setDocument("demo:/demos/about.xhtml");
        JPanel outer = new JPanel(new BorderLayout());
        outer.add((Component)panel, "Center");
        JButton btn = new JButton(new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                aboutDlg.dispose();
            }
        });
        SwingUtilities.invokeLater(btn::requestFocusInWindow);
        JPanel control = new JPanel(new FlowLayout(2));
        control.add(btn);
        outer.add((Component)control, "South");
        aboutDlg.getContentPane().setLayout(new BorderLayout());
        aboutDlg.getContentPane().add((Component)outer, "Center");
        aboutDlg.setTitle("About the Browser Demo");
        int xx = (this.root.frame.getWidth() - aboutDlg.getWidth()) / 2;
        int yy = (this.root.frame.getHeight() - aboutDlg.getHeight()) / 2;
        aboutDlg.setLocation(xx, yy);
        aboutDlg.setModal(true);
        aboutDlg.setVisible(true);
    }

    private void togglePrintPreview() {
        try {
            SharedContext sharedContext = this.root.panel.view.getSharedContext();
            if (sharedContext.isPrint()) {
                sharedContext.setPrint(false);
                sharedContext.setInteractive(true);
            } else {
                sharedContext.setPrint(true);
                sharedContext.setInteractive(false);
            }
            this.print_preview.putValue("ShortDescription", !sharedContext.isPrint() ? "Print preview" : "Normal view");
            this.root.panel.reloadPage();
            this.root.panel.view.repaint();
        }
        catch (Exception ex) {
            Uu.p((Object)ex);
        }
    }

    private void openAndShowFile() {
        try {
            FileDialog fd = new FileDialog((Frame)this.root.frame, "Open a local file", 0);
            fd.setVisible(true);
            if (fd.getFile() != null) {
                String url = new File(fd.getDirectory(), fd.getFile()).toURI().toURL().toString();
                this.root.panel.loadPage(url);
            }
        }
        catch (Exception ex) {
            logger.info("error:" + ex);
        }
    }

    private void exportToPdf() {
        try {
            FileDialog fd = new FileDialog((Frame)this.root.frame, "Save as PDF", 1);
            fd.setVisible(true);
            if (fd.getFile() != null) {
                File outTarget = new File(fd.getDirectory(), fd.getFile());
                this.root.panel.exportToPdf(outTarget.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            logger.info("error:" + ex);
        }
    }

    public static void setName(Action act, String name) {
        act.putValue("Name", name);
    }

    public static void setAccel(Action act, int key) {
        act.putValue("AcceleratorKey", KeyStroke.getKeyStroke(key, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    public static void setMnemonic(Action act, Integer mnem) {
        act.putValue("MnemonicKey", mnem);
    }

    public static URL getImageUrl(String url) {
        return BrowserActions.class.getClassLoader().getResource(url);
    }
}

