/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;

public class VerifyGlyphExists {
    public static void main(String[] args) {
        if (args.length != 2) {
            VerifyGlyphExists.error("Need two arguments: code point (int) and either a font file name, or a path to a text file listing font paths");
        }
        int codePoint = 0;
        try {
            codePoint = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            VerifyGlyphExists.error("Value " + args[0] + " for codepoint is not an integer.");
        }
        File file = new File(args[1]);
        if (file.exists()) {
            if (file.getName().endsWith("txt")) {
                List<String> lines = VerifyGlyphExists.readLines(file);
                for (String path : lines) {
                    VerifyGlyphExists.testForGlyph(codePoint, new File(path));
                }
                System.out.println("TODO: read list of fonts");
            } else {
                VerifyGlyphExists.testForGlyph(codePoint, file);
            }
        } else {
            VerifyGlyphExists.error("Second argument must be a font file path, or a path to a text file listing font file paths");
        }
    }

    private static List<String> readLines(File file) {
        ArrayList<String> l = new ArrayList<String>();
        try (LineNumberReader r = new LineNumberReader(new BufferedReader(new FileReader(file)));){
            String path;
            while ((path = r.readLine()) != null) {
                l.add(path);
            }
        }
        catch (IOException e) {
            VerifyGlyphExists.error("Can't read list of font paths from " + file.getPath());
        }
        return l;
    }

    private static void testForGlyph(int codePoint, File file) {
        try {
            Font font = VerifyGlyphExists.loadFont(file.getCanonicalPath());
            if (font == null) {
                VerifyGlyphExists.error("Could not load font at path: " + file.getPath());
            } else {
                String msg = "%s&#%d; for %s from %s";
                String found = "NO GLYPH ";
                if (!Character.isValidCodePoint(codePoint)) {
                    found = "INVALID  ";
                } else if (font.canDisplay((char)codePoint)) {
                    found = "FOUND    ";
                }
                System.out.printf("%s&#%d; for %s from %s", found, codePoint, font, file.getPath());
            }
        }
        catch (IOException e) {
            VerifyGlyphExists.error("Can't load font at path " + file.getPath() + ", err: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Font loadFont(String fontPath) throws IOException {
        try (InputStream s = new File(fontPath).toURL().openStream();){
            boolean format = false;
            Font font2 = Font.createFont(0, s);
            Font font = font2.deriveFont(0, 12.0f);
            return font;
        }
        catch (FontFormatException e) {
            System.err.println(fontPath + " INVALID FONT FORMAT " + e.getMessage());
            return null;
        }
    }

    private static void error(String msg) {
        System.err.println(msg);
        System.exit(-1);
    }
}

