/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.demo.browser;

import java.awt.BorderLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BrowserStatus
extends JPanel {
    private static final long serialVersionUID = 1L;
    public JLabel text;
    public JLabel memory;

    public void init() {
        this.createComponents();
        this.createLayout();
        this.createEvents();
    }

    public void createComponents() {
        this.text = new JLabel("Status");
        this.memory = new JLabel("? MB / ? MB");
    }

    public void createLayout() {
        this.setLayout(new BorderLayout(5, 5));
        this.add("Center", this.text);
        this.add("East", this.memory);
    }

    @Override
    public Insets getInsets() {
        return new Insets(3, 4, 3, 4);
    }

    public void createEvents() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        Runtime rt = Runtime.getRuntime();
                        long used = rt.totalMemory() - rt.freeMemory();
                        long total = rt.totalMemory();
                        final String text = (used /= 0x100000L) + "M / " + (total /= 0x100000L) + "M";
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BrowserStatus.this.memory.setText(text);
                            }
                        });
                        Thread.sleep(5000L);
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }).start();
    }
}

