/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.demo.browser;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.xhtmlrenderer.demo.browser.BrowserStartup;
import org.xhtmlrenderer.demo.browser.EmptyAction;
import org.xhtmlrenderer.demo.browser.PanelManager;
import org.xhtmlrenderer.demo.browser.actions.FontSizeAction;
import org.xhtmlrenderer.demo.browser.actions.GenerateDiffAction;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.swing.RepaintListener;
import org.xhtmlrenderer.util.Uu;

public class BrowserActions {
    private static final Logger logger = Logger.getLogger("app.browser");
    final Action open_file;
    final Action export_pdf;
    final Action quit;
    final Action forward;
    final Action backward;
    final Action refresh;
    final Action reload;
    final Action load;
    final Action print_preview;
    final Action goHome;
    final Action generate_diff;
    final Action usersManual;
    final Action aboutPage;
    private final BrowserStartup root;
    final Action increase_font;
    final Action decrease_font;
    final Action reset_font;
    final Action goToPage;

    public BrowserActions(BrowserStartup root, String startPage) {
        this.root = root;
        this.open_file = this.action("Open File...", e -> this.openAndShowFile());
        BrowserActions.setAccel(this.open_file, 79);
        BrowserActions.setMnemonic(this.open_file, 79);
        this.export_pdf = this.action("Export PDF...", e -> this.exportToPdf());
        this.export_pdf.setEnabled(this.isOpenPdfInClasspath());
        this.quit = this.action("Quit", e -> System.exit(0));
        BrowserActions.setAccel(this.quit, 81);
        BrowserActions.setMnemonic(this.quit, 81);
        this.backward = new EmptyAction("Back", "Go back one page", BrowserActions.imageIcon("images/go-previous.png"), e -> {
            root.panel.goBack();
            root.panel.view.repaint();
        });
        this.backward.setEnabled(false);
        this.backward.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, 512));
        this.forward = new EmptyAction("Forward", "Go forward one page", BrowserActions.imageIcon("images/go-next.png"), e -> {
            root.panel.goForward();
            root.panel.view.repaint();
        });
        this.forward.setEnabled(false);
        this.forward.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, 512));
        this.refresh = new EmptyAction("Refresh", "Refresh page", BrowserActions.imageIcon("images/view-refresh.png"), e -> {
            root.panel.view.invalidate();
            root.panel.view.repaint();
        });
        this.refresh.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F5"));
        this.reload = new EmptyAction("Reload", "Reload page", BrowserActions.imageIcon("images/view-refresh.png"), e -> {
            root.panel.reloadPage();
            root.panel.view.repaint();
        });
        this.reload.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 64));
        this.reload.putValue("MnemonicKey", 82);
        this.print_preview = new EmptyAction("Print Preview", "Print preview mode", null, e -> this.togglePrintPreview());
        this.print_preview.putValue("MnemonicKey", 86);
        this.load = this.action("Load", e -> {
            String url_text = root.panel.url.getText();
            root.panel.loadPage(url_text);
            root.panel.view.repaint();
        });
        this.goToPage = new EmptyAction("Go", "Go to URL in address bar", BrowserActions.imageIcon("images/media-playback-start_16x16.png"), e -> {
            String url_text = root.panel.url.getText();
            root.panel.loadPage(url_text);
            root.panel.view.repaint();
        });
        this.goHome = new EmptyAction("Go Home", "Browser homepage", BrowserActions.imageIcon("images/go-home.png"), e -> {
            root.panel.loadPage(startPage);
            root.panel.view.repaint();
        });
        this.usersManual = new EmptyAction("FS User's Guide", "Flying Saucer User's Guide", null, e -> {
            root.panel.loadPage("/users-guide-r8.html");
            root.panel.view.repaint();
        });
        this.aboutPage = new EmptyAction("About", "About the Browser Demo", null, e -> this.showAboutDialog());
        this.generate_diff = new GenerateDiffAction(root);
        this.increase_font = new FontSizeAction("Increase", root, FontSizeAction.FontSizeChange.INCREMENT);
        this.increase_font.putValue("AcceleratorKey", KeyStroke.getKeyStroke(521, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        this.increase_font.putValue("MnemonicKey", 73);
        this.reset_font = new FontSizeAction("Normal", root, FontSizeAction.FontSizeChange.RESET);
        this.reset_font.putValue("AcceleratorKey", KeyStroke.getKeyStroke(48, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        this.reset_font.putValue("MnemonicKey", 78);
        this.decrease_font = new FontSizeAction("Decrease", root, FontSizeAction.FontSizeChange.DECREMENT);
        this.decrease_font.putValue("AcceleratorKey", KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        this.decrease_font.putValue("MnemonicKey", 68);
    }

    @CheckReturnValue
    private boolean isOpenPdfInClasspath() {
        try {
            Class.forName("com.lowagie.text.DocumentException");
            return true;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }

    private void showAboutDialog() {
        final JDialog aboutDlg = new JDialog(this.root.frame);
        aboutDlg.setSize(new Dimension(500, 450));
        PanelManager uac = new PanelManager();
        XHTMLPanel panel = new XHTMLPanel((UserAgentCallback)uac);
        uac.setRepaintListener((RepaintListener)panel);
        panel.setOpaque(false);
        panel.setDocument("demo:/demos/about.xhtml");
        JPanel outer = new JPanel(new BorderLayout());
        outer.add((Component)panel, "Center");
        JButton btn = new JButton(new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                aboutDlg.dispose();
            }
        });
        SwingUtilities.invokeLater(btn::requestFocusInWindow);
        JPanel control = new JPanel(new FlowLayout(2));
        control.add(btn);
        outer.add((Component)control, "South");
        aboutDlg.getContentPane().setLayout(new BorderLayout());
        aboutDlg.getContentPane().add((Component)outer, "Center");
        aboutDlg.setTitle("About the Browser Demo");
        int xx = (this.root.frame.getWidth() - aboutDlg.getWidth()) / 2;
        int yy = (this.root.frame.getHeight() - aboutDlg.getHeight()) / 2;
        aboutDlg.setLocation(xx, yy);
        aboutDlg.setModal(true);
        aboutDlg.setVisible(true);
    }

    private void togglePrintPreview() {
        try {
            SharedContext sharedContext = this.root.panel.view.getSharedContext();
            if (sharedContext.isPrint()) {
                sharedContext.setPrint(false);
                sharedContext.setInteractive(true);
            } else {
                sharedContext.setPrint(true);
                sharedContext.setInteractive(false);
            }
            this.print_preview.putValue("ShortDescription", !sharedContext.isPrint() ? "Print preview" : "Normal view");
            this.root.panel.reloadPage();
            this.root.panel.view.repaint();
        }
        catch (Exception ex) {
            Uu.p((Exception)ex);
        }
    }

    private void openAndShowFile() {
        try {
            FileDialog fd = new FileDialog((Frame)this.root.frame, "Open a local file", 0);
            fd.setVisible(true);
            if (fd.getFile() != null) {
                String url = new File(fd.getDirectory(), fd.getFile()).toURI().toURL().toString();
                this.root.panel.loadPage(url);
            }
        }
        catch (Exception ex) {
            logger.info("error:" + ex);
        }
    }

    private void exportToPdf() {
        try {
            FileDialog fd = new FileDialog((Frame)this.root.frame, "Save as PDF", 1);
            fd.setVisible(true);
            if (fd.getFile() != null) {
                File outTarget = new File(fd.getDirectory(), fd.getFile());
                this.root.panel.exportToPdf(outTarget.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            logger.info("error:" + ex);
        }
    }

    public static void setAccel(Action act, int key) {
        act.putValue("AcceleratorKey", KeyStroke.getKeyStroke(key, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
    }

    public static void setMnemonic(Action action, int mnemonicValue) {
        action.putValue("MnemonicKey", mnemonicValue);
    }

    @CheckReturnValue
    private static ImageIcon imageIcon(String url) {
        URL imageUrl = Objects.requireNonNull(BrowserActions.class.getClassLoader().getResource(url), () -> "Resource not found in classpath: " + url);
        return new ImageIcon(imageUrl);
    }

    @CheckReturnValue
    private Action action(String name, final Consumer<ActionEvent> handler) {
        return new AbstractAction(name){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    handler.accept(event);
                }
                catch (Exception ex) {
                    Uu.p((Exception)ex);
                }
            }
        };
    }
}

