/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.w3c.dom.Element;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.FormSubmissionListener;
import org.xhtmlrenderer.test.ElementReplacer;

@ParametersAreNonnullByDefault
public class DelegatingReplacedElementFactory
implements ReplacedElementFactory {
    private final List<ElementReplacer> replacers = new ArrayList<ElementReplacer>();
    private final Map<String, ElementReplacer> byNameReplacers = new HashMap<String, ElementReplacer>();
    private final List<ERItem> elementReplacements = new ArrayList<ERItem>();

    @Override
    public ReplacedElement createReplacedElement(LayoutContext context, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        ElementReplacer nameReplacer = this.byNameReplacers.get(box.getElement().getNodeName());
        if (nameReplacer != null) {
            return this.replaceUsing(context, box, uac, cssWidth, cssHeight, nameReplacer);
        }
        for (ElementReplacer replacer : this.replacers) {
            if (!replacer.accept(context, box.getElement())) continue;
            return this.replaceUsing(context, box, uac, cssWidth, cssHeight, replacer);
        }
        return null;
    }

    private ReplacedElement replaceUsing(LayoutContext context, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight, ElementReplacer replacer) {
        ReplacedElement re = replacer.replace(context, box, uac, cssWidth, cssHeight);
        this.elementReplacements.add(new ERItem(box.getElement(), replacer));
        return re;
    }

    @Override
    public void reset() {
        System.out.println("\n\n***Factory reset()");
        this.elementReplacements.clear();
        for (ElementReplacer elementReplacer : this.replacers) {
            elementReplacer.reset();
        }
        for (ElementReplacer elementReplacer : this.byNameReplacers.values()) {
            elementReplacer.reset();
        }
    }

    @Override
    public void remove(Element element) {
        int idx = this.elementReplacements.indexOf(element);
        ERItem item = this.elementReplacements.get(idx);
        this.elementReplacements.remove(idx);
        item.elementReplacer.clear(element);
    }

    public void addReplacer(ElementReplacer replacer) {
        if (replacer.isElementNameMatch()) {
            this.byNameReplacers.put(replacer.getElementNameMatch(), replacer);
        } else {
            this.replacers.add(replacer);
        }
    }

    public void removeReplacer(ElementReplacer replacer) {
        this.replacers.remove(replacer);
    }

    @Override
    public void setFormSubmissionListener(FormSubmissionListener listener) {
    }

    private record ERItem(Element element, ElementReplacer elementReplacer) {
    }
}

