/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.extend.form;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.plaf.basic.BasicTextAreaUI;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Element;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.FSDerivedValue;
import org.xhtmlrenderer.css.style.derived.LengthValue;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.XhtmlForm;
import org.xhtmlrenderer.simple.extend.form.FormField;
import org.xhtmlrenderer.simple.extend.form.FormFieldState;
import org.xhtmlrenderer.util.GeneralUtil;

class TextAreaField
extends FormField<JScrollPane> {
    private @Nullable TextAreaFieldJTextArea _textarea;

    TextAreaField(Element e, XhtmlForm form, LayoutContext context, BlockBox box) {
        super(e, form, context, box);
    }

    @Override
    public JScrollPane create() {
        int rows = GeneralUtil.parseIntRelaxed(this.getAttribute("rows"), 4);
        int cols = GeneralUtil.parseIntRelaxed(this.getAttribute("cols"), 10);
        this._textarea = new TextAreaFieldJTextArea(rows, cols);
        this._textarea.setWrapStyleWord(true);
        this._textarea.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane(this._textarea);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        this.applyComponentStyle(this._textarea, scrollPane);
        return scrollPane;
    }

    private void applyComponentStyle(TextAreaFieldJTextArea textArea, JScrollPane scrollPane) {
        FSDerivedValue heightValue;
        this.applyComponentStyle(textArea);
        CalculatedStyle style = this.getBox().getStyle();
        RectPropertySet padding = style.getCachedPadding();
        Insets margin = style.padding().withDefaults(new Insets(2, 3, 2, 3));
        if (style.disableOSBorder()) {
            BasicTextAreaUI ui = new BasicTextAreaUI();
            textArea.setUI(ui);
            scrollPane.setBorder(null);
        }
        textArea.setMargin(margin);
        padding.reset();
        FSDerivedValue widthValue = style.valueByName(CSSName.WIDTH);
        if (widthValue instanceof LengthValue) {
            this.intrinsicWidth = this.getBox().getContentWidth() + margin.left + margin.right;
        }
        if ((heightValue = style.valueByName(CSSName.HEIGHT)) instanceof LengthValue) {
            this.intrinsicHeight = this.getBox().getHeight() + margin.top + margin.bottom;
        }
    }

    @Override
    protected FormFieldState loadOriginalState() {
        return FormFieldState.fromString(XhtmlForm.collectText(this.getElement()));
    }

    @Override
    protected void applyOriginalState() {
        this._textarea.setText(this.getOriginalState().getValue());
    }

    @Override
    protected String[] getFieldValues() {
        JTextArea textarea = (JTextArea)((JScrollPane)this.component()).getViewport().getView();
        return new String[]{textarea.getText()};
    }

    private static class TextAreaFieldJTextArea
    extends JTextArea {
        private int columnWidth;

        private TextAreaFieldJTextArea(int rows, int columns) {
            super(rows, columns);
        }

        @Override
        protected int getColumnWidth() {
            if (this.columnWidth == 0) {
                FontMetrics metrics = this.getFontMetrics(this.getFont());
                this.columnWidth = metrics.charWidth('o');
            }
            return this.columnWidth;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            Dimension size = super.getPreferredScrollableViewportSize();
            size = size == null ? new Dimension(400, 400) : size;
            Insets insets = this.getInsets();
            size.width = this.getColumns() == 0 ? size.width : this.getColumns() * this.getColumnWidth() + insets.left + insets.right;
            size.height = this.getRows() == 0 ? size.height : this.getRows() * this.getRowHeight() + insets.top + insets.bottom;
            return size;
        }
    }
}

