/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.extend;

import com.google.errorprone.annotations.CheckReturnValue;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xhtmlrenderer.css.sheet.StylesheetInfo;
import org.xhtmlrenderer.simple.NoNamespaceHandler;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.TextUtil;

public class XhtmlCssOnlyNamespaceHandler
extends NoNamespaceHandler {
    private static final String NAMESPACE = "http://www.w3.org/1999/xhtml";
    private static final Pattern RE_INTEGER = Pattern.compile("\\d+");
    private static volatile @Nullable StylesheetInfo _defaultStylesheet;
    private static final AtomicLong inlineCssCounter;

    @Override
    @CheckReturnValue
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    @CheckReturnValue
    public String getClass(Element e) {
        return e.getAttribute("class");
    }

    @Override
    @CheckReturnValue
    public @Nullable String getID(Element e) {
        String result = e.getAttribute("id").trim();
        return result.isEmpty() ? null : result;
    }

    protected String convertToLength(String value) {
        return this.isInteger(value) ? value + "px" : value;
    }

    boolean isInteger(String value) {
        return RE_INTEGER.matcher(value).matches();
    }

    protected @Nullable String getAttribute(Element e, String attrName) {
        String result = e.getAttribute(attrName).trim();
        return result.isEmpty() ? null : result;
    }

    @Override
    @CheckReturnValue
    public String getElementStyling(Element e) {
        StringBuilder style = new StringBuilder();
        switch (e.getNodeName()) {
            case "td": 
            case "th": {
                String s = this.getAttribute(e, "colspan");
                if (s != null) {
                    style.append("-fs-table-cell-colspan: ");
                    style.append(s);
                    style.append(";");
                }
                if ((s = this.getAttribute(e, "rowspan")) == null) break;
                style.append("-fs-table-cell-rowspan: ");
                style.append(s);
                style.append(";");
                break;
            }
            case "img": {
                String s = this.getAttribute(e, "width");
                if (s != null) {
                    style.append("width: ");
                    style.append(this.convertToLength(s));
                    style.append(";");
                }
                if ((s = this.getAttribute(e, "height")) == null) break;
                style.append("height: ");
                style.append(this.convertToLength(s));
                style.append(";");
                break;
            }
            case "colgroup": 
            case "col": {
                String s = this.getAttribute(e, "span");
                if (s != null) {
                    style.append("-fs-table-cell-colspan: ");
                    style.append(s);
                    style.append(";");
                }
                if ((s = this.getAttribute(e, "width")) == null) break;
                style.append("width: ");
                style.append(this.convertToLength(s));
                style.append(";");
                break;
            }
        }
        style.append(e.getAttribute("style"));
        return style.toString();
    }

    @Override
    @CheckReturnValue
    public @Nullable String getLinkUri(Element e) {
        return e.getNodeName().equalsIgnoreCase("a") && e.hasAttribute("href") ? e.getAttribute("href") : null;
    }

    @Override
    @CheckReturnValue
    public @Nullable String getAnchorName(@Nullable Element e) {
        if (e != null && "a".equalsIgnoreCase(e.getNodeName()) && e.hasAttribute("name")) {
            return e.getAttribute("name");
        }
        return null;
    }

    private static String collapseWhiteSpace(String text) {
        StringBuilder result = new StringBuilder();
        int l = text.length();
        block0: for (int i = 0; i < l; ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) {
                result.append(' ');
                while (++i < l) {
                    c = text.charAt(i);
                    if (Character.isWhitespace(c)) continue;
                    --i;
                    continue block0;
                }
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    @Override
    @CheckReturnValue
    public String getDocumentTitle(Document doc) {
        Element titleElem;
        String title = "";
        Element html = doc.getDocumentElement();
        Element head = this.findFirstChild(html, "head");
        if (head != null && (titleElem = this.findFirstChild(head, "title")) != null) {
            title = XhtmlCssOnlyNamespaceHandler.collapseWhiteSpace(TextUtil.readTextContent(titleElem).trim());
        }
        return title;
    }

    private @Nullable Element findFirstChild(Element parent, String targetName) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equals(targetName)) continue;
            return (Element)n;
        }
        return null;
    }

    @CheckReturnValue
    protected @Nullable StylesheetInfo readStyleElement(Element style) {
        String css = XhtmlCssOnlyNamespaceHandler.extractContent(style);
        if (css.isEmpty()) {
            return null;
        }
        String media = style.getAttribute("media");
        String uri = "inline:" + inlineCssCounter.incrementAndGet();
        return new StylesheetInfo(StylesheetInfo.Origin.AUTHOR, uri, StylesheetInfo.mediaTypes(media), css);
    }

    @CheckReturnValue
    private static @NonNull String extractContent(Element style) {
        StringBuilder buf = new StringBuilder();
        for (Node current = style.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (!(current instanceof CharacterData)) continue;
            buf.append(((CharacterData)current).getData());
        }
        return buf.toString().trim();
    }

    protected @Nullable StylesheetInfo readLinkElement(Element link) {
        String rel = link.getAttribute("rel").toLowerCase(Locale.ROOT);
        if (rel.contains("alternate")) {
            return null;
        }
        if (!rel.contains("stylesheet")) {
            return null;
        }
        String uri = link.getAttribute("href");
        return new StylesheetInfo(StylesheetInfo.Origin.AUTHOR, uri, StylesheetInfo.mediaTypes(link.getAttribute("media")), null);
    }

    @Override
    @CheckReturnValue
    public List<StylesheetInfo> getStylesheets(Document doc) {
        ArrayList<StylesheetInfo> result = new ArrayList<StylesheetInfo>(super.getStylesheets(doc));
        Element html = doc.getDocumentElement();
        Element head = this.findFirstChild(html, "head");
        if (head != null) {
            for (Node current = head.getFirstChild(); current != null; current = current.getNextSibling()) {
                StylesheetInfo info;
                String elemName;
                if (current.getNodeType() != 1) continue;
                Element elem = (Element)current;
                switch (elemName = Objects.requireNonNullElseGet(elem.getLocalName(), () -> elem.getTagName())) {
                    case "link": {
                        StylesheetInfo stylesheetInfo = this.readLinkElement(elem);
                        break;
                    }
                    case "style": {
                        StylesheetInfo stylesheetInfo = this.readStyleElement(elem);
                        break;
                    }
                    default: {
                        StylesheetInfo stylesheetInfo = info = null;
                    }
                }
                if (info == null) continue;
                result.add(info);
            }
        }
        return result;
    }

    @Override
    @CheckReturnValue
    public Optional<StylesheetInfo> getDefaultStylesheet() {
        if (_defaultStylesheet == null) {
            _defaultStylesheet = new StylesheetInfo(StylesheetInfo.Origin.USER_AGENT, this.getDefaultStylesheetUrl().toString(), StylesheetInfo.mediaTypes(""), null);
        }
        return Optional.ofNullable(_defaultStylesheet);
    }

    @CheckReturnValue
    private @NonNull URL getDefaultStylesheetUrl() {
        String defaultStyleSheet = Configuration.valueFor("xr.css.user-agent-default-css") + "XhtmlNamespaceHandler.css";
        return Objects.requireNonNull(this.getClass().getResource(defaultStyleSheet), () -> "Can't load default CSS from " + defaultStyleSheet + ".This file must be on your CLASSPATH. Please check before continuing.");
    }

    private Map<String, String> getMetaInfo(Document doc) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        Element html = doc.getDocumentElement();
        Element head = this.findFirstChild(html, "head");
        if (head != null) {
            for (Node current = head.getFirstChild(); current != null; current = current.getNextSibling()) {
                if (current.getNodeType() != 1) continue;
                Element elem = (Element)current;
                String elemName = elem.getLocalName();
                if (elemName == null) {
                    elemName = elem.getTagName();
                }
                if (!elemName.equals("meta")) continue;
                String http_equiv = elem.getAttribute("http-equiv");
                String content = elem.getAttribute("content");
                if (http_equiv.isEmpty() || content.isEmpty()) continue;
                metadata.put(http_equiv, content);
            }
        }
        return metadata;
    }

    @Override
    @CheckReturnValue
    public String getLang(@Nullable Element e) {
        if (e == null) {
            return "";
        }
        String lang = e.getAttribute("lang");
        if (lang.isEmpty() && (lang = this.getMetaInfo(e.getOwnerDocument()).get("Content-Language")) == null) {
            lang = "";
        }
        return lang;
    }

    static {
        inlineCssCounter = new AtomicLong();
    }
}

