/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.util;

import com.google.errorprone.annotations.CheckReturnValue;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextUtil {
    @CheckReturnValue
    public static @Nullable String readTextContentOrNull(Element element) {
        String text = TextUtil.readTextContent(element);
        return text.isEmpty() ? null : text;
    }

    @CheckReturnValue
    public static String readTextContent(Element element) {
        StringBuilder result = new StringBuilder();
        for (Node current = element.getFirstChild(); current != null; current = current.getNextSibling()) {
            short nodeType = current.getNodeType();
            if (nodeType != 3 && nodeType != 4) continue;
            Text t = (Text)current;
            result.append(t.getData());
        }
        return result.toString();
    }
}

