/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.util;

import com.google.errorprone.annotations.CheckReturnValue;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.util.XRLog;

public class GeneralUtil {
    @CheckReturnValue
    public static @Nullable InputStream openStreamFromClasspath(Object obj, String resource) {
        InputStream readStream = null;
        try {
            URL stream;
            ClassLoader loader = obj.getClass().getClassLoader();
            readStream = loader == null ? ClassLoader.getSystemResourceAsStream(resource) : loader.getResourceAsStream(resource);
            if (readStream == null && (stream = resource.getClass().getResource(resource)) != null) {
                readStream = stream.openStream();
            }
        }
        catch (Exception ex) {
            XRLog.exception("Could not open stream from CLASSPATH: " + resource, ex);
        }
        return readStream;
    }

    @CheckReturnValue
    public static @Nullable URL getURLFromClasspath(Object obj, String resource) {
        URL url = null;
        try {
            ClassLoader loader = obj.getClass().getClassLoader();
            url = loader == null ? ClassLoader.getSystemResource(resource) : loader.getResource(resource);
            if (url == null) {
                url = resource.getClass().getResource(resource);
            }
        }
        catch (Exception ex) {
            XRLog.exception("Could not get URL from CLASSPATH: " + resource, ex);
        }
        return url;
    }

    public static void dumpShortException(Exception ex) {
        String s = ex.getMessage();
        if (s == null || s.trim().equals("null")) {
            s = "{no ex. message}";
        }
        System.out.println(s + ", " + String.valueOf(ex.getClass()));
        StackTraceElement[] stackTrace = ex.getStackTrace();
        for (int i = 0; i < stackTrace.length && i < 5; ++i) {
            StackTraceElement ste = stackTrace[i];
            System.out.println("  " + ste.getClassName() + "." + ste.getMethodName() + "(ln " + ste.getLineNumber() + ")");
        }
    }

    @CheckReturnValue
    public static boolean isMacOSX() {
        try {
            if (System.getProperty("os.name").toLowerCase(Locale.ROOT).startsWith("mac os x")) {
                return true;
            }
        }
        catch (SecurityException e) {
            System.err.println(e.getLocalizedMessage());
        }
        return false;
    }

    public static StringBuilder htmlEscapeSpace(String uri) {
        StringBuilder sbURI = new StringBuilder((int)((double)uri.length() * 1.5));
        for (int i = 0; i < uri.length(); ++i) {
            char ch = uri.charAt(i);
            if (ch == ' ') {
                sbURI.append("%20");
                continue;
            }
            if (ch == '\\') {
                sbURI.append('/');
                continue;
            }
            sbURI.append(ch);
        }
        return sbURI;
    }

    public static int parseIntRelaxed(String s) {
        if (s == null || s.isEmpty() || s.trim().isEmpty()) {
            return 0;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isDigit(c)) {
                buffer.append(c);
                continue;
            }
            if (!buffer.isEmpty()) break;
        }
        if (buffer.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(buffer.toString());
        }
        catch (NumberFormatException exception) {
            return Integer.MAX_VALUE;
        }
    }

    public static String escapeHTML(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int n = s.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case ' ': {
                    sb.append("&nbsp;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

