/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.resource;

import com.google.errorprone.annotations.CheckReturnValue;
import java.io.InputStream;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.resource.Resource;
import org.xhtmlrenderer.util.InputSources;
import org.xml.sax.InputSource;

public abstract class AbstractResource
implements Resource {
    private final @Nullable InputSource inputSource;
    private final long createTimeStamp;

    protected AbstractResource(@Nullable InputSource source) {
        this.inputSource = source;
        this.createTimeStamp = System.currentTimeMillis();
    }

    protected AbstractResource(@Nullable InputStream is) {
        this(InputSources.fromStream(is));
    }

    @Override
    @CheckReturnValue
    public @Nullable InputSource getResourceInputSource() {
        return this.inputSource;
    }

    @Override
    @CheckReturnValue
    public long getResourceLoadTimeStamp() {
        return this.createTimeStamp;
    }
}

