/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import com.google.errorprone.annotations.CheckReturnValue;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.render.LineBox;
import org.xhtmlrenderer.render.StrutMetrics;

public class MarkerData {
    private final StrutMetrics _structMetrics;
    private final @Nullable TextMarker _textMarker;
    private final @Nullable GlyphMarker _glyphMarker;
    private final @Nullable ImageMarker _imageMarker;
    private @Nullable LineBox _referenceLine;
    private @Nullable LineBox _previousReferenceLine;

    public MarkerData(StrutMetrics structMetrics, @Nullable ImageMarker imageMarker, @Nullable GlyphMarker glyphMarker, @Nullable TextMarker textMarker) {
        this._structMetrics = structMetrics;
        this._imageMarker = imageMarker;
        this._glyphMarker = glyphMarker;
        this._textMarker = textMarker;
    }

    @CheckReturnValue
    public @Nullable GlyphMarker getGlyphMarker() {
        return this._glyphMarker;
    }

    @CheckReturnValue
    public @Nullable TextMarker getTextMarker() {
        return this._textMarker;
    }

    @CheckReturnValue
    public @Nullable ImageMarker getImageMarker() {
        return this._imageMarker;
    }

    public StrutMetrics getStructMetrics() {
        return this._structMetrics;
    }

    public int getLayoutWidth() {
        if (this._textMarker != null) {
            return this._textMarker.getLayoutWidth();
        }
        if (this._glyphMarker != null) {
            return this._glyphMarker.getLayoutWidth();
        }
        if (this._imageMarker != null) {
            return this._imageMarker.getLayoutWidth();
        }
        return 0;
    }

    @CheckReturnValue
    public @Nullable LineBox getReferenceLine() {
        return this._referenceLine;
    }

    public void setReferenceLine(LineBox referenceLine) {
        this._previousReferenceLine = this._referenceLine;
        this._referenceLine = referenceLine;
    }

    public void restorePreviousReferenceLine(LineBox current) {
        if (current == this._referenceLine) {
            this._referenceLine = this._previousReferenceLine;
        }
    }

    public static class ImageMarker {
        private final FSImage _image;
        private final int _layoutWidth;

        public ImageMarker(FSImage image, int layoutWidth) {
            this._image = image;
            this._layoutWidth = layoutWidth;
        }

        @CheckReturnValue
        public FSImage getImage() {
            return this._image;
        }

        @CheckReturnValue
        public int getLayoutWidth() {
            return this._layoutWidth;
        }
    }

    public static class GlyphMarker {
        private final int _diameter;
        private final int _layoutWidth;

        public GlyphMarker(int diameter, int layoutWidth) {
            this._diameter = diameter;
            this._layoutWidth = layoutWidth;
        }

        @CheckReturnValue
        public int getDiameter() {
            return this._diameter;
        }

        @CheckReturnValue
        public int getLayoutWidth() {
            return this._layoutWidth;
        }
    }

    public static class TextMarker {
        private final String _text;
        private final int _layoutWidth;

        public TextMarker(String text, int width) {
            this._text = text;
            this._layoutWidth = width;
        }

        @CheckReturnValue
        public String getText() {
            return this._text;
        }

        @CheckReturnValue
        public int getLayoutWidth() {
            return this._layoutWidth;
        }
    }
}

