/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.parser;

import com.google.errorprone.annotations.CheckReturnValue;

public class Token {
    public static final Token TK_S = new Token(Type.S, "S", "whitespace");
    public static final Token TK_CDO = new Token(Type.CDO, "CDO", "<!--");
    public static final Token TK_CDC = new Token(Type.CDC, "CDC", "-->");
    public static final Token TK_INCLUDES = new Token(Type.INCLUDES, "INCLUDES", "an attribute word match");
    public static final Token TK_DASHMATCH = new Token(Type.DASHMATCH, "DASHMATCH", "an attribute hyphen match");
    public static final Token TK_PREFIXMATCH = new Token(Type.PREFIXMATCH, "PREFIXMATCH", "an attribute prefix match");
    public static final Token TK_SUFFIXMATCH = new Token(Type.SUFFIXMATCH, "SUFFIXMATCH", "an attribute suffix match");
    public static final Token TK_SUBSTRINGMATCH = new Token(Type.SUBSTRINGMATCH, "SUBSTRINGMATCH", "an attribute substring match");
    public static final Token TK_LBRACE = new Token(Type.LBRACE, "LBRACE", "a {");
    public static final Token TK_PLUS = new Token(Type.PLUS, "PLUS", "a +");
    public static final Token TK_GREATER = new Token(Type.GREATER, "GREATER", "a >");
    public static final Token TK_COMMA = new Token(Type.COMMA, "COMMA", "a comma");
    public static final Token TK_STRING = new Token(Type.STRING, "STRING", "a string");
    public static final Token TK_INVALID = new Token(Type.INVALID, "INVALID", "an unclosed string");
    public static final Token TK_IDENT = new Token(Type.IDENT, "IDENT", "an identifier");
    public static final Token TK_HASH = new Token(Type.HASH, "HASH", "a hex color");
    public static final Token TK_IMPORT_SYM = new Token(Type.IMPORT_SYM, "IMPORT_SYM", "@import");
    public static final Token TK_PAGE_SYM = new Token(Type.PAGE_SYM, "PAGE_SYM", "@page");
    public static final Token TK_MEDIA_SYM = new Token(Type.MEDIA_SYM, "MEDIA_SYM", "@media");
    public static final Token TK_CHARSET_SYM = new Token(Type.CHARSET_SYM, "CHARSET_SYM", "@charset");
    public static final Token TK_NAMESPACE_SYM = new Token(Type.NAMESPACE_SYM, "NAMESPACE_SYM", "@namespace,");
    public static final Token TK_FONT_FACE_SYM = new Token(Type.FONT_FACE_SYM, "FONT_FACE_SYM", "@font-face");
    public static final Token TK_AT_RULE = new Token(Type.AT_RULE, "AT_RULE", "at rule");
    public static final Token TK_IMPORTANT_SYM = new Token(Type.IMPORTANT_SYM, "IMPORTANT_SYM", "!important");
    public static final Token TK_EMS = new Token(Type.EMS, "EMS", "an em value");
    public static final Token TK_EXS = new Token(Type.EXS, "EXS", "an ex value");
    public static final Token TK_PX = new Token(Type.PX, "PX", "a pixel value");
    public static final Token TK_CM = new Token(Type.CM, "CM", "a centimeter value");
    public static final Token TK_MM = new Token(Type.MM, "MM", "a millimeter value");
    public static final Token TK_IN = new Token(Type.IN, "IN", "an inch value");
    public static final Token TK_PT = new Token(Type.PT, "PT", "a point value");
    public static final Token TK_PC = new Token(Type.PC, "PC", "a pica value");
    public static final Token TK_ANGLE = new Token(Type.ANGLE, "ANGLE", "an angle value");
    public static final Token TK_TIME = new Token(Type.TIME, "TIME", "a time value");
    public static final Token TK_FREQ = new Token(Type.FREQ, "FREQ", "a freq value");
    public static final Token TK_DIMENSION = new Token(Type.DIMENSION, "DIMENSION", "a dimension");
    public static final Token TK_PERCENTAGE = new Token(Type.PERCENTAGE, "PERCENTAGE", "a percentage");
    public static final Token TK_NUMBER = new Token(Type.NUMBER, "NUMBER", "a number");
    public static final Token TK_URI = new Token(Type.URI, "URI", "a URI");
    public static final Token TK_FUNCTION = new Token(Type.FUNCTION, "FUNCTION", "function");
    public static final Token TK_OTHER = new Token(Type.OTHER, "OTHER", "other");
    public static final Token TK_RBRACE = new Token(Type.RBRACE, "RBRACE", "}");
    public static final Token TK_SEMICOLON = new Token(Type.SEMICOLON, "SEMICOLON", ";");
    public static final Token TK_VIRGULE = new Token(Type.VIRGULE, "VIRGULE", "/");
    public static final Token TK_COLON = new Token(Type.COLON, "COLON", ":");
    public static final Token TK_MINUS = new Token(Type.MINUS, "MINUS", "-");
    public static final Token TK_RPAREN = new Token(Type.RPAREN, "RPAREN", ")");
    public static final Token TK_LBRACKET = new Token(Type.LBRACKET, "LBRACKET", "[");
    public static final Token TK_RBRACKET = new Token(Type.RBRACKET, "RBRACKET", "]");
    public static final Token TK_PERIOD = new Token(Type.PERIOD, "PERIOD", ".");
    public static final Token TK_EQUALS = new Token(Type.EQUALS, "EQUALS", "=");
    public static final Token TK_ASTERISK = new Token(Type.ASTERISK, "ASTERISK", "*");
    public static final Token TK_VERTICAL_BAR = new Token(Type.VERTICAL_BAR, "VERTICAL_BAR", "|");
    public static final Token TK_EOF = new Token(Type.EOF, "EOF", "end of file");
    private final Type _type;
    private final String _name;
    private final String _externalName;

    private Token(Type type, String name, String externalName) {
        this._type = type;
        this._name = name;
        this._externalName = externalName;
    }

    @CheckReturnValue
    public Type getType() {
        return this._type;
    }

    public String getName() {
        return this._name;
    }

    public String getExternalName() {
        return this._externalName;
    }

    public String toString() {
        return this._name;
    }

    public static Token createOtherToken(String value) {
        return new Token(Type.OTHER, "OTHER", value + " (other)");
    }

    public static enum Type {
        S,
        CDO,
        CDC,
        INCLUDES,
        DASHMATCH,
        PREFIXMATCH,
        SUFFIXMATCH,
        SUBSTRINGMATCH,
        LBRACE,
        PLUS,
        GREATER,
        COMMA,
        STRING,
        INVALID,
        IDENT,
        HASH,
        IMPORT_SYM,
        PAGE_SYM,
        MEDIA_SYM,
        CHARSET_SYM,
        NAMESPACE_SYM,
        FONT_FACE_SYM,
        AT_RULE,
        IMPORTANT_SYM,
        EMS,
        EXS,
        PX,
        CM,
        MM,
        IN,
        PT,
        PC,
        ANGLE,
        TIME,
        FREQ,
        DIMENSION,
        PERCENTAGE,
        NUMBER,
        URI,
        FUNCTION,
        OTHER,
        RBRACE,
        SEMICOLON,
        VIRGULE,
        COLON,
        MINUS,
        RPAREN,
        LBRACKET,
        RBRACKET,
        PERIOD,
        EQUALS,
        ASTERISK,
        VERTICAL_BAR,
        EOF;

    }
}

