/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.context;

import com.google.errorprone.annotations.CheckReturnValue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.context.StylesheetCache;
import org.xhtmlrenderer.css.extend.StylesheetFactory;
import org.xhtmlrenderer.css.parser.CSSParser;
import org.xhtmlrenderer.css.sheet.Ruleset;
import org.xhtmlrenderer.css.sheet.Stylesheet;
import org.xhtmlrenderer.css.sheet.StylesheetInfo;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.resource.CSSResource;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.XRLog;
import org.xml.sax.InputSource;

public class StylesheetFactoryImpl
implements StylesheetFactory {
    private UserAgentCallback _userAgentCallback;
    private final Map<String, Stylesheet> _cache = Collections.synchronizedMap(new StylesheetCache());
    private final CSSParser _cssParser;

    public StylesheetFactoryImpl(UserAgentCallback userAgentCallback) {
        this._userAgentCallback = userAgentCallback;
        this._cssParser = new CSSParser((uri, message) -> XRLog.cssParse(Level.WARNING, "(" + uri + ") " + message));
    }

    @Override
    public Stylesheet parse(Reader reader, StylesheetInfo info) {
        return this.parse(reader, info.getUri(), info.getOrigin());
    }

    @Override
    public Stylesheet parse(Reader reader, String uri, StylesheetInfo.Origin origin) {
        try {
            return this._cssParser.parseStylesheet(uri, origin, reader);
        }
        catch (IOException e) {
            XRLog.cssParse(Level.WARNING, "Couldn't parse stylesheet at URI " + uri + ": " + e.getMessage(), e);
            return new Stylesheet(uri, origin);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private @Nullable Stylesheet parse(StylesheetInfo info) {
        CSSResource cr = info.getContent().map(css -> new CSSResource(new ByteArrayInputStream(css.getBytes(StandardCharsets.UTF_8)))).orElseGet(() -> this._userAgentCallback.getCSSResource(info.getUri()));
        InputSource inputSource = cr.getResourceInputSource();
        if (inputSource == null) {
            return null;
        }
        try (InputStream is = inputSource.getByteStream();){
            if (is == null) {
                Stylesheet stylesheet2 = null;
                return stylesheet2;
            }
            String charset = Configuration.valueFor("xr.stylesheets.charset-name", "UTF-8");
            Stylesheet stylesheet = this.parse(new InputStreamReader(is, charset), info);
            return stylesheet;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Ruleset parseStyleDeclaration(StylesheetInfo.Origin origin, String styleDeclaration) {
        return this._cssParser.parseDeclaration(origin, styleDeclaration);
    }

    public void putStylesheet(String key, Stylesheet sheet) {
        this._cache.put(key, sheet);
    }

    public boolean containsStylesheet(String key) {
        return this._cache.containsKey(key);
    }

    public void removeCachedStylesheet(String key) {
        this._cache.remove(key);
    }

    void flushCachedStylesheets() {
        this._cache.clear();
    }

    @Override
    @CheckReturnValue
    public @Nullable Stylesheet getStylesheet(StylesheetInfo info) {
        XRLog.load("Requesting stylesheet: " + info.getUri());
        Stylesheet s = this._cache.get(info.getUri());
        if (s == null && !this.containsStylesheet(info.getUri())) {
            s = this.parse(info);
            this.putStylesheet(info.getUri(), s);
        }
        return s;
    }

    void setUserAgentCallback(UserAgentCallback userAgent) {
        this._userAgentCallback = userAgent;
    }

    void setSupportCMYKColors(boolean b) {
        this._cssParser.setSupportCMYKColors(b);
    }
}

