/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.extend;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.DefaultFormSubmissionListener;
import org.xhtmlrenderer.simple.extend.FormSubmissionListener;
import org.xhtmlrenderer.simple.extend.form.FormField;
import org.xhtmlrenderer.simple.extend.form.FormFieldFactory;
import org.xhtmlrenderer.util.XRLog;

public class XhtmlForm {
    private static final String FS_DEFAULT_GROUP = "__fs_default_group_";
    private static int _defaultGroupCount = 1;
    private final UserAgentCallback _userAgentCallback;
    private final Map<Element, FormField> _componentCache = new LinkedHashMap<Element, FormField>();
    private final Map<String, ButtonGroupWrapper> _buttonGroups = new HashMap<String, ButtonGroupWrapper>();
    private final @Nullable Element _parentFormElement;
    private final FormSubmissionListener _formSubmissionListener;

    public XhtmlForm(UserAgentCallback uac, @Nullable Element e, FormSubmissionListener fsListener) {
        this._userAgentCallback = uac;
        this._parentFormElement = e;
        this._formSubmissionListener = fsListener;
    }

    public XhtmlForm(UserAgentCallback uac, Element e) {
        this(uac, e, new DefaultFormSubmissionListener());
    }

    public UserAgentCallback getUserAgentCallback() {
        return this._userAgentCallback;
    }

    public void addButtonToGroup(@Nullable String groupName, AbstractButton button) {
        if (groupName == null) {
            groupName = XhtmlForm.createNewDefaultGroupName();
        }
        ButtonGroupWrapper group = this._buttonGroups.computeIfAbsent(groupName, name -> new ButtonGroupWrapper());
        group.add(button);
    }

    private static String createNewDefaultGroupName() {
        return FS_DEFAULT_GROUP + ++_defaultGroupCount;
    }

    private static boolean isFormField(Element e) {
        String nodeName = e.getNodeName();
        return nodeName.equals("input") || nodeName.equals("select") || nodeName.equals("textarea");
    }

    public @Nullable FormField addComponent(Element e, LayoutContext context, BlockBox box) {
        if (this._componentCache.containsKey(e)) {
            return this._componentCache.get(e);
        }
        if (!XhtmlForm.isFormField(e)) {
            return null;
        }
        FormField field = FormFieldFactory.create(this, context, box);
        if (field == null) {
            XRLog.layout("Unknown field type: " + e.getNodeName());
            return null;
        }
        this._componentCache.put(e, field);
        return field;
    }

    public void reset() {
        for (ButtonGroupWrapper buttonGroupWrapper : this._buttonGroups.values()) {
            buttonGroupWrapper.clearSelection();
        }
        for (FormField formField : this._componentCache.values()) {
            formField.reset();
        }
    }

    public void submit(JComponent source) {
        if (this._parentFormElement == null) {
            return;
        }
        StringBuilder data = new StringBuilder();
        String action = this._parentFormElement.getAttribute("action");
        data.append(action).append("?");
        boolean first = true;
        for (Map.Entry<Element, FormField> entry : this._componentCache.entrySet()) {
            FormField field = entry.getValue();
            if (!field.includeInSubmission(source)) continue;
            for (String value : field.getFormDataStrings()) {
                if (!first) {
                    data.append('&');
                }
                data.append(value);
                first = false;
            }
        }
        this._formSubmissionListener.submit(data.toString());
    }

    public static String collectText(Element e) {
        StringBuilder result = new StringBuilder();
        Node node = e.getFirstChild();
        if (node != null) {
            do {
                short nodeType;
                if ((nodeType = node.getNodeType()) != 3 && nodeType != 4) continue;
                Text text = (Text)node;
                result.append(text.getData());
            } while ((node = node.getNextSibling()) != null);
        }
        return result.toString().trim();
    }

    private static class ButtonGroupWrapper {
        private final ButtonGroup _group = new ButtonGroup();
        private final AbstractButton _dummy = new JRadioButton();

        private ButtonGroupWrapper() {
            this._group.add(this._dummy);
        }

        public void add(AbstractButton b) {
            this._group.add(b);
        }

        public void clearSelection() {
            this._group.setSelected(this._dummy.getModel(), true);
        }
    }
}

