/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.Rectangle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.context.ContentFunctionFactory;
import org.xhtmlrenderer.context.StyleReference;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.parser.CounterData;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.value.FontSpecification;
import org.xhtmlrenderer.extend.FSCanvas;
import org.xhtmlrenderer.extend.FontContext;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.TextRenderer;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.BlockFormattingContext;
import org.xhtmlrenderer.layout.BreakAtLineContext;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.LayoutState;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.layout.StyleTracker;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.FSFont;
import org.xhtmlrenderer.render.FSFontMetrics;
import org.xhtmlrenderer.render.MarkerData;
import org.xhtmlrenderer.render.PageBox;

public class LayoutContext
implements CssContext {
    private final SharedContext _sharedContext;
    private @Nullable Layer _rootLayer;
    private StyleTracker _firstLines;
    private StyleTracker _firstLetters;
    private @Nullable MarkerData _currentMarkerData;
    private final Deque<BlockFormattingContext> _bfcs = new ArrayDeque<BlockFormattingContext>();
    private final Deque<Layer> _layers = new ArrayDeque<Layer>();
    private final FontContext _fontContext;
    private final ContentFunctionFactory _contentFunctionFactory = new ContentFunctionFactory();
    private int _extraSpaceTop;
    private int _extraSpaceBottom;
    private final Map<CalculatedStyle, CounterContext> _counterContextMap = new HashMap<CalculatedStyle, CounterContext>();
    private @Nullable String _pendingPageName;
    private @Nullable String _pageName;
    private int _noPageBreak;
    private @Nullable Layer _rootDocumentLayer;
    private @Nullable PageBox _page;
    private boolean _mayCheckKeepTogether = true;
    private @Nullable BreakAtLineContext _breakAtLineContext;

    public TextRenderer getTextRenderer() {
        return this._sharedContext.getTextRenderer();
    }

    @Override
    @CheckReturnValue
    public StyleReference getCss() {
        return this._sharedContext.getCss();
    }

    public FSCanvas getCanvas() {
        return this._sharedContext.getCanvas();
    }

    public Rectangle getFixedRectangle() {
        return this._sharedContext.getFixedRectangle();
    }

    public NamespaceHandler getNamespaceHandler() {
        return this._sharedContext.getNamespaceHandler();
    }

    LayoutContext(SharedContext sharedContext, FontContext fontContext) {
        this._sharedContext = sharedContext;
        this._firstLines = new StyleTracker();
        this._firstLetters = new StyleTracker();
        this._fontContext = fontContext;
    }

    public void reInit(boolean keepLayers) {
        this._firstLines = new StyleTracker();
        this._firstLetters = new StyleTracker();
        this._currentMarkerData = null;
        this._bfcs.clear();
        if (!keepLayers) {
            this._rootLayer = null;
            this._layers.clear();
        }
        this._extraSpaceTop = 0;
        this._extraSpaceBottom = 0;
    }

    public LayoutState captureLayoutState() {
        LayoutState result = new LayoutState();
        result.setFirstLines(this._firstLines);
        result.setFirstLetters(this._firstLetters);
        result.setCurrentMarkerData(this._currentMarkerData);
        result.setBFCs(this._bfcs);
        if (this.isPrint()) {
            result.setPageName(this.getPageName());
            result.setExtraSpaceBottom(this.getExtraSpaceBottom());
            result.setExtraSpaceTop(this.getExtraSpaceTop());
            result.setNoPageBreak(this.getNoPageBreak());
        }
        return result;
    }

    public void restoreLayoutState(LayoutState layoutState) {
        this._firstLines = layoutState.getFirstLines();
        this._firstLetters = layoutState.getFirstLetters();
        this._currentMarkerData = layoutState.getCurrentMarkerData();
        this._bfcs.clear();
        this._bfcs.addAll(layoutState.getBFCs());
        if (this.isPrint()) {
            this.setPageName(layoutState.getPageName());
            this.setExtraSpaceBottom(layoutState.getExtraSpaceBottom());
            this.setExtraSpaceTop(layoutState.getExtraSpaceTop());
            this.setNoPageBreak(layoutState.getNoPageBreak());
        }
    }

    public LayoutState copyStateForRelayout() {
        LayoutState result = new LayoutState();
        result.setFirstLetters(this._firstLetters.copyOf());
        result.setFirstLines(this._firstLines.copyOf());
        result.setCurrentMarkerData(this._currentMarkerData);
        if (this.isPrint()) {
            result.setPageName(this.getPageName());
        }
        return result;
    }

    public void restoreStateForRelayout(LayoutState layoutState) {
        this._firstLines = layoutState.getFirstLines();
        this._firstLetters = layoutState.getFirstLetters();
        this._currentMarkerData = layoutState.getCurrentMarkerData();
        if (this.isPrint()) {
            this.setPageName(layoutState.getPageName());
        }
    }

    public BlockFormattingContext getBlockFormattingContext() {
        return this._bfcs.getLast();
    }

    public void pushBFC(BlockFormattingContext bfc) {
        this._bfcs.add(bfc);
    }

    public void popBFC() {
        this._bfcs.removeLast();
    }

    public void pushLayer(Box master) {
        Layer layer;
        if (this._rootLayer == null) {
            this._rootLayer = layer = new Layer(master);
        } else {
            Layer parent = this.getLayer();
            layer = new Layer(parent, master);
            parent.addChild(layer);
        }
        this.pushLayer(layer);
    }

    public void pushLayer(Layer layer) {
        this._layers.add(layer);
    }

    public void popLayer() {
        Layer layer = this.getLayer();
        layer.finish(this);
        this._layers.removeLast();
    }

    public Layer getLayer() {
        return this._layers.getLast();
    }

    public Layer getRootLayer() {
        return this._rootLayer;
    }

    public void translate(int x, int y) {
        this.getBlockFormattingContext().translate(x, y);
    }

    public void addBoxId(String id, Box box) {
        this._sharedContext.addBoxId(id, box);
    }

    public void removeBoxId(String id) {
        this._sharedContext.removeBoxId(id);
    }

    public boolean isInteractive() {
        return this._sharedContext.isInteractive();
    }

    @Override
    public float getMmPerDot() {
        return this._sharedContext.getMmPerPx();
    }

    @Override
    public int getDotsPerPixel() {
        return this._sharedContext.getDotsPerPixel();
    }

    @Override
    public float getFontSize2D(FontSpecification font) {
        return this._sharedContext.getFont(font).getSize2D();
    }

    @Override
    public float getXHeight(FontSpecification parentFont) {
        return this._sharedContext.getXHeight(this.getFontContext(), parentFont);
    }

    @Override
    @CheckReturnValue
    public @Nullable FSFont getFont(FontSpecification font) {
        return this._sharedContext.getFont(font);
    }

    @CheckReturnValue
    public UserAgentCallback getUac() {
        return this._sharedContext.getUac();
    }

    public boolean isPrint() {
        return this._sharedContext.isPrint();
    }

    public StyleTracker getFirstLinesTracker() {
        return this._firstLines;
    }

    public StyleTracker getFirstLettersTracker() {
        return this._firstLetters;
    }

    @CheckReturnValue
    public @Nullable MarkerData getCurrentMarkerData() {
        return this._currentMarkerData;
    }

    public void setCurrentMarkerData(@Nullable MarkerData currentMarkerData) {
        this._currentMarkerData = currentMarkerData;
    }

    public ReplacedElementFactory getReplacedElementFactory() {
        return this._sharedContext.getReplacedElementFactory();
    }

    public FontContext getFontContext() {
        return this._fontContext;
    }

    public ContentFunctionFactory getContentFunctionFactory() {
        return this._contentFunctionFactory;
    }

    public SharedContext getSharedContext() {
        return this._sharedContext;
    }

    public int getExtraSpaceBottom() {
        return this._extraSpaceBottom;
    }

    public void setExtraSpaceBottom(int extraSpaceBottom) {
        this._extraSpaceBottom = extraSpaceBottom;
    }

    public int getExtraSpaceTop() {
        return this._extraSpaceTop;
    }

    public void setExtraSpaceTop(int extraSpaceTop) {
        this._extraSpaceTop = extraSpaceTop;
    }

    public void resolveCounters(CalculatedStyle style, Integer startIndex) {
        CounterContext cc = new CounterContext(style, startIndex);
        this._counterContextMap.put(style, cc);
    }

    public void resolveCounters(CalculatedStyle style) {
        this.resolveCounters(style, null);
    }

    public CounterContext getCounterContext(CalculatedStyle style) {
        return this._counterContextMap.get(style);
    }

    @Override
    @CheckReturnValue
    public FSFontMetrics getFSFontMetrics(FSFont font) {
        return this.getTextRenderer().getFSFontMetrics(this.getFontContext(), font, "");
    }

    @CheckReturnValue
    public @Nullable String getPageName() {
        return this._pageName;
    }

    public void setPageName(String currentPageName) {
        this._pageName = currentPageName;
    }

    public int getNoPageBreak() {
        return this._noPageBreak;
    }

    public void setNoPageBreak(int noPageBreak) {
        this._noPageBreak = noPageBreak;
    }

    public boolean isPageBreaksAllowed() {
        return this._noPageBreak == 0;
    }

    @CheckReturnValue
    public @Nullable String getPendingPageName() {
        return this._pendingPageName;
    }

    public void setPendingPageName(@Nullable String pendingPageName) {
        this._pendingPageName = pendingPageName;
    }

    @CheckReturnValue
    public @Nullable Layer getRootDocumentLayer() {
        return this._rootDocumentLayer;
    }

    public void setRootDocumentLayer(Layer rootDocumentLayer) {
        this._rootDocumentLayer = rootDocumentLayer;
    }

    @CheckReturnValue
    public @Nullable PageBox getPage() {
        return this._page;
    }

    public void setPage(PageBox page) {
        this._page = page;
    }

    public boolean isMayCheckKeepTogether() {
        return this._mayCheckKeepTogether;
    }

    public void setMayCheckKeepTogether(boolean mayKeepTogether) {
        this._mayCheckKeepTogether = mayKeepTogether;
    }

    @CheckReturnValue
    public @Nullable BreakAtLineContext getBreakAtLineContext() {
        return this._breakAtLineContext;
    }

    public void setBreakAtLineContext(@Nullable BreakAtLineContext breakAtLineContext) {
        this._breakAtLineContext = breakAtLineContext;
    }

    public class CounterContext {
        private final Map<String, Integer> _counters = new HashMap<String, Integer>();
        private @Nullable CounterContext _parent;

        CounterContext(@Nullable CalculatedStyle style, Integer startIndex) {
            List<CounterData> increments;
            List<CounterData> resets;
            if (startIndex != null) {
                this._counters.put("list-item", startIndex);
            }
            this._parent = LayoutContext.this._counterContextMap.get(style.getParent());
            if (this._parent == null) {
                this._parent = new CounterContext();
            }
            if ((resets = style.getCounterReset()) != null) {
                for (CounterData cd : resets) {
                    this._parent.resetCounter(cd);
                }
            }
            if ((increments = style.getCounterIncrement()) != null) {
                for (CounterData cd : increments) {
                    if (this._parent.incrementCounter(cd)) continue;
                    this._parent.resetCounter(new CounterData(cd.getName(), 0));
                    this._parent.incrementCounter(cd);
                }
            }
            if (style.isIdent(CSSName.DISPLAY, IdentValue.LIST_ITEM)) {
                if (startIndex != null) {
                    this._parent._counters.put("list-item", startIndex);
                }
                this._parent.incrementListItemCounter(1);
            }
        }

        private CounterContext() {
        }

        private boolean incrementCounter(CounterData cd) {
            if ("list-item".equals(cd.getName())) {
                this.incrementListItemCounter(cd.getValue());
                return true;
            }
            Integer currentValue = this._counters.get(cd.getName());
            if (currentValue == null) {
                if (this._parent == null) {
                    return false;
                }
                return this._parent.incrementCounter(cd);
            }
            this._counters.put(cd.getName(), currentValue + cd.getValue());
            return true;
        }

        private void incrementListItemCounter(int increment) {
            Integer currentValue = this._counters.get("list-item");
            if (currentValue == null) {
                currentValue = 0;
            }
            this._counters.put("list-item", currentValue + increment);
        }

        private void resetCounter(CounterData cd) {
            this._counters.put(cd.getName(), cd.getValue());
        }

        public int getCurrentCounterValue(String name) {
            Integer value = this._parent.getCounter(name);
            if (value == null) {
                this._parent.resetCounter(new CounterData(name, 0));
                return 0;
            }
            return value;
        }

        private @Nullable Integer getCounter(String name) {
            Integer value = this._counters.get(name);
            if (value != null) {
                return value;
            }
            if (this._parent == null) {
                return null;
            }
            return this._parent.getCounter(name);
        }

        public List<Integer> getCurrentCounterValues(String name) {
            ArrayList<Integer> values = new ArrayList<Integer>();
            this._parent.getCounterValues(name, values);
            if (values.isEmpty()) {
                this._parent.resetCounter(new CounterData(name, 0));
                values.add(0);
            }
            return values;
        }

        private void getCounterValues(String name, List<Integer> values) {
            Integer value;
            if (this._parent != null) {
                this._parent.getCounterValues(name, values);
            }
            if ((value = this._counters.get(name)) != null) {
                values.add(value);
            }
        }
    }
}

