/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.extend.lib;

import java.util.Objects;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xhtmlrenderer.css.extend.TreeResolver;

public class DOMTreeResolver
implements TreeResolver {
    @Override
    public Node getParentElement(Node element) {
        Node parent = element.getParentNode();
        if (parent.getNodeType() != 1) {
            parent = null;
        }
        return parent;
    }

    @Override
    public Node getPreviousSiblingElement(Node element) {
        Node sibling;
        for (sibling = element.getPreviousSibling(); sibling != null && sibling.getNodeType() != 1; sibling = sibling.getPreviousSibling()) {
        }
        if (sibling == null || sibling.getNodeType() != 1) {
            return null;
        }
        return sibling;
    }

    @Override
    public String getElementName(Node element) {
        String name = element.getLocalName();
        if (name == null) {
            name = element.getNodeName();
        }
        return name;
    }

    @Override
    public boolean isFirstChildElement(Node element) {
        Node currentChild;
        Node parent = element.getParentNode();
        for (currentChild = parent.getFirstChild(); currentChild != null && currentChild.getNodeType() != 1; currentChild = currentChild.getNextSibling()) {
        }
        return currentChild == element;
    }

    @Override
    public boolean isLastChildElement(Node element) {
        Node currentChild;
        Node parent = element.getParentNode();
        for (currentChild = parent.getLastChild(); currentChild != null && currentChild.getNodeType() != 1; currentChild = currentChild.getPreviousSibling()) {
        }
        return currentChild == element;
    }

    @Override
    public boolean matchesElement(Node element, String namespaceURI, String name) {
        String localName = element.getLocalName();
        String eName = Objects.requireNonNullElseGet(localName, element::getNodeName);
        if (namespaceURI != null) {
            return name.equals(localName) && namespaceURI.equals(element.getNamespaceURI());
        }
        if (namespaceURI == "") {
            return name.equals(eName) && element.getNamespaceURI() == null;
        }
        return name.equals(eName);
    }

    @Override
    public int getPositionOfElement(Node element) {
        Node parent = element.getParentNode();
        NodeList nl = parent.getChildNodes();
        int elt_count = 0;
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            if (nl.item(i) == element) {
                return elt_count;
            }
            ++elt_count;
        }
        return -1;
    }
}

