/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.swing.AWTFSImage;
import org.xhtmlrenderer.util.ImageUtil;

public class AWTFSImageFactory {
    private static final FSImage NULL_FS_IMAGE = new AWTFSImage.NullImage();

    @CheckReturnValue
    public static FSImage createImage(@Nullable Image img) {
        if (img == null) {
            return NULL_FS_IMAGE;
        }
        BufferedImage bufferedImage = ImageUtil.convertToBufferedImage(img, 2);
        return new AWTFSImage.NewAWTFSImage(bufferedImage);
    }
}

