/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.resource;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.util.XRLog;
import org.xhtmlrenderer.util.XRRuntimeException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class FSCatalog {
    public Map<String, String> parseCatalog(String catalogURI) {
        try {
            URL url = Objects.requireNonNull(FSCatalog.class.getClassLoader().getResource(catalogURI), () -> "Catalog not found in classpath: " + catalogURI);
            return this.parseCatalog(url);
        }
        catch (IOException ex) {
            XRLog.xmlEntities(Level.WARNING, "Could not open XML catalog from URI '" + catalogURI + "'", ex);
            throw new IllegalStateException("Cannot find " + catalogURI + " in classpath", ex);
        }
    }

    private Map<String, String> parseCatalog(URL url) throws IOException {
        try (BufferedInputStream s = new BufferedInputStream(url.openStream());){
            Map<String, String> map = this.parseCatalog(new InputSource(s));
            return map;
        }
    }

    public Map<String, String> parseCatalog(InputSource inputSource) {
        XMLReader xmlReader = XMLResource.newXMLReader();
        CatalogContentHandler ch = new CatalogContentHandler();
        this.addHandlers(xmlReader, ch);
        this.setFeature(xmlReader);
        try {
            xmlReader.parse(inputSource);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed on configuring SAX to DOM transformer.", ex);
        }
        return ch.getEntityMap();
    }

    private void addHandlers(XMLReader xmlReader, ContentHandler ch) {
        try {
            xmlReader.setContentHandler(ch);
            xmlReader.setErrorHandler(new ErrorHandler(this){

                @Override
                public void error(SAXParseException ex) {
                    if (XRLog.isLoggingEnabled()) {
                        XRLog.xmlEntities(Level.WARNING, ex.getMessage());
                    }
                }

                @Override
                public void fatalError(SAXParseException ex) {
                    if (XRLog.isLoggingEnabled()) {
                        XRLog.xmlEntities(Level.WARNING, ex.getMessage());
                    }
                }

                @Override
                public void warning(SAXParseException ex) {
                    if (XRLog.isLoggingEnabled()) {
                        XRLog.xmlEntities(Level.WARNING, ex.getMessage());
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new XRRuntimeException("Failed on configuring SAX parser/XMLReader.", ex);
        }
    }

    private void setFeature(XMLReader xmlReader) {
        try {
            xmlReader.setFeature("http://xml.org/sax/features/validation", false);
            XRLog.xmlEntities(Level.FINE, "SAX Parser feature: " + "http://xml.org/sax/features/validation".substring("http://xml.org/sax/features/validation".lastIndexOf(47)) + " set to " + xmlReader.getFeature("http://xml.org/sax/features/validation"));
        }
        catch (SAXNotSupportedException ex) {
            XRLog.xmlEntities(Level.WARNING, "SAX feature not supported on this XMLReader: http://xml.org/sax/features/validation");
        }
        catch (SAXNotRecognizedException ex) {
            XRLog.xmlEntities(Level.WARNING, "SAX feature not recognized on this XMLReader: http://xml.org/sax/features/validation. Feature may be properly named, but not recognized by this parser.");
        }
    }

    private static class CatalogContentHandler
    extends DefaultHandler {
        private final Map<String, String> entityMap = new HashMap<String, String>();

        private CatalogContentHandler() {
        }

        private Map<String, String> getEntityMap() {
            return this.entityMap;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
            if (localName.equalsIgnoreCase("public") || localName.isEmpty() && qName.equalsIgnoreCase("public")) {
                this.entityMap.put(attributes.getValue("publicId"), attributes.getValue("uri"));
            }
        }
    }
}

