/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Element;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.parser.FSRGBColor;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.derived.BorderPropertySet;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.layout.BoxCollector;
import org.xhtmlrenderer.layout.InlineBoxing;
import org.xhtmlrenderer.layout.InlinePaintable;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.PaintingInfo;
import org.xhtmlrenderer.render.AnonymousBlockBox;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.CharCounts;
import org.xhtmlrenderer.render.FSFontMetrics;
import org.xhtmlrenderer.render.InlineChild;
import org.xhtmlrenderer.render.InlineText;
import org.xhtmlrenderer.render.JustificationInfo;
import org.xhtmlrenderer.render.LineBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.render.TextDecoration;

public final class InlineLayoutBox
extends Box
implements InlinePaintable,
InlineChild {
    private int _baseline;
    private boolean _startsHere;
    private boolean _endsHere;
    private final List<InlineChild> _inlineChildren = new ArrayList<InlineChild>(1);
    private boolean _pending;
    private int _inlineWidth;
    private @Nullable List<TextDecoration> _textDecorations;
    private final int _containingBlockWidth;

    private InlineLayoutBox(@Nullable Element elem, @Nullable CalculatedStyle style) {
        super(elem, style, false);
        this.setState(Box.State.DONE);
        this._containingBlockWidth = 0;
    }

    public InlineLayoutBox(LayoutContext c, @Nullable Element elem, @Nullable CalculatedStyle style, int cbWidth) {
        super(elem, style, false);
        this._containingBlockWidth = cbWidth;
        this.setMarginTop(c, 0);
        this.setMarginBottom(c, 0);
        this.setPending(true);
        this.calculateHeight(c);
    }

    public InlineLayoutBox copyOf() {
        InlineLayoutBox result = new InlineLayoutBox(this.getElement(), this.getStyle());
        result.setHeight(this.getHeight());
        result._pending = this._pending;
        result.setContainingLayer(this.getContainingLayer());
        return result;
    }

    public void calculateHeight(LayoutContext c) {
        BorderPropertySet border = this.getBorder(c);
        RectPropertySet padding = this.getPadding(c);
        FSFontMetrics metrics = this.getStyle().getFSFontMetrics(c);
        this.setHeight((int)Math.ceil(border.top() + padding.top() + metrics.getAscent() + metrics.getDescent() + padding.bottom() + border.bottom()));
    }

    public int getBaseline() {
        return this._baseline;
    }

    public void setBaseline(int baseline) {
        this._baseline = baseline;
    }

    public int getInlineChildCount() {
        return this._inlineChildren.size();
    }

    public void addInlineChild(LayoutContext c, InlineChild child) {
        this.addInlineChild(c, child, true);
    }

    public void addInlineChild(LayoutContext c, InlineChild child, boolean callUnmarkPending) {
        this._inlineChildren.add(child);
        if (callUnmarkPending && this.isPending()) {
            this.unmarkPending(c);
        }
        if (child instanceof Box) {
            Box b = (Box)((Object)child);
            b.setParent(this);
            b.initContainingLayer(c);
        } else if (child instanceof InlineText) {
            InlineText inlineText = (InlineText)child;
            inlineText.setParent(this);
        } else {
            throw new IllegalArgumentException("Inline child of type " + child.getClass().getName() + " not supported");
        }
    }

    public List<InlineChild> getInlineChildren() {
        return this._inlineChildren;
    }

    public InlineChild getInlineChild(int i) {
        return this._inlineChildren.get(i);
    }

    public int getInlineWidth(CssContext cssContext) {
        return this._inlineWidth;
    }

    public void prunePending() {
        if (this.getInlineChildCount() > 0) {
            InlineChild child;
            for (int i = this.getInlineChildCount() - 1; i >= 0 && (child = this.getInlineChild(i)) instanceof InlineLayoutBox; --i) {
                InlineLayoutBox iB = (InlineLayoutBox)child;
                iB.prunePending();
                if (!iB.isPending()) break;
                this.removeChild(i);
            }
        }
    }

    public boolean isEndsHere() {
        return this._endsHere;
    }

    public void setEndsHere(boolean endsHere) {
        this._endsHere = endsHere;
    }

    public boolean isStartsHere() {
        return this._startsHere;
    }

    public void setStartsHere(boolean startsHere) {
        this._startsHere = startsHere;
    }

    public boolean isPending() {
        return this._pending;
    }

    public void setPending(boolean b) {
        this._pending = b;
    }

    public void unmarkPending(LayoutContext c) {
        InlineLayoutBox iB;
        this._pending = false;
        Box box = this.getParent();
        if (box instanceof InlineLayoutBox && (iB = (InlineLayoutBox)box).isPending()) {
            iB.unmarkPending(c);
        }
        this.setStartsHere(true);
        if (this.getStyle().requiresLayer()) {
            c.pushLayer(this);
            this.getLayer().setInline(true);
            this.connectChildrenToCurrentLayer(c);
        }
    }

    @Override
    public void connectChildrenToCurrentLayer(LayoutContext c) {
        if (this.getInlineChildCount() > 0) {
            for (int i = 0; i < this.getInlineChildCount(); ++i) {
                InlineChild obj = this.getInlineChild(i);
                if (!(obj instanceof Box)) continue;
                Box box = (Box)((Object)obj);
                box.setContainingLayer(c.getLayer());
                box.connectChildrenToCurrentLayer(c);
            }
        }
    }

    public void paintSelection(RenderingContext c) {
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            InlineChild child = this.getInlineChild(i);
            if (!(child instanceof InlineText)) continue;
            InlineText inlineText = (InlineText)child;
            inlineText.paintSelection(c);
        }
    }

    @Override
    public void paintInline(RenderingContext c) {
        IdentValue ident;
        List<TextDecoration> textDecorations;
        if (!this.getStyle().isVisible()) {
            return;
        }
        this.paintBackground(c);
        this.paintBorder(c);
        if (c.debugDrawInlineBoxes()) {
            this.paintDebugOutline(c);
        }
        if ((textDecorations = this.getTextDecorations()) != null) {
            for (TextDecoration tD : textDecorations) {
                ident = tD.getIdentValue();
                if (ident != IdentValue.UNDERLINE && ident != IdentValue.OVERLINE) continue;
                c.getOutputDevice().drawTextDecoration(c, this, tD);
            }
        }
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            InlineChild child = this.getInlineChild(i);
            if (!(child instanceof InlineText)) continue;
            InlineText inlineText = (InlineText)child;
            inlineText.paint(c);
        }
        if (textDecorations != null) {
            for (TextDecoration tD : textDecorations) {
                ident = tD.getIdentValue();
                if (ident != IdentValue.LINE_THROUGH) continue;
                c.getOutputDevice().drawTextDecoration(c, this, tD);
            }
        }
    }

    @Override
    public int getBorderSides() {
        int result = 5;
        if (this._startsHere) {
            result += 2;
        }
        if (this._endsHere) {
            result += 8;
        }
        return result;
    }

    @Override
    public Rectangle getBorderEdge(int left, int top, CssContext cssCtx) {
        MarginLeftRight margin = this.getMarginLeftRight(cssCtx);
        BorderPropertySet border = this.getBorder(cssCtx);
        RectPropertySet padding = this.getPadding(cssCtx);
        return new Rectangle((int)((float)left + margin.left), (int)((float)top - border.top() - padding.top()), (int)((float)this.getInlineWidth(cssCtx) - margin.left - margin.right), this.getHeight());
    }

    private MarginLeftRight getMarginLeftRight(CssContext cssCtx) {
        float marginLeft = 0.0f;
        float marginRight = 0.0f;
        if (this._startsHere || this._endsHere) {
            RectPropertySet margin = this.getMargin(cssCtx);
            if (this._startsHere) {
                marginLeft = margin.left();
            }
            if (this._endsHere) {
                marginRight = margin.right();
            }
        }
        return new MarginLeftRight(marginLeft, marginRight);
    }

    @Override
    public Rectangle getMarginEdge(int left, int top, CssContext cssCtx, int tx, int ty) {
        Rectangle result = this.getBorderEdge(left, top, cssCtx);
        MarginLeftRight margin = this.getMarginLeftRight(cssCtx);
        if (margin.right > 0.0f) {
            result.width += (int)margin.right;
        }
        if (margin.left > 0.0f) {
            result.x -= (int)margin.left;
            result.width += (int)margin.left;
        }
        result.translate(tx, ty);
        return result;
    }

    @Override
    public Rectangle getContentAreaEdge(int left, int top, CssContext cssCtx) {
        BorderPropertySet border = this.getBorder(cssCtx);
        RectPropertySet padding = this.getPadding(cssCtx);
        float marginLeft = 0.0f;
        float marginRight = 0.0f;
        float borderLeft = 0.0f;
        float borderRight = 0.0f;
        float paddingLeft = 0.0f;
        float paddingRight = 0.0f;
        if (this._startsHere || this._endsHere) {
            RectPropertySet margin = this.getMargin(cssCtx);
            if (this._startsHere) {
                marginLeft = margin.left();
                borderLeft = border.left();
                paddingLeft = padding.left();
            }
            if (this._endsHere) {
                marginRight = margin.right();
                borderRight = border.right();
                paddingRight = padding.right();
            }
        }
        return new Rectangle((int)((float)left + marginLeft + borderLeft + paddingLeft), (int)((float)top - border.top() - padding.top()), (int)((float)this.getInlineWidth(cssCtx) - marginLeft - borderLeft - paddingLeft - paddingRight - borderRight - marginRight), this.getHeight());
    }

    public int getLeftMarginBorderPadding(CssContext cssCtx) {
        if (this._startsHere) {
            return this.getMarginBorderPadding(cssCtx, CalculatedStyle.Edge.LEFT);
        }
        return 0;
    }

    public int getRightMarginPaddingBorder(CssContext cssCtx) {
        if (this._endsHere) {
            return this.getMarginBorderPadding(cssCtx, CalculatedStyle.Edge.RIGHT);
        }
        return 0;
    }

    public int getInlineWidth() {
        return this._inlineWidth;
    }

    public void setInlineWidth(int inlineWidth) {
        this._inlineWidth = inlineWidth;
    }

    public boolean isContainsVisibleContent() {
        block5: for (int i = 0; i < this.getInlineChildCount(); ++i) {
            InlineChild inlineChild;
            InlineChild child = this.getInlineChild(i);
            Objects.requireNonNull(child);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InlineText.class, InlineLayoutBox.class, Box.class}, (Object)inlineChild, n)) {
                case 0: {
                    InlineText iT = (InlineText)inlineChild;
                    if (iT.isEmpty()) continue block5;
                    return true;
                }
                case 1: {
                    InlineLayoutBox iB = (InlineLayoutBox)inlineChild;
                    if (!iB.isContainsVisibleContent()) continue block5;
                    return true;
                }
                case 2: {
                    Box b = (Box)((Object)inlineChild);
                    if (b.getWidth() <= 0 && b.getHeight() <= 0) continue block5;
                    return true;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(child));
                }
            }
        }
        return false;
    }

    public boolean intersectsInlineBlocks(CssContext cssCtx, Shape clip) {
        block4: for (int i = 0; i < this.getInlineChildCount(); ++i) {
            InlineChild inlineChild;
            InlineChild obj = this.getInlineChild(i);
            Objects.requireNonNull(obj);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InlineLayoutBox.class, Box.class}, (Object)inlineChild, n)) {
                case 0: {
                    InlineLayoutBox inlineLayoutBox = (InlineLayoutBox)inlineChild;
                    boolean possibleResult = inlineLayoutBox.intersectsInlineBlocks(cssCtx, clip);
                    if (!possibleResult) continue block4;
                    return true;
                }
                case 1: {
                    Box box = (Box)((Object)inlineChild);
                    BoxCollector collector = new BoxCollector();
                    if (!collector.intersectsAny(cssCtx, clip, box)) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    @CheckReturnValue
    public @Nullable List<TextDecoration> getTextDecorations() {
        return this._textDecorations;
    }

    public void setTextDecorations(List<TextDecoration> textDecoration) {
        this._textDecorations = Collections.unmodifiableList(Objects.requireNonNull(textDecoration));
    }

    private void addToContentList(List<Box> list) {
        list.add(this);
        block4: for (int i = 0; i < this.getInlineChildCount(); ++i) {
            InlineChild inlineChild;
            InlineChild child = this.getInlineChild(i);
            Objects.requireNonNull(child);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InlineLayoutBox.class, Box.class}, (Object)inlineChild, n)) {
                case 0: {
                    InlineLayoutBox inlineLayoutBox = (InlineLayoutBox)inlineChild;
                    inlineLayoutBox.addToContentList(list);
                    continue block4;
                }
                case 1: {
                    Box box = (Box)((Object)inlineChild);
                    list.add(box);
                    continue block4;
                }
            }
        }
    }

    public LineBox getLineBox() {
        Box b = this.getParent();
        while (!(b instanceof LineBox)) {
            b = b.getParent();
        }
        return (LineBox)b;
    }

    public List<Box> getElementWithContent() {
        ArrayList<Box> result = new ArrayList<Box>();
        BlockBox container = (BlockBox)this.getLineBox().getParent();
        do {
            List<Box> elementBoxes = container.getElementBoxes(this.getElement());
            for (Box elementBox : elementBoxes) {
                ((InlineLayoutBox)elementBox).addToContentList(result);
            }
        } while (container instanceof AnonymousBlockBox && !this.containsEnd(result) && (container = this.addFollowingBlockBoxes(container, result)) != null);
        return result;
    }

    private AnonymousBlockBox addFollowingBlockBoxes(BlockBox container, List<Box> result) {
        int current;
        Box parent = container.getParent();
        for (current = 0; current < parent.getChildCount(); ++current) {
            if (parent.getChild(current) != container) continue;
            ++current;
            break;
        }
        while (current < parent.getChildCount() && !(parent.getChild(current) instanceof AnonymousBlockBox)) {
            result.add(parent.getChild(current));
            ++current;
        }
        return current == parent.getChildCount() ? null : (AnonymousBlockBox)parent.getChild(current);
    }

    private boolean containsEnd(List<Box> result) {
        for (Box box : result) {
            if (!(box instanceof InlineLayoutBox)) continue;
            InlineLayoutBox iB = (InlineLayoutBox)box;
            if (this.getElement() != iB.getElement() || !iB.isEndsHere()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Box> getElementBoxes(Element elem) {
        ArrayList<Box> result = new ArrayList<Box>();
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            InlineChild child = this.getInlineChild(i);
            if (!(child instanceof Box)) continue;
            Box b = (Box)((Object)child);
            if (b.getElement() == elem) {
                result.add(b);
            }
            result.addAll(b.getElementBoxes(elem));
        }
        return result;
    }

    @Override
    public Dimension positionRelative(CssContext cssCtx) {
        Dimension delta = super.positionRelative(cssCtx);
        this.setX(this.getX() - delta.width);
        this.setY(this.getY() - delta.height);
        List<Box> toTranslate = this.getElementWithContent();
        for (Box box : toTranslate) {
            box.setX(box.getX() + delta.width);
            box.setY(box.getY() + delta.height);
            box.calcCanvasLocation();
            box.calcChildLocations();
        }
        return delta;
    }

    public void addAllChildren(List<Box> list, Layer layer) {
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Box box;
            InlineChild child = this.getInlineChild(i);
            if (!(child instanceof Box) || (box = (Box)((Object)child)).getContainingLayer() != layer) continue;
            list.add(box);
            if (!(child instanceof InlineLayoutBox)) continue;
            InlineLayoutBox inlineLayoutBox = (InlineLayoutBox)child;
            inlineLayoutBox.addAllChildren(list, layer);
        }
    }

    public void paintDebugOutline(RenderingContext c) {
        c.getOutputDevice().drawDebugOutline(c, this, FSRGBColor.BLUE);
    }

    @Override
    protected void resetChildren(LayoutContext c) {
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            InlineChild object = this.getInlineChild(i);
            if (!(object instanceof Box)) continue;
            Box box = (Box)((Object)object);
            box.reset(c);
        }
    }

    @Override
    public void removeChild(Box child) {
        this._inlineChildren.remove(child);
    }

    @Override
    public void removeChild(int i) {
        this._inlineChildren.remove(i);
    }

    @Override
    @CheckReturnValue
    protected @Nullable Box getPrevious(Box child) {
        for (int i = 0; i < this._inlineChildren.size() - 1; ++i) {
            Box box;
            InlineChild obj = this._inlineChildren.get(i);
            if (obj != child) continue;
            if (i == 0) {
                return null;
            }
            InlineChild previous = this._inlineChildren.get(i - 1);
            return previous instanceof Box ? (box = (Box)((Object)previous)) : null;
        }
        return null;
    }

    @Override
    @CheckReturnValue
    protected @Nullable Box getNext(Box child) {
        for (int i = 0; i < this._inlineChildren.size() - 1; ++i) {
            Box box;
            InlineChild obj = this._inlineChildren.get(i);
            if (obj != child) continue;
            InlineChild next = this._inlineChildren.get(i + 1);
            return next instanceof Box ? (box = (Box)((Object)next)) : null;
        }
        return null;
    }

    @Override
    public void calcCanvasLocation() {
        LineBox lineBox = this.getLineBox();
        this.setAbsX(lineBox.getAbsX() + this.getX());
        this.setAbsY(lineBox.getAbsY() + this.getY());
    }

    @Override
    public void calcChildLocations() {
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            InlineChild obj = this.getInlineChild(i);
            if (!(obj instanceof Box)) continue;
            Box child = (Box)((Object)obj);
            child.calcCanvasLocation();
            child.calcChildLocations();
        }
    }

    @Override
    public void clearSelection(List<Box> modified) {
        boolean changed = false;
        block3: for (int i = 0; i < this.getInlineChildCount(); ++i) {
            InlineChild inlineChild;
            InlineChild obj = this.getInlineChild(i);
            Objects.requireNonNull(obj);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Box.class}, (Object)inlineChild, n)) {
                case 0: {
                    Box box = (Box)((Object)inlineChild);
                    box.clearSelection(modified);
                    continue block3;
                }
                default: {
                    changed = changed || ((InlineText)obj).clearSelection();
                }
            }
        }
        if (changed) {
            modified.add(this);
        }
    }

    @Override
    public void selectAll() {
        block4: for (int i = 0; i < this.getInlineChildCount(); ++i) {
            InlineChild inlineChild;
            InlineChild obj = this.getInlineChild(i);
            Objects.requireNonNull(obj);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Box.class, InlineText.class}, (Object)inlineChild, n)) {
                case 0: {
                    Box box = (Box)((Object)inlineChild);
                    box.selectAll();
                    continue block4;
                }
                case 1: {
                    InlineText inlineText = (InlineText)inlineChild;
                    inlineText.selectAll();
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unexpected inline child type: " + obj.getClass().getName());
                }
            }
        }
    }

    @Override
    protected void calcChildPaintingInfo(CssContext c, PaintingInfo result, boolean useCache) {
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            InlineChild obj = this.getInlineChild(i);
            if (!(obj instanceof Box)) continue;
            Box box = (Box)((Object)obj);
            PaintingInfo info = box.calcPaintingInfo(c, useCache);
            this.moveIfGreater(result.getOuterMarginCorner(), info.getOuterMarginCorner());
            result.getAggregateBounds().add(info.getAggregateBounds());
        }
    }

    public void lookForDynamicFunctions(RenderingContext c) {
        block4: for (int i = 0; i < this.getInlineChildCount(); ++i) {
            InlineChild inlineChild;
            InlineChild obj = this.getInlineChild(i);
            Objects.requireNonNull(obj);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InlineText.class, InlineLayoutBox.class}, (Object)inlineChild, n)) {
                case 0: {
                    InlineText iT = (InlineText)inlineChild;
                    if (!iT.isDynamicFunction()) continue block4;
                    iT.updateDynamicValue(c);
                    continue block4;
                }
                case 1: {
                    InlineLayoutBox inlineLayoutBox = (InlineLayoutBox)inlineChild;
                    inlineLayoutBox.lookForDynamicFunctions(c);
                    continue block4;
                }
            }
        }
    }

    @CheckReturnValue
    public @Nullable InlineText findTrailingText() {
        if (this.getInlineChildCount() == 0) {
            return null;
        }
        InlineText result = null;
        block4: for (int offset = this.getInlineChildCount() - 1; offset >= 0; --offset) {
            InlineChild inlineChild;
            InlineChild child = this.getInlineChild(offset);
            Objects.requireNonNull(child);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InlineText.class, InlineLayoutBox.class}, (Object)inlineChild, n)) {
                case 0: {
                    InlineText inlineText;
                    result = inlineText = (InlineText)inlineChild;
                    if (result.isEmpty()) continue block4;
                    return result;
                }
                case 1: {
                    InlineLayoutBox inlineLayoutBox = (InlineLayoutBox)inlineChild;
                    result = inlineLayoutBox.findTrailingText();
                    if (result != null && result.isEmpty()) continue block4;
                    return result;
                }
                default: {
                    return null;
                }
            }
        }
        return result;
    }

    public void calculateTextDecoration(LayoutContext c) {
        List<TextDecoration> decorations = InlineBoxing.calculateTextDecorations(this, this.getBaseline(), this.getStyle().getFSFontMetrics(c));
        this.setTextDecorations(decorations);
    }

    @Override
    @CheckReturnValue
    public @Nullable Box find(CssContext cssCtx, int absX, int absY, boolean findAnonymous) {
        InlineLayoutBox result;
        PaintingInfo pI = this.getPaintingInfo();
        if (pI != null && !pI.getAggregateBounds().contains(absX, absY)) {
            return null;
        }
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Box childBox;
            Box result2;
            InlineChild child = this.getInlineChild(i);
            if (!(child instanceof Box) || (result2 = (childBox = (Box)((Object)child)).find(cssCtx, absX, absY, findAnonymous)) == null) continue;
            return result2;
        }
        Rectangle edge = this.getContentAreaEdge(this.getAbsX(), this.getAbsY(), cssCtx);
        InlineLayoutBox inlineLayoutBox = result = edge.contains(absX, absY) && this.getStyle().isVisible() ? this : null;
        if (!findAnonymous && result != null && this.getElement() == null) {
            return this.getParent().getParent();
        }
        return result;
    }

    @Override
    public int getContainingBlockWidth() {
        return this._containingBlockWidth;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(": ");
        if (this.getElement() != null) {
            result.append("<");
            result.append(this.getElement().getNodeName());
            result.append("> ");
        } else {
            result.append("(anonymous) ");
        }
        if (this.isStartsHere() || this.isEndsHere()) {
            result.append("(");
            if (this.isStartsHere()) {
                result.append("S");
            }
            if (this.isEndsHere()) {
                result.append("E");
            }
            result.append(") ");
        }
        result.append("(baseline=");
        result.append(this._baseline);
        result.append(") ");
        this.appendPosition(result);
        this.appendSize(result);
        return result.toString();
    }

    @Override
    public String dump(LayoutContext c, String indent, Box.Dump which) {
        if (which != Box.Dump.RENDER) {
            throw new IllegalArgumentException("Which " + String.valueOf((Object)which) + " not supported");
        }
        StringBuilder result = new StringBuilder(indent);
        result.append(this);
        for (InlineChild obj : this.getInlineChildren()) {
            result.append('\n');
            if (obj instanceof Box) {
                Box b = (Box)((Object)obj);
                result.append(b.dump(c, indent + "  ", which));
                if (result.charAt(result.length() - 1) != '\n') continue;
                result.deleteCharAt(result.length() - 1);
                continue;
            }
            result.append(indent).append("  ").append(obj);
        }
        return result.toString();
    }

    @Override
    public void restyle(LayoutContext c) {
        super.restyle(c);
        this.calculateTextDecoration(c);
    }

    @Override
    protected void restyleChildren(LayoutContext c) {
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            InlineChild obj = this.getInlineChild(i);
            if (!(obj instanceof Box)) continue;
            Box box = (Box)((Object)obj);
            box.restyle(c);
        }
    }

    @Override
    public Box getRestyleTarget() {
        Box result = this.getParent();
        while (result instanceof InlineLayoutBox) {
            result = result.getParent();
        }
        return result.getParent();
    }

    @Override
    public void collectText(RenderingContext c, StringBuilder buffer) throws IOException {
        for (InlineChild obj : this.getInlineChildren()) {
            if (obj instanceof InlineText) {
                InlineText inlineText = (InlineText)obj;
                buffer.append(inlineText.getTextExportText());
                continue;
            }
            if (obj instanceof Box) {
                Box box = (Box)((Object)obj);
                box.collectText(c, buffer);
                continue;
            }
            throw new IllegalStateException("Unexpected inline child type: " + obj.getClass().getName());
        }
    }

    public void countJustifiableChars(CharCounts counts) {
        boolean justifyThis = this.getStyle().isTextJustify();
        for (InlineChild o : this.getInlineChildren()) {
            if (o instanceof InlineLayoutBox) {
                InlineLayoutBox inlineLayoutBox = (InlineLayoutBox)o;
                inlineLayoutBox.countJustifiableChars(counts);
                continue;
            }
            if (!(o instanceof InlineText)) continue;
            InlineText inlineText = (InlineText)o;
            if (!justifyThis) continue;
            inlineText.countJustifiableChars(counts);
        }
    }

    public float adjustHorizontalPosition(JustificationInfo info, float adjust) {
        float runningTotal = adjust;
        float result = 0.0f;
        for (InlineChild o : this.getInlineChildren()) {
            InlineChild inlineChild;
            Objects.requireNonNull(o);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InlineText.class, Box.class}, (Object)inlineChild, n)) {
                case 0: {
                    InlineText iT = (InlineText)inlineChild;
                    iT.setX(iT.getX() + Math.round(result));
                    float adj = iT.calcTotalAdjustment(info);
                    result += adj;
                    runningTotal += adj;
                    break;
                }
                case 1: {
                    Box b = (Box)((Object)inlineChild);
                    b.setX(b.getX() + Math.round(runningTotal));
                    if (!(b instanceof InlineLayoutBox)) break;
                    float adj = ((InlineLayoutBox)b).adjustHorizontalPosition(info, runningTotal);
                    result += adj;
                    runningTotal += adj;
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public int getEffectiveWidth() {
        return this.getInlineWidth();
    }

    private record MarginLeftRight(float left, float right) {
    }
}

