/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.util;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.JDKXRLogger;
import org.xhtmlrenderer.util.XRLogger;

public class XRLog {
    private static final List<String> LOGGER_NAMES = new ArrayList<String>(20);
    public static final String CONFIG = XRLog.registerLoggerByName("org.xhtmlrenderer.config");
    public static final String EXCEPTION = XRLog.registerLoggerByName("org.xhtmlrenderer.exception");
    public static final String GENERAL = XRLog.registerLoggerByName("org.xhtmlrenderer.general");
    public static final String INIT = XRLog.registerLoggerByName("org.xhtmlrenderer.init");
    public static final String JUNIT = XRLog.registerLoggerByName("org.xhtmlrenderer.junit");
    public static final String LOAD = XRLog.registerLoggerByName("org.xhtmlrenderer.load");
    public static final String MATCH = XRLog.registerLoggerByName("org.xhtmlrenderer.match");
    public static final String CASCADE = XRLog.registerLoggerByName("org.xhtmlrenderer.cascade");
    public static final String XML_ENTITIES = XRLog.registerLoggerByName("org.xhtmlrenderer.load.xml-entities");
    public static final String CSS_PARSE = XRLog.registerLoggerByName("org.xhtmlrenderer.css-parse");
    public static final String LAYOUT = XRLog.registerLoggerByName("org.xhtmlrenderer.layout");
    public static final String RENDER = XRLog.registerLoggerByName("org.xhtmlrenderer.render");
    private static XRLogger loggerImpl = new JDKXRLogger();
    private static boolean loggingEnabled = Configuration.isTrue("xr.util-logging.loggingEnabled", true);

    private static String registerLoggerByName(String loggerName) {
        LOGGER_NAMES.add(loggerName);
        return loggerName;
    }

    @CheckReturnValue
    public static List<String> listRegisteredLoggers() {
        return Collections.unmodifiableList(LOGGER_NAMES);
    }

    public static void cssParse(String msg) {
        XRLog.cssParse(Level.INFO, msg);
    }

    public static void cssParse(Level level, String msg) {
        XRLog.log(CSS_PARSE, level, msg);
    }

    public static void cssParse(Level level, String msg, Throwable th) {
        XRLog.log(CSS_PARSE, level, msg, th);
    }

    public static void xmlEntities(String msg) {
        XRLog.xmlEntities(Level.INFO, msg);
    }

    public static void xmlEntities(Level level, String msg) {
        XRLog.log(XML_ENTITIES, level, msg);
    }

    public static void xmlEntities(Level level, String msg, Throwable th) {
        XRLog.log(XML_ENTITIES, level, msg, th);
    }

    public static void cascade(String msg) {
        XRLog.cascade(Level.INFO, msg);
    }

    public static void cascade(Level level, String msg) {
        XRLog.log(CASCADE, level, msg);
    }

    public static void cascade(Level level, String msg, Throwable th) {
        XRLog.log(CASCADE, level, msg, th);
    }

    public static void exception(String msg) {
        XRLog.exception(msg, null);
    }

    public static void exception(String msg, @Nullable Throwable th) {
        XRLog.log(EXCEPTION, Level.WARNING, msg, th);
    }

    public static void general(String msg) {
        XRLog.general(Level.INFO, msg);
    }

    public static void general(Level level, String msg) {
        XRLog.log(GENERAL, level, msg);
    }

    public static void general(Level level, String msg, Throwable th) {
        XRLog.log(GENERAL, level, msg, th);
    }

    public static void init(String msg) {
        XRLog.init(Level.INFO, msg);
    }

    public static void init(Level level, String msg) {
        XRLog.log(INIT, level, msg);
    }

    public static void init(Level level, String msg, Throwable th) {
        XRLog.log(INIT, level, msg, th);
    }

    public static void junit(String msg) {
        XRLog.junit(Level.FINEST, msg);
    }

    public static void junit(Level level, String msg) {
        XRLog.log(JUNIT, level, msg);
    }

    public static void junit(Level level, String msg, Throwable th) {
        XRLog.log(JUNIT, level, msg, th);
    }

    public static void load(String msg) {
        XRLog.load(Level.INFO, msg);
    }

    public static void load(Level level, String msg) {
        XRLog.log(LOAD, level, msg);
    }

    public static void load(Level level, String msg, Throwable th) {
        XRLog.log(LOAD, level, msg, th);
    }

    public static void match(String msg) {
        XRLog.match(Level.INFO, msg);
    }

    public static void match(Level level, String msg) {
        XRLog.log(MATCH, level, msg);
    }

    public static void match(Level level, String msg, Throwable th) {
        XRLog.log(MATCH, level, msg, th);
    }

    public static void layout(String msg) {
        XRLog.layout(Level.INFO, msg);
    }

    public static void layout(Level level, String msg) {
        XRLog.log(LAYOUT, level, msg);
    }

    public static void layout(Level level, String msg, Throwable th) {
        XRLog.log(LAYOUT, level, msg, th);
    }

    public static void render(String msg) {
        XRLog.render(Level.INFO, msg);
    }

    public static void render(Level level, String msg) {
        XRLog.log(RENDER, level, msg);
    }

    public static void render(Level level, String msg, Throwable th) {
        XRLog.log(RENDER, level, msg, th);
    }

    public static void log(String where, Level level, String msg) {
        if (XRLog.isLoggingEnabled()) {
            loggerImpl.log(where, level, msg);
        }
    }

    public static void log(String where, Level level, String msg, @Nullable Throwable th) {
        if (XRLog.isLoggingEnabled()) {
            loggerImpl.log(where, level, msg, th);
        }
    }

    public static void setLevel(String log, Level level) {
        loggerImpl.setLevel(log, level);
    }

    @CheckReturnValue
    public static boolean isLoggingEnabled() {
        return loggingEnabled;
    }

    public static void setLoggingEnabled(boolean loggingEnabled) {
        XRLog.loggingEnabled = loggingEnabled;
    }

    @CheckReturnValue
    public static XRLogger getLoggerImpl() {
        return loggerImpl;
    }

    public static void setLoggerImpl(XRLogger loggerImpl) {
        XRLog.loggerImpl = Objects.requireNonNull(loggerImpl);
    }
}

