/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.resource.ImageResource;
import org.xhtmlrenderer.swing.AWTFSImage;
import org.xhtmlrenderer.swing.AWTFSImageFactory;
import org.xhtmlrenderer.swing.ImageLoadQueue;
import org.xhtmlrenderer.swing.ImageLoadWorker;
import org.xhtmlrenderer.swing.MutableFSImage;
import org.xhtmlrenderer.swing.RepaintListener;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.IOUtil;
import org.xhtmlrenderer.util.ImageUtil;
import org.xhtmlrenderer.util.XRLog;

public class ImageResourceLoader {
    public static final RepaintListener NO_OP_REPAINT_LISTENER = doLayout -> XRLog.general(Level.FINE, "No-op repaint requested");
    private final Map<CacheKey, ImageResource> _imageCache;
    private final @Nullable ImageLoadQueue _loadQueue;
    private final int _imageCacheCapacity;
    private final RepaintListener _repaintListener;
    private final boolean _useBackgroundImageLoading;

    public ImageResourceLoader() {
        this(16, NO_OP_REPAINT_LISTENER);
    }

    public ImageResourceLoader(RepaintListener repaintListener) {
        this(16, repaintListener);
    }

    public ImageResourceLoader(int cacheSize, RepaintListener repaintListener) {
        this._imageCacheCapacity = cacheSize;
        this._useBackgroundImageLoading = Configuration.isTrue("xr.image.background.loading.enable", false);
        if (this._useBackgroundImageLoading) {
            this._loadQueue = new ImageLoadQueue();
            int workerCount = Configuration.valueAsInt("xr.image.background.workers", 5);
            for (int i = 0; i < workerCount; ++i) {
                new ImageLoadWorker(this._loadQueue).start();
            }
        } else {
            this._loadQueue = null;
        }
        this._imageCache = new LinkedHashMap<CacheKey, ImageResource>(cacheSize, 0.75f, true);
        this._repaintListener = repaintListener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImageResource loadImageResourceFromUri(String uri) {
        if (ImageUtil.isEmbeddedBase64Image(uri)) {
            return ImageResourceLoader.loadEmbeddedBase64ImageResource(uri);
        }
        try (InputStream is = IOUtil.getInputStream(uri);){
            if (is == null) {
                ImageResource imageResource = ImageResourceLoader.createImageResource(uri, null);
                return imageResource;
            }
            BufferedImage img = ImageIO.read(is);
            if (img == null) {
                throw new IOException("ImageIO.read() returned null");
            }
            ImageResource imageResource = ImageResourceLoader.createImageResource(uri, img);
            return imageResource;
        }
        catch (IOException e) {
            XRLog.exception("Can't open stream for URI '" + uri + "': " + e.getMessage());
        }
        return ImageResourceLoader.createImageResource(uri, null);
    }

    public static ImageResource loadEmbeddedBase64ImageResource(String uri) {
        BufferedImage bufferedImage = ImageUtil.loadEmbeddedBase64Image(uri);
        if (bufferedImage != null) {
            FSImage image = AWTFSImageFactory.createImage(bufferedImage);
            return new ImageResource(null, image);
        }
        return new ImageResource(null, null);
    }

    public synchronized void shrink() {
        int ovr = this._imageCache.size() - this._imageCacheCapacity;
        Iterator<CacheKey> it = this._imageCache.keySet().iterator();
        while (it.hasNext() && ovr-- > 0) {
            it.next();
            it.remove();
        }
    }

    public synchronized void clear() {
        this._imageCache.clear();
    }

    @CheckReturnValue
    public ImageResource get(String uri) {
        return this.get(uri, -1, -1);
    }

    @CheckReturnValue
    public synchronized ImageResource get(String uri, int width, int height) {
        if (ImageUtil.isEmbeddedBase64Image(uri)) {
            ImageResource resource = ImageResourceLoader.loadEmbeddedBase64ImageResource(uri);
            FSImage image = resource.getImage();
            FSImage scaledImage = image == null ? null : (FSImage)image.scale(width, height);
            return new ImageResource(resource.getImageUri(), scaledImage);
        }
        CacheKey key = new CacheKey(uri, width, height);
        ImageResource ir = this._imageCache.get(key);
        if (ir == null) {
            ir = this._imageCache.get(new CacheKey(uri, -1, -1));
            if (ir == null) {
                if (this.isImmediateLoadUri(uri)) {
                    XRLog.load(Level.FINE, "Load immediate: " + uri);
                    ir = ImageResourceLoader.loadImageResourceFromUri(uri);
                    FSImage awtfsImage = ir.getImage();
                    BufferedImage newImg = ((AWTFSImage)awtfsImage).getImage();
                    this.loaded(ir, -1, -1);
                    if (width > -1 && height > -1) {
                        XRLog.load(Level.FINE, String.valueOf(this) + ", scaling " + uri + " to " + width + ", " + height);
                        newImg = ImageUtil.getScaledInstance(newImg, width, height);
                        ir = new ImageResource(ir.getImageUri(), AWTFSImageFactory.createImage(newImg));
                        this.loaded(ir, width, height);
                    }
                } else {
                    XRLog.load(Level.FINE, "Image cache miss, URI not yet loaded, queueing: " + uri);
                    MutableFSImage mfsi = new MutableFSImage(this._repaintListener);
                    ir = new ImageResource(uri, mfsi);
                    this._loadQueue.addToQueue(this, uri, mfsi, width, height);
                }
                this._imageCache.put(key, ir);
            } else {
                XRLog.load(Level.FINE, String.valueOf(this) + ", scaling " + uri + " to " + width + ", " + height);
                FSImage awtfsImage = ir.getImage();
                BufferedImage newImg = ((AWTFSImage)awtfsImage).getImage();
                newImg = ImageUtil.getScaledInstance(newImg, width, height);
                ir = new ImageResource(ir.getImageUri(), AWTFSImageFactory.createImage(newImg));
                this.loaded(ir, width, height);
            }
        }
        return ir;
    }

    public boolean isImmediateLoadUri(String uri) {
        return !this._useBackgroundImageLoading || uri.startsWith("jar:file:") || uri.startsWith("file:");
    }

    public synchronized void loaded(ImageResource ir, int width, int height) {
        String imageUri = ir.getImageUri();
        if (imageUri != null) {
            this._imageCache.put(new CacheKey(imageUri, width, height), ir);
        }
    }

    public static ImageResource createImageResource(String uri, @Nullable BufferedImage img) {
        if (img == null) {
            return new ImageResource(uri, AWTFSImageFactory.createImage(ImageUtil.createTransparentImage(10, 10)));
        }
        return new ImageResource(uri, AWTFSImageFactory.createImage(ImageUtil.makeCompatible(img)));
    }

    public void stopLoading() {
        if (this._loadQueue != null) {
            XRLog.load("By request, clearing pending items from load queue: " + this._loadQueue.size());
            this._loadQueue.reset();
        }
    }

    private record CacheKey(String uri, int width, int height) {
    }
}

