/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.xhtmlrenderer.context.StyleReference;
import org.xhtmlrenderer.css.constants.ValueConstants;
import org.xhtmlrenderer.css.util.ConversionUtil;

final class ElementPropertiesPanel
extends JPanel {
    private final StyleReference _sr;
    private final JTable _properties;
    private final TableModel _defaultTableModel;

    ElementPropertiesPanel(StyleReference sr) {
        this._sr = sr;
        this._properties = new PropertiesJTable();
        this._defaultTableModel = new DefaultTableModel();
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this._properties), "Center");
    }

    public void setForElement(Node node) {
        this._properties.setModel(this.tableModel(node));
        TableColumnModel model = this._properties.getColumnModel();
        if (model.getColumnCount() > 0) {
            model.getColumn(0).sizeWidthToFit();
        }
    }

    private TableModel tableModel(Node node) {
        if (node.getNodeType() != 1) {
            Toolkit.getDefaultToolkit().beep();
            return this._defaultTableModel;
        }
        Map<String, CSSPrimitiveValue> props = this._sr.getCascadedPropertiesMap((Element)node);
        return new PropertiesTableModel(props);
    }

    static final class PropertiesJTable
    extends JTable {
        private final Font propLabelFont;
        private final Font defaultFont;

        PropertiesJTable() {
            this.setColumnSelectionAllowed(false);
            this.setSelectionMode(0);
            this.propLabelFont = new Font("Courier New", 1, 12);
            this.defaultFont = new Font("Default", 0, 12);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            JLabel label = (JLabel)((Object)super.getCellRenderer(row, col));
            label.setBackground(Color.white);
            label.setFont(this.defaultFont);
            if (col == 0) {
                label.setFont(this.propLabelFont);
            } else if (col == 2) {
                PropertiesTableModel model = (PropertiesTableModel)this.getModel();
                Map.Entry<String, CSSPrimitiveValue> me = model._properties.get(row);
                CSSPrimitiveValue cpv = me.getValue();
                if (cpv.getCssText().startsWith("rgb")) {
                    label.setBackground(ConversionUtil.rgbToColor(cpv.getRGBColorValue()));
                }
            }
            return (TableCellRenderer)((Object)label);
        }
    }

    static class PropertiesTableModel
    extends AbstractTableModel {
        private final String[] _colNames = new String[]{"Property Name", "Text", "Value"};
        private final List<Map.Entry<String, CSSPrimitiveValue>> _properties;

        PropertiesTableModel(Map<String, CSSPrimitiveValue> cssProperties) {
            this._properties = new ArrayList<Map.Entry<String, CSSPrimitiveValue>>(cssProperties.entrySet());
        }

        @Override
        public String getColumnName(int col) {
            return this._colNames[col];
        }

        @Override
        public int getColumnCount() {
            return this._colNames.length;
        }

        @Override
        public int getRowCount() {
            return this._properties.size();
        }

        @Override
        @CheckReturnValue
        public @Nullable Object getValueAt(int row, int col) {
            Map.Entry<String, CSSPrimitiveValue> me = this._properties.get(row);
            CSSPrimitiveValue cpv = me.getValue();
            return switch (col) {
                case 0 -> me.getKey();
                case 1 -> cpv.getCssText();
                case 2 -> {
                    if (ValueConstants.isNumber(cpv.getPrimitiveType())) {
                        yield Float.valueOf(cpv.getFloatValue(cpv.getPrimitiveType()));
                    }
                    yield "";
                }
                default -> null;
            };
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

