/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import com.google.errorprone.annotations.CheckReturnValue;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.newtable.CollapsedBorderValue;
import org.xhtmlrenderer.newtable.TableCellBox;

public class CollapsedBorderSide
implements Comparable<CollapsedBorderSide> {
    private final TableCellBox _cell;
    private final int _side;

    public CollapsedBorderSide(TableCellBox cell, int side) {
        this._side = side;
        this._cell = cell;
    }

    public TableCellBox getCell() {
        return this._cell;
    }

    public int getSide() {
        return this._side;
    }

    @Override
    public int compareTo(CollapsedBorderSide that) {
        CollapsedBorderValue v2;
        CollapsedBorderValue v1 = CollapsedBorderSide.getCollapsedBorder(this);
        CollapsedBorderValue result = TableCellBox.compareBorders(v1, v2 = CollapsedBorderSide.getCollapsedBorder(that), true);
        if (result == null) {
            return 0;
        }
        return result == v1 ? 1 : -1;
    }

    @CheckReturnValue
    private static @Nullable CollapsedBorderValue getCollapsedBorder(CollapsedBorderSide c1) {
        return switch (c1._side) {
            case 1 -> c1._cell.getCollapsedBorderTop();
            case 8 -> c1._cell.getCollapsedBorderRight();
            case 4 -> c1._cell.getCollapsedBorderBottom();
            case 2 -> c1._cell.getCollapsedBorderLeft();
            default -> null;
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CollapsedBorderSide)) {
            return false;
        }
        CollapsedBorderSide that = (CollapsedBorderSide)o;
        return this._side == that._side && this._cell.equals(that._cell);
    }

    public int hashCode() {
        int result = this._cell.hashCode();
        result = 31 * result + this._side;
        return result;
    }
}

