/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.sheet;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.css.constants.MarginBoxName;
import org.xhtmlrenderer.css.sheet.PropertyDeclaration;
import org.xhtmlrenderer.css.sheet.Ruleset;
import org.xhtmlrenderer.css.sheet.RulesetContainer;
import org.xhtmlrenderer.css.sheet.StylesheetInfo;

public class PageRule
implements RulesetContainer {
    private final String _name;
    private final String _pseudoPage;
    private final Ruleset _ruleset;
    private final StylesheetInfo.Origin _origin;
    private final Map<MarginBoxName, List<PropertyDeclaration>> _marginBoxes = new HashMap<MarginBoxName, List<PropertyDeclaration>>();
    private int _pos;
    private final int _specificityF;
    private final int _specificityG;
    private final int _specificityH;

    public PageRule(StylesheetInfo.Origin origin, @Nullable String name, @Nullable String pseudoPage, Map<MarginBoxName, List<PropertyDeclaration>> marginBoxes, Ruleset ruleset) {
        this._origin = origin;
        this._name = name;
        this._specificityF = name == null ? 0 : 1;
        this._ruleset = ruleset;
        this._pseudoPage = pseudoPage;
        this._specificityG = "first".equals(pseudoPage) ? 1 : 0;
        this._specificityH = "first".equals(pseudoPage) ? 0 : 1;
        this._marginBoxes.putAll(marginBoxes);
    }

    public String getPseudoPage() {
        return this._pseudoPage;
    }

    public Ruleset getRuleset() {
        return this._ruleset;
    }

    @Override
    public void addContent(Ruleset ruleset) {
        throw new IllegalStateException("Ruleset has already been set");
    }

    @Override
    public StylesheetInfo.Origin getOrigin() {
        return this._origin;
    }

    public String getName() {
        return this._name;
    }

    public List<PropertyDeclaration> getMarginBoxProperties(MarginBoxName name) {
        return this._marginBoxes.get(name);
    }

    public Map<MarginBoxName, List<PropertyDeclaration>> getMarginBoxes() {
        return this._marginBoxes;
    }

    public long getOrder() {
        long result = 0L;
        result |= (long)this._specificityF << 32;
        result |= (long)this._specificityG << 24;
        result |= (long)this._specificityH << 16;
        return result |= (long)this._pos;
    }

    public boolean applies(@Nullable String pageName, String pseudoPage) {
        if (this._name == null && this._pseudoPage == null) {
            return true;
        }
        if (this._name == null && (this._pseudoPage.equals(pseudoPage) || this._pseudoPage.equals("right") && pseudoPage != null && pseudoPage.equals("first"))) {
            return true;
        }
        if (this._name != null && this._name.equals(pageName) && this._pseudoPage == null) {
            return true;
        }
        return this._name != null && this._name.equals(pageName) && this._pseudoPage.equals(pseudoPage);
    }

    public int getPos() {
        return this._pos;
    }

    public void setPos(int pos) {
        this._pos = pos;
    }
}

