/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.sheet;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.xhtmlrenderer.css.sheet.Ruleset;
import org.xhtmlrenderer.css.sheet.RulesetContainer;
import org.xhtmlrenderer.css.sheet.StylesheetInfo;

public class MediaRule
implements RulesetContainer {
    private final List<String> _mediaTypes = new ArrayList<String>();
    private final List<Ruleset> _contents = new ArrayList<Ruleset>();
    private final StylesheetInfo.Origin _origin;

    public MediaRule(StylesheetInfo.Origin origin) {
        this._origin = origin;
    }

    public void addMedium(String medium) {
        this._mediaTypes.add(medium);
    }

    @CheckReturnValue
    public boolean matches(String medium) {
        return medium.equalsIgnoreCase("all") || this._mediaTypes.contains("all") || this._mediaTypes.contains(medium.toLowerCase(Locale.ROOT));
    }

    @Override
    public void addContent(Ruleset ruleset) {
        this._contents.add(ruleset);
    }

    public List<Ruleset> getContents() {
        return this._contents;
    }

    @Override
    public StylesheetInfo.Origin getOrigin() {
        return this._origin;
    }

    public String toString() {
        return "%s{origin: %s}".formatted(new Object[]{this.getClass().getSimpleName(), this._origin});
    }
}

