/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.xhtmlrenderer.extend.Size;
import org.xhtmlrenderer.resource.ImageResource;
import org.xhtmlrenderer.swing.AWTFSImage;
import org.xhtmlrenderer.swing.ImageReplacedElement;
import org.xhtmlrenderer.swing.RepaintListener;
import org.xhtmlrenderer.util.ImageUtil;
import org.xhtmlrenderer.util.XRLog;

public class DeferredImageReplacedElement
implements ImageReplacedElement {
    private Point _location = new Point(0, 0);
    private final RepaintListener repaintListener;
    private final Size targetSize;
    private final boolean _doScaleImage;
    private boolean _loaded;
    private final ImageResource _imageResource;
    private Image _image;

    public DeferredImageReplacedElement(ImageResource imageResource, RepaintListener repaintListener, int w, int h) {
        this._imageResource = imageResource;
        this._loaded = false;
        this.repaintListener = repaintListener;
        this._doScaleImage = w != -1 || h != -1;
        this.targetSize = new Size(Math.max(1, w), Math.max(1, h));
        this._image = ImageUtil.createCompatibleBufferedImage(this.targetSize);
    }

    @Override
    public int getIntrinsicHeight() {
        return this._loaded ? this._image.getHeight(null) : this.targetSize.height();
    }

    @Override
    public int getIntrinsicWidth() {
        return this._loaded ? this._image.getWidth(null) : this.targetSize.width();
    }

    @Override
    public Point getLocation() {
        return this._location;
    }

    @Override
    public void setLocation(int x, int y) {
        this._location = new Point(x, y);
    }

    @Override
    public Image getImage() {
        if (!this._loaded && this._imageResource.isLoaded()) {
            BufferedImage image = ((AWTFSImage)this._imageResource.getImage()).getImage();
            if (this._doScaleImage && (this.targetSize.width() > 0 || this.targetSize.height() > 0)) {
                int w = ((Image)image).getWidth(null);
                int h = ((Image)image).getHeight(null);
                int newW = this.targetSize.width();
                int newH = this.targetSize.height();
                if (newW == -1) {
                    newW = (int)((double)w * ((double)newH / (double)h));
                }
                if (newH == -1) {
                    newH = (int)((double)h * ((double)newW / (double)w));
                }
                if (w != newW || h != newH) {
                    if (image instanceof BufferedImage) {
                        BufferedImage bufferedImage = image;
                        image = ImageUtil.getScaledInstance(bufferedImage, newW, newH);
                    } else {
                        throw new RuntimeException("image is not a buffered image! " + this._imageResource.getImageUri());
                    }
                }
            }
            this._image = image;
            this._loaded = true;
            XRLog.load(Level.FINE, "Icon: replaced image " + this._imageResource.getImageUri() + ", repaint requested");
            SwingUtilities.invokeLater(() -> this.repaintListener.repaintRequested(this._doScaleImage));
        }
        return this._image;
    }
}

