/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import org.w3c.dom.Document;
import org.xhtmlrenderer.context.StyleReference;
import org.xhtmlrenderer.swing.DOMSelectionListener;
import org.xhtmlrenderer.swing.DOMTreeCellRenderer;
import org.xhtmlrenderer.swing.DOMTreeModel;
import org.xhtmlrenderer.swing.ElementPropertiesPanel;

public final class DOMInspector
extends JPanel {
    private StyleReference styleReference;
    private DOMSelectionListener nodeSelectionListener;
    private final JSplitPane splitPane;
    private Document doc;
    private final JTree tree;

    public DOMInspector(Document doc, StyleReference sr) {
        this.setLayout(new BorderLayout());
        this.tree = new JTree();
        this.tree.getSelectionModel().setSelectionMode(1);
        JScrollPane scroll = new JScrollPane(this.tree);
        this.splitPane = new JSplitPane(1);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(150);
        this.add((Component)this.splitPane, "Center");
        this.splitPane.setLeftComponent(scroll);
        JButton close = new JButton("close");
        this.add((Component)close, "South");
        this.setPreferredSize(new Dimension(300, 300));
        this.doc = doc;
        this.styleReference = sr;
        this.initForCurrentDocument();
        close.addActionListener(evt -> this.getFrame(this).setVisible(false));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawLine(0, 0, 100, 100);
    }

    public void setForDocument(Document doc, StyleReference sr) {
        this.doc = Objects.requireNonNull(doc);
        this.styleReference = Objects.requireNonNull(sr);
        this.initForCurrentDocument();
    }

    public JFrame getFrame(Component comp) {
        if (comp instanceof JFrame) {
            JFrame frame = (JFrame)comp;
            return frame;
        }
        return this.getFrame(comp.getParent());
    }

    private void initForCurrentDocument() {
        DOMTreeModel model = new DOMTreeModel(this.doc);
        this.tree.setModel(model);
        if (!(this.tree.getCellRenderer() instanceof DOMTreeCellRenderer)) {
            this.tree.setCellRenderer(new DOMTreeCellRenderer());
        }
        this.splitPane.remove(this.splitPane.getRightComponent());
        ElementPropertiesPanel elementPropPanel = new ElementPropertiesPanel(this.styleReference);
        this.splitPane.setRightComponent(elementPropPanel);
        this.tree.removeTreeSelectionListener(this.nodeSelectionListener);
        this.nodeSelectionListener = new DOMSelectionListener(this.tree, elementPropPanel);
        this.tree.addTreeSelectionListener(this.nodeSelectionListener);
    }
}

