/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.context.AWTFontResolver;
import org.xhtmlrenderer.context.StyleReference;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.EmptyStyle;
import org.xhtmlrenderer.css.value.FontSpecification;
import org.xhtmlrenderer.extend.FSCanvas;
import org.xhtmlrenderer.extend.FontContext;
import org.xhtmlrenderer.extend.FontResolver;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.extend.OutputDevice;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.TextRenderer;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.breaker.DefaultLineBreakingStrategy;
import org.xhtmlrenderer.layout.breaker.LineBreakingStrategy;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.FSFont;
import org.xhtmlrenderer.render.FSFontMetrics;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.simple.extend.FormSubmissionListener;
import org.xhtmlrenderer.swing.Java2DTextRenderer;
import org.xhtmlrenderer.swing.NaiveUserAgent;
import org.xhtmlrenderer.swing.SwingReplacedElementFactory;
import org.xhtmlrenderer.util.XRLog;

public final class SharedContext {
    private static final Set<String> PAGED_MEDIA_TYPES = new HashSet<String>(Arrays.asList("print", "projection", "embossed", "handheld", "tv"));
    private TextRenderer textRenderer;
    private String media;
    private UserAgentCallback uac;
    private boolean interactive = true;
    private final Map<String, Box> idMap = new HashMap<String, Box>();
    private float dpi;
    private static final int MM__PER__CM = 10;
    private static final float CM__PER__IN = 2.54f;
    private float mm_per_dot;
    private static final float DEFAULT_DPI = 72.0f;
    private boolean print;
    private int dotsPerPixel = 1;
    private @Nullable Map<Element, CalculatedStyle> styleMap;
    private ReplacedElementFactory replacedElementFactory;
    private @Nullable Rectangle temporaryCanvas;
    private LineBreakingStrategy lineBreakingStrategy = new DefaultLineBreakingStrategy();
    private FontResolver fontResolver;
    private StyleReference css;
    private boolean debug_draw_boxes;
    private boolean debug_draw_line_boxes;
    private boolean debug_draw_inline_boxes;
    private boolean debug_draw_font_metrics;
    private @Nullable FSCanvas canvas;
    private @Nullable NamespaceHandler namespaceHandler;

    public SharedContext() {
        this(new NaiveUserAgent());
    }

    public SharedContext(UserAgentCallback userAgent, FontResolver fontResolver, ReplacedElementFactory replacedElementFactory, TextRenderer textRenderer, float dpi, int dotsPerPixel) {
        this.uac = Objects.requireNonNull(userAgent);
        this.css = new StyleReference(userAgent);
        this.fontResolver = Objects.requireNonNull(fontResolver);
        this.replacedElementFactory = replacedElementFactory;
        this.textRenderer = Objects.requireNonNull(textRenderer);
        this.media = "screen";
        this.setDPI(dpi);
        this.setDotsPerPixel(dotsPerPixel);
        this.setPrint(true);
        this.setInteractive(false);
    }

    public SharedContext(UserAgentCallback uac, float dpi, int pixelsPerDot) {
        this(uac);
        this.setDPI(dpi);
        this.setDotsPerPixel(pixelsPerDot);
    }

    public SharedContext(UserAgentCallback uac) {
        this.fontResolver = new AWTFontResolver();
        this.replacedElementFactory = new SwingReplacedElementFactory();
        this.media = "screen";
        this.uac = Objects.requireNonNull(uac);
        this.css = new StyleReference(uac);
        XRLog.render("Using CSS implementation from: " + this.getCss().getClass().getName());
        this.textRenderer = new Java2DTextRenderer();
        try {
            this.setDPI(Toolkit.getDefaultToolkit().getScreenResolution());
        }
        catch (HeadlessException e) {
            this.setDPI(72.0f);
        }
    }

    public SharedContext(UserAgentCallback uac, FontResolver fr, ReplacedElementFactory ref, TextRenderer tr, float dpi) {
        this.fontResolver = Objects.requireNonNull(fr);
        this.replacedElementFactory = ref;
        this.media = "screen";
        this.uac = uac;
        this.css = new StyleReference(uac);
        XRLog.render("Using CSS implementation from: " + this.getCss().getClass().getName());
        this.textRenderer = Objects.requireNonNull(tr);
        this.setDPI(dpi);
        this.setPrint(true);
        this.setInteractive(false);
    }

    public void setFormSubmissionListener(FormSubmissionListener fsl) {
        this.replacedElementFactory.setFormSubmissionListener(fsl);
    }

    public LayoutContext newLayoutContextInstance(FontContext fontContext) {
        return new LayoutContext(this, fontContext);
    }

    public RenderingContext newRenderingContextInstance(OutputDevice outputDevice, FontContext fontContext) {
        return this.newRenderingContextInstance(outputDevice, fontContext, null, 0);
    }

    public RenderingContext newRenderingContextInstance(OutputDevice outputDevice, FontContext fontContext, @Nullable Layer rootLayer, int initialPageNo) {
        return new RenderingContext(this, outputDevice, fontContext, rootLayer, initialPageNo);
    }

    @CheckReturnValue
    public FontResolver getFontResolver() {
        return this.fontResolver;
    }

    public void flushFonts() {
        this.fontResolver.flushCache();
    }

    @CheckReturnValue
    public String getMedia() {
        return this.media;
    }

    @CheckReturnValue
    public TextRenderer getTextRenderer() {
        return this.textRenderer;
    }

    public boolean debugDrawBoxes() {
        return this.debug_draw_boxes;
    }

    public boolean debugDrawLineBoxes() {
        return this.debug_draw_line_boxes;
    }

    public boolean debugDrawInlineBoxes() {
        return this.debug_draw_inline_boxes;
    }

    public boolean debugDrawFontMetrics() {
        return this.debug_draw_font_metrics;
    }

    public void setDebug_draw_boxes(boolean debug_draw_boxes) {
        this.debug_draw_boxes = debug_draw_boxes;
    }

    public void setDebug_draw_line_boxes(boolean debug_draw_line_boxes) {
        this.debug_draw_line_boxes = debug_draw_line_boxes;
    }

    public void setDebug_draw_inline_boxes(boolean debug_draw_inline_boxes) {
        this.debug_draw_inline_boxes = debug_draw_inline_boxes;
    }

    public void setDebug_draw_font_metrics(boolean debug_draw_font_metrics) {
        this.debug_draw_font_metrics = debug_draw_font_metrics;
    }

    public StyleReference getCss() {
        return this.css;
    }

    public void setCss(StyleReference css) {
        this.css = css;
    }

    @CheckReturnValue
    public @Nullable FSCanvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(FSCanvas canvas) {
        this.canvas = canvas;
    }

    public void setTemporaryCanvas(Rectangle rect) {
        this.temporaryCanvas = rect;
    }

    public @Nullable Rectangle getFixedRectangle() {
        if (this.getCanvas() == null) {
            return this.temporaryCanvas;
        }
        Rectangle rect = this.getCanvas().getFixedRectangle();
        rect.translate(this.getCanvas().getX(), this.getCanvas().getY());
        return rect;
    }

    public void setNamespaceHandler(NamespaceHandler nh) {
        this.namespaceHandler = nh;
    }

    public @Nullable NamespaceHandler getNamespaceHandler() {
        return this.namespaceHandler;
    }

    public void addBoxId(String id, Box box) {
        this.idMap.put(id, box);
    }

    @CheckReturnValue
    public @Nullable Box getBoxById(String id) {
        return this.idMap.get(id);
    }

    public void removeBoxId(String id) {
        this.idMap.remove(id);
    }

    public Map<String, Box> getIdMap() {
        return this.idMap;
    }

    @Deprecated
    public void setTextRenderer(TextRenderer textRenderer) {
        this.textRenderer = Objects.requireNonNull(textRenderer);
    }

    public void setMedia(String media) {
        this.media = Objects.requireNonNull(media);
    }

    @CheckReturnValue
    public UserAgentCallback getUac() {
        return this.uac;
    }

    public UserAgentCallback getUserAgentCallback() {
        return this.uac;
    }

    public void setUserAgentCallback(UserAgentCallback userAgentCallback) {
        this.getCss().setUserAgentCallback(userAgentCallback);
        this.uac = Objects.requireNonNull(userAgentCallback);
    }

    public float getDPI() {
        return this.dpi;
    }

    public void setDPI(float dpi) {
        this.dpi = dpi;
        this.mm_per_dot = 25.4f / dpi;
    }

    public float getMmPerPx() {
        return this.mm_per_dot;
    }

    @CheckReturnValue
    public @Nullable FSFont getFont(FontSpecification spec) {
        return this.fontResolver.resolveFont(this, spec);
    }

    public float getXHeight(FontContext fontContext, FontSpecification fs) {
        FSFont font = this.fontResolver.resolveFont(this, fs);
        FSFontMetrics fm = this.getTextRenderer().getFSFontMetrics(fontContext, font, " ");
        float sto = fm.getStrikethroughOffset();
        return fm.getAscent() - 2.0f * Math.abs(sto) + fm.getStrikethroughThickness();
    }

    public String getBaseURL() {
        return this.uac.getBaseURL();
    }

    public void setBaseURL(@Nullable String url) {
        this.uac.setBaseURL(url);
    }

    public boolean isPaged() {
        return PAGED_MEDIA_TYPES.contains(this.media);
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public boolean isPrint() {
        return this.print;
    }

    public void setPrint(boolean print) {
        this.print = print;
        this.setMedia(print ? "print" : "screen");
    }

    public void setFontMapping(String name, Font font) {
        FontResolver fontResolver = this.fontResolver;
        if (fontResolver instanceof AWTFontResolver) {
            AWTFontResolver awtFontResolver = (AWTFontResolver)fontResolver;
            awtFontResolver.setFontMapping(name, font);
        }
    }

    @Deprecated
    public void setFontResolver(FontResolver resolver) {
        this.fontResolver = Objects.requireNonNull(resolver);
    }

    public int getDotsPerPixel() {
        return this.dotsPerPixel;
    }

    public void setDotsPerPixel(int pixelsPerDot) {
        this.dotsPerPixel = pixelsPerDot;
    }

    public CalculatedStyle getStyle(Element e) {
        return this.getStyle(e, false);
    }

    public CalculatedStyle getStyle(Element e, boolean restyle) {
        Map<Element, CalculatedStyle> localMap = this.styleMap;
        if (localMap == null) {
            localMap = new HashMap<Element, CalculatedStyle>(1024, 0.75f);
        }
        CalculatedStyle result = null;
        if (!restyle) {
            result = localMap.get(e);
        }
        if (result == null) {
            CalculatedStyle parentCalculatedStyle;
            Node parent = e.getParentNode();
            if (parent instanceof Document) {
                parentCalculatedStyle = new EmptyStyle();
            } else if (parent instanceof Element) {
                Element element = (Element)parent;
                parentCalculatedStyle = this.getStyle(element, false);
            } else {
                throw new IllegalStateException("Unexpected parent: " + parent.getClass().getName());
            }
            result = parentCalculatedStyle.deriveStyle(this.getCss().getCascadedStyle(e, restyle));
            localMap.put(e, result);
        }
        this.styleMap = localMap;
        return result;
    }

    public void reset() {
        this.styleMap = null;
        this.idMap.clear();
        this.replacedElementFactory.reset();
    }

    public ReplacedElementFactory getReplacedElementFactory() {
        return this.replacedElementFactory;
    }

    public void setReplacedElementFactory(ReplacedElementFactory ref) {
        if (ref == null) {
            throw new NullPointerException("replacedElementFactory may not be null");
        }
        this.replacedElementFactory.reset();
        this.replacedElementFactory = ref;
    }

    public LineBreakingStrategy getLineBreakingStrategy() {
        return this.lineBreakingStrategy;
    }

    public void setLineBreakingStrategy(LineBreakingStrategy lineBreakingStrategy) {
        this.lineBreakingStrategy = lineBreakingStrategy;
    }
}

