/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.style.derived;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.parser.PropertyValue;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.FSDerivedValue;
import org.xhtmlrenderer.css.style.derived.ColorValue;
import org.xhtmlrenderer.css.style.derived.FunctionValue;
import org.xhtmlrenderer.css.style.derived.LengthValue;
import org.xhtmlrenderer.css.style.derived.ListValue;
import org.xhtmlrenderer.css.style.derived.NumberValue;
import org.xhtmlrenderer.css.style.derived.StringValue;

public class DerivedValueFactory {
    private static final Map<String, FSDerivedValue> CACHED_COLORS = new HashMap<String, FSDerivedValue>();

    @CheckReturnValue
    public static FSDerivedValue newDerivedValue(@Nullable CalculatedStyle style, CSSName cssName, PropertyValue value) {
        if (value.getCssValueType() == 0) {
            return style.getParent().valueByName(cssName);
        }
        return switch (value.getPropertyValueType()) {
            default -> throw new MatchException(null, null);
            case PropertyValue.Type.VALUE_TYPE_LENGTH -> new LengthValue(style, cssName, value);
            case PropertyValue.Type.VALUE_TYPE_IDENT -> DerivedValueFactory.getIdentValue(value);
            case PropertyValue.Type.VALUE_TYPE_STRING -> new StringValue(cssName, value);
            case PropertyValue.Type.VALUE_TYPE_NUMBER -> new NumberValue(cssName, value);
            case PropertyValue.Type.VALUE_TYPE_COLOR -> DerivedValueFactory.getColor(cssName, value, value.getCssText());
            case PropertyValue.Type.VALUE_TYPE_LIST -> new ListValue(cssName, value);
            case PropertyValue.Type.VALUE_TYPE_FUNCTION -> new FunctionValue(cssName, value);
        };
    }

    @CheckReturnValue
    private static IdentValue getIdentValue(PropertyValue value) {
        return Objects.requireNonNullElseGet(value.getIdentValue(), () -> IdentValue.getByIdentString(value.getStringValue()));
    }

    @CheckReturnValue
    private static FSDerivedValue getColor(CSSName cssName, PropertyValue value, String cssText) {
        FSDerivedValue color = CACHED_COLORS.get(cssText);
        if (color == null) {
            color = new ColorValue(cssName, value);
            CACHED_COLORS.put(cssText, color);
        }
        return color;
    }
}

