/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.style;

public class Length {
    public static final int MAX_WIDTH = 0x3FFFFFFF;
    public static final Length ZERO = new Length();
    private final LengthType _type;
    private final long _value;

    private Length() {
        this(0L, LengthType.VARIABLE);
    }

    public Length(long value, LengthType type) {
        this._value = value;
        this._type = type;
    }

    public long value() {
        return this._value;
    }

    public LengthType type() {
        return this._type;
    }

    public boolean isVariable() {
        return this._type == LengthType.VARIABLE;
    }

    public boolean isFixed() {
        return this._type == LengthType.FIXED;
    }

    public boolean isPercent() {
        return this._type == LengthType.PERCENT;
    }

    public long width(int maxWidth) {
        return switch (this._type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> this._value;
            case 2 -> (long)maxWidth * this._value / 100L;
            case 0 -> maxWidth;
        };
    }

    public long minWidth(int maxWidth) {
        return switch (this._type.ordinal()) {
            case 1 -> this._value;
            case 2 -> (long)maxWidth * this._value / 100L;
            default -> 0L;
        };
    }

    public String toString() {
        String type = switch (this._type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> "fixed";
            case 2 -> "percent";
            case 0 -> "variable";
        };
        return "Length (type=%s, value=%d)".formatted(type, this._value);
    }

    public static enum LengthType {
        VARIABLE,
        FIXED,
        PERCENT;

    }
}

