/*
 * {{{ header & license
 * Copyright (c) 2006 Wisconsin Court System
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * }}}
 */
package org.xhtmlrenderer.pdf;

import org.xhtmlrenderer.extend.FSImage;

import com.lowagie.text.Image;

public class ITextFSImage implements FSImage {
    private Image _image;
    
    public ITextFSImage(Image image) {
        _image = image;
    }

    public int getWidth() {
        return (int)_image.plainWidth();
    }

    public int getHeight() {
        return (int)_image.plainHeight();
    }

    public void scale(int width, int height) {
        int targetWidth = width;
        int targetHeight = height;
        
        if (targetWidth == -1) {
            targetWidth = (int)(getWidth() * ((double)targetHeight / getHeight()));
        }
        
        if (targetHeight == -1) {
            targetHeight = (int)(getHeight() * ((double)targetWidth / getWidth()));
        }
        
        _image.scaleAbsolute(targetWidth, targetHeight);
    }
    
    public Image getImage() {
        return _image;
    }
}
