/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.sql.parser;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import wvlet.airframe.sql.model.Attribute;
import wvlet.airframe.sql.model.CTERelationRef;
import wvlet.airframe.sql.model.Expression;
import wvlet.airframe.sql.model.Expression$;
import wvlet.airframe.sql.model.Expression$QName$;
import wvlet.airframe.sql.model.LogicalPlan;
import wvlet.airframe.sql.model.LogicalPlan$CrossJoin$;
import wvlet.airframe.sql.model.LogicalPlan$FullOuterJoin$;
import wvlet.airframe.sql.model.LogicalPlan$ImplicitJoin$;
import wvlet.airframe.sql.model.LogicalPlan$InnerJoin$;
import wvlet.airframe.sql.model.LogicalPlan$LeftOuterJoin$;
import wvlet.airframe.sql.model.LogicalPlan$RightOuterJoin$;
import wvlet.airframe.sql.model.NodeLocation;
import wvlet.airframe.sql.model.ResolvedAttribute;
import wvlet.airframe.sql.model.TableScan;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class SQLGenerator$
implements LogSupport {
    public static final SQLGenerator$ MODULE$ = new SQLGenerator$();
    private static Logger logger;
    private static volatile boolean bitmap$0;

    static {
        LoggingMethods.$init$((LoggingMethods)MODULE$);
        LazyLogger.$init$((LazyLogger)MODULE$);
    }

    private Logger logger$lzycompute() {
        SQLGenerator$ sQLGenerator$ = this;
        synchronized (sQLGenerator$) {
            if (!bitmap$0) {
                logger = LazyLogger.logger$((LazyLogger)this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private String unknown(Object e) {
        if (e != null) {
            BoxedUnit boxedUnit;
            if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("", "SQLGenerator.scala", 28, 11), (Object)new StringBuilder(16).append("Unknown model: ").append(e).append(" ").append(e.getClass().getSimpleName()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return e.toString();
        }
        return "";
    }

    private Builder<String, Seq<String>> seqBuilder() {
        return package$.MODULE$.Seq().newBuilder();
    }

    public String print(LogicalPlan m) {
        LogicalPlan logicalPlan = m;
        if (logicalPlan instanceof LogicalPlan.InsertInto) {
            LogicalPlan.InsertInto insertInto = (LogicalPlan.InsertInto)logicalPlan;
            Expression.QName table = insertInto.table();
            Option<Seq<Expression.Identifier>> aliases = insertInto.columnAliases();
            LogicalPlan.Relation query = insertInto.query();
            Builder<String, Seq<String>> b = this.seqBuilder();
            b.$plus$eq((Object)"INSERT INTO");
            b.$plus$eq((Object)this.printExpression(table));
            aliases.map((Function1 & Serializable)x -> (Builder)b.$plus$eq((Object)new StringBuilder(2).append("(").append(((IterableOnceOps)x.map((Function1 & Serializable)e -> MODULE$.printExpression((Expression)e))).mkString(", ")).append(")").toString()));
            b.$plus$eq((Object)this.printRelation(query));
            return ((IterableOnceOps)b.result()).mkString(" ");
        }
        if (logicalPlan instanceof LogicalPlan.Delete) {
            LogicalPlan.Delete delete = (LogicalPlan.Delete)logicalPlan;
            Expression.QName table = delete.table();
            Option<Expression> condOpt = delete.where();
            Builder<String, Seq<String>> b = this.seqBuilder();
            b.$plus$eq((Object)"DELETE FROM");
            b.$plus$eq((Object)this.printExpression(table));
            condOpt.map((Function1 & Serializable)x -> {
                b.$plus$eq((Object)"WHERE");
                return (Builder)b.$plus$eq((Object)MODULE$.printExpression((Expression)x));
            });
            return ((IterableOnceOps)b.result()).mkString(" ");
        }
        if (logicalPlan instanceof LogicalPlan.DDL) {
            LogicalPlan.DDL dDL = (LogicalPlan.DDL)logicalPlan;
            return this.printDDL(dDL);
        }
        if (logicalPlan instanceof LogicalPlan.Relation) {
            LogicalPlan.Relation relation = (LogicalPlan.Relation)logicalPlan;
            return this.printRelation(relation);
        }
        return this.unknown(logicalPlan);
    }

    private Option<LogicalPlan.Relation> findNonEmpty(LogicalPlan.Relation in) {
        LogicalPlan.Relation relation = in;
        if (relation instanceof LogicalPlan.EmptyRelation) {
            return None$.MODULE$;
        }
        return new Some((Object)relation);
    }

    private Seq<Expression> collectFilterExpression(List<LogicalPlan.Relation> stack) {
        return stack.reverse().collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan.Relation, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof LogicalPlan.Filter) {
                    LogicalPlan.Filter filter = (LogicalPlan.Filter)A1;
                    Expression filterExpr = filter.filterExpr();
                    return (B1)filterExpr;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan.Relation x1) {
                LogicalPlan.Relation relation = x1;
                return relation instanceof LogicalPlan.Filter;
            }
        });
    }

    private String printSetOperation(LogicalPlan.SetOperation s, List<LogicalPlan.Relation> context) {
        String string;
        boolean isDistinct = this.containsDistinctPlan(context);
        LogicalPlan.SetOperation setOperation = s;
        if (setOperation instanceof LogicalPlan.Union) {
            string = isDistinct ? "UNION" : "UNION ALL";
        } else if (setOperation instanceof LogicalPlan.Except) {
            string = isDistinct ? "EXCEPT" : "EXCEPT ALL";
        } else if (setOperation instanceof LogicalPlan.Intersect) {
            string = isDistinct ? "INTERSECT" : "INTERSECT ALL";
        } else {
            throw new MatchError((Object)setOperation);
        }
        String op = string;
        return ((IterableOnceOps)s.children().map((Function1 & Serializable)r -> MODULE$.printRelation((LogicalPlan.Relation)r))).mkString(new StringBuilder(2).append(" ").append(op).append(" ").toString());
    }

    private boolean containsDistinctPlan(List<LogicalPlan.Relation> context) {
        return context.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SQLGenerator$.$anonfun$containsDistinctPlan$1(x0$1)));
    }

    private List<LogicalPlan.Filter> collectChildFilters(LogicalPlan.Relation r) {
        LogicalPlan.Relation relation = r;
        if (relation instanceof LogicalPlan.Filter) {
            LogicalPlan.Filter filter = (LogicalPlan.Filter)relation;
            LogicalPlan.Relation in = filter.child();
            LogicalPlan.Filter filter2 = filter;
            return this.collectChildFilters(in).$colon$colon((Object)filter2);
        }
        return Nil$.MODULE$;
    }

    private String printSelection(LogicalPlan.Selection s, List<LogicalPlan.Relation> context) {
        Builder b;
        block6: {
            BoxedUnit boxedUnit;
            Seq seq;
            List<LogicalPlan.Filter> childFilters = this.collectChildFilters(s.child());
            LogicalPlan.Relation nonFilterChild = childFilters.nonEmpty() ? ((LogicalPlan.Filter)childFilters.last()).child() : s.child();
            b = package$.MODULE$.Seq().newBuilder();
            b.$plus$eq((Object)"SELECT");
            Object object = this.containsDistinctPlan(context) ? b.$plus$eq((Object)"DISTINCT") : BoxedUnit.UNIT;
            b.$plus$eq((Object)((IterableOnceOps)s.selectItems().map((Function1 & Serializable)e -> MODULE$.printSelectItem((Expression)e))).mkString(", "));
            this.findNonEmpty(nonFilterChild).map((Function1 & Serializable)f -> {
                b.$plus$eq((Object)"FROM");
                return (Builder)b.$plus$eq((Object)MODULE$.printRelationWithParenthesesIfNecessary((LogicalPlan.Relation)f));
            });
            LogicalPlan.Selection selection = s;
            if (selection instanceof LogicalPlan.Project) {
                seq = (Seq)this.collectFilterExpression(context).$plus$plus(this.collectFilterExpression(childFilters));
            } else if (selection instanceof LogicalPlan.Aggregate) {
                seq = this.collectFilterExpression(childFilters);
            } else {
                throw new MatchError((Object)selection);
            }
            Seq filterSet = seq;
            if (filterSet.nonEmpty()) {
                b.$plus$eq((Object)"WHERE");
                Expression cond = (Expression)filterSet.reduce((Function2 & Serializable)(f1, f2) -> new Expression.And((Expression)f1, (Expression)f2, (Option<NodeLocation>)None$.MODULE$));
                boxedUnit = b.$plus$eq((Object)this.printExpression(cond));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            LogicalPlan.Selection selection2 = s;
            if (!(selection2 instanceof LogicalPlan.Aggregate)) break block6;
            LogicalPlan.Aggregate aggregate = (LogicalPlan.Aggregate)selection2;
            List<Expression.GroupingKey> groupingKeys = aggregate.groupingKeys();
            Option<Expression> having = aggregate.having();
            Object object2 = groupingKeys.nonEmpty() ? b.$plus$eq((Object)new StringBuilder(9).append("GROUP BY ").append(groupingKeys.map((Function1 & Serializable)e -> MODULE$.printExpression((Expression)e)).mkString(", ")).toString()) : BoxedUnit.UNIT;
            having.map((Function1 & Serializable)h -> {
                b.$plus$eq((Object)"HAVING");
                return (Builder)b.$plus$eq((Object)MODULE$.printExpression((Expression)h));
            });
        }
        return ((IterableOnceOps)b.result()).mkString(" ");
    }

    public String printRelation(LogicalPlan.Relation r) {
        return this.printRelation(r, (List<LogicalPlan.Relation>)package$.MODULE$.List().empty());
    }

    public String printRelation(LogicalPlan.Relation r, List<LogicalPlan.Relation> context) {
        LogicalPlan.Relation relation;
        while (true) {
            if ((relation = r) instanceof LogicalPlan.SetOperation) {
                LogicalPlan.SetOperation setOperation = (LogicalPlan.SetOperation)relation;
                return this.printSetOperation(setOperation, context);
            }
            if (relation instanceof LogicalPlan.Filter) {
                LogicalPlan.Filter filter = (LogicalPlan.Filter)relation;
                LogicalPlan.Relation in = filter.child();
                LogicalPlan.Relation relation2 = r;
                context = context.$colon$colon((Object)relation2);
                r = in;
                continue;
            }
            if (!(relation instanceof LogicalPlan.Distinct)) break;
            LogicalPlan.Distinct distinct = (LogicalPlan.Distinct)relation;
            LogicalPlan.Relation in = distinct.child();
            LogicalPlan.Relation relation3 = r;
            context = context.$colon$colon((Object)relation3);
            r = in;
        }
        if (relation instanceof LogicalPlan.Project) {
            LogicalPlan.Project project = (LogicalPlan.Project)relation;
            return this.printSelection(project, (List<LogicalPlan.Relation>)context);
        }
        if (relation instanceof LogicalPlan.Aggregate) {
            LogicalPlan.Aggregate aggregate = (LogicalPlan.Aggregate)relation;
            return this.printSelection(aggregate, (List<LogicalPlan.Relation>)context);
        }
        if (relation instanceof LogicalPlan.Query) {
            LogicalPlan.Query query = (LogicalPlan.Query)relation;
            LogicalPlan.With withQuery = query.withQuery();
            LogicalPlan.Relation body = query.body();
            Builder<String, Seq<String>> s = this.seqBuilder();
            s.$plus$eq((Object)"WITH");
            Object object = withQuery.recursive() ? s.$plus$eq((Object)"RECURSIVE") : BoxedUnit.UNIT;
            s.$plus$eq((Object)((IterableOnceOps)withQuery.queries().map((Function1 & Serializable)q -> {
                String columnAliases = (String)q.columnNames().map((Function1 & Serializable)x -> new StringBuilder(2).append("(").append(((IterableOnceOps)x.map((Function1 & Serializable)x$1 -> MODULE$.printExpression((Expression)x$1))).mkString(", ")).append(")").toString()).getOrElse((Function0 & Serializable)() -> "");
                return new StringBuilder(6).append(MODULE$.printExpression(q.name())).append(columnAliases).append(" AS (").append(MODULE$.printRelation(q.query())).append(")").toString();
            })).mkString(", "));
            s.$plus$eq((Object)this.printRelation(body));
            return ((IterableOnceOps)s.result()).mkString(" ");
        }
        if (relation instanceof CTERelationRef) {
            CTERelationRef cTERelationRef = (CTERelationRef)relation;
            return cTERelationRef.name();
        }
        if (relation instanceof LogicalPlan.TableRef) {
            LogicalPlan.TableRef tableRef = (LogicalPlan.TableRef)relation;
            Expression.QName t = tableRef.name();
            return this.printNameWithQuotationsIfNeeded(t.fullName());
        }
        if (relation instanceof TableScan) {
            TableScan tableScan = (TableScan)relation;
            return this.printNameWithQuotationsIfNeeded(tableScan.fullName());
        }
        if (relation instanceof LogicalPlan.Limit) {
            LogicalPlan.Limit limit = (LogicalPlan.Limit)relation;
            LogicalPlan.Relation in = limit.child();
            Expression.LongLiteral l = limit.limit();
            Builder<String, Seq<String>> s = this.seqBuilder();
            s.$plus$eq((Object)this.printRelation(in, (List<LogicalPlan.Relation>)context));
            s.$plus$eq((Object)new StringBuilder(6).append("LIMIT ").append(l.sqlExpr()).toString());
            return ((IterableOnceOps)s.result()).mkString(" ");
        }
        if (relation instanceof LogicalPlan.Sort) {
            LogicalPlan.Sort sort = (LogicalPlan.Sort)relation;
            LogicalPlan.Relation in = sort.child();
            Seq<Expression.SortItem> orderBy = sort.orderBy();
            Builder<String, Seq<String>> s = this.seqBuilder();
            s.$plus$eq((Object)this.printRelation(in, (List<LogicalPlan.Relation>)context));
            s.$plus$eq((Object)"ORDER BY");
            s.$plus$eq((Object)((IterableOnceOps)orderBy.map((Function1 & Serializable)x -> MODULE$.printExpression((Expression)x))).mkString(", "));
            return ((IterableOnceOps)s.result()).mkString(" ");
        }
        if (relation instanceof LogicalPlan.ParenthesizedRelation) {
            LogicalPlan.ParenthesizedRelation parenthesizedRelation = (LogicalPlan.ParenthesizedRelation)relation;
            LogicalPlan.Relation r2 = parenthesizedRelation.child();
            return new StringBuilder(2).append("(").append(this.printRelation(r2, (List<LogicalPlan.Relation>)context)).append(")").toString();
        }
        if (relation instanceof LogicalPlan.AliasedRelation) {
            LogicalPlan.AliasedRelation aliasedRelation = (LogicalPlan.AliasedRelation)relation;
            LogicalPlan.Relation relation4 = aliasedRelation.child();
            Expression.Identifier alias = aliasedRelation.alias();
            Option<Seq<String>> columnNames = aliasedRelation.columnNames();
            String r3 = this.printRelation(relation4, (List<LogicalPlan.Relation>)context);
            String c = (String)columnNames.map((Function1 & Serializable)x -> new StringBuilder(2).append("(").append(x.mkString(", ")).append(")").toString()).getOrElse((Function0 & Serializable)() -> "");
            LogicalPlan.Relation relation5 = relation4;
            if (relation5 instanceof LogicalPlan.TableRef) {
                return new StringBuilder(4).append(r3).append(" AS ").append(alias.sqlExpr()).append(c).toString();
            }
            if (relation5 instanceof TableScan) {
                return new StringBuilder(4).append(r3).append(" AS ").append(alias.sqlExpr()).append(c).toString();
            }
            if (relation5 instanceof LogicalPlan.ParenthesizedRelation) {
                return new StringBuilder(4).append(r3).append(" AS ").append(alias.sqlExpr()).append(c).toString();
            }
            if (relation5 instanceof LogicalPlan.Unnest) {
                return new StringBuilder(4).append(r3).append(" AS ").append(alias.sqlExpr()).append(c).toString();
            }
            if (relation5 instanceof LogicalPlan.Lateral) {
                return new StringBuilder(4).append(r3).append(" AS ").append(alias.sqlExpr()).append(c).toString();
            }
            return new StringBuilder(6).append("(").append(r3).append(") AS ").append(alias.sqlExpr()).append(c).toString();
        }
        if (relation instanceof LogicalPlan.Join) {
            String string;
            LogicalPlan.Join join = (LogicalPlan.Join)relation;
            LogicalPlan.JoinType joinType = join.joinType();
            LogicalPlan.Relation left = join.left();
            LogicalPlan.Relation right = join.right();
            Expression.JoinCriteria cond = join.cond();
            String l = this.printRelationWithParenthesesIfNecessary(left);
            String r4 = this.printRelationWithParenthesesIfNecessary(right);
            Expression.JoinCriteria joinCriteria = cond;
            if (joinCriteria instanceof Expression.NaturalJoin) {
                string = "";
            } else if (joinCriteria instanceof Expression.JoinUsing) {
                Expression.JoinUsing joinUsing = (Expression.JoinUsing)joinCriteria;
                Seq<Expression.Identifier> columns = joinUsing.columns();
                string = new StringBuilder(9).append(" USING (").append(((IterableOnceOps)columns.map((Function1 & Serializable)x$2 -> x$2.sqlExpr())).mkString(", ")).append(")").toString();
            } else if (joinCriteria instanceof Expression.ResolvedJoinUsing) {
                Expression.ResolvedJoinUsing resolvedJoinUsing = (Expression.ResolvedJoinUsing)joinCriteria;
                Seq<Expression.MultiSourceColumn> columns = resolvedJoinUsing.keys();
                string = new StringBuilder(9).append(" USING (").append(((IterableOnceOps)columns.map((Function1 & Serializable)x$3 -> x$3.fullName())).mkString(", ")).append(")").toString();
            } else if (joinCriteria instanceof Expression.JoinOn) {
                Expression.JoinOn joinOn = (Expression.JoinOn)joinCriteria;
                Expression expr = joinOn.expr();
                string = new StringBuilder(4).append(" ON ").append(this.printExpression(expr)).toString();
            } else if (joinCriteria instanceof Expression.JoinOnEq) {
                Expression.JoinOnEq joinOnEq = (Expression.JoinOnEq)joinCriteria;
                Seq<Expression> keys = joinOnEq.keys();
                string = new StringBuilder(4).append(" ON ").append(this.printExpression(Expression$.MODULE$.concatWithEq(keys))).toString();
            } else {
                throw new MatchError((Object)joinCriteria);
            }
            String c = string;
            LogicalPlan.JoinType joinType2 = joinType;
            if (LogicalPlan$InnerJoin$.MODULE$.equals(joinType2)) {
                return new StringBuilder(6).append(l).append(" JOIN ").append(r4).append(c).toString();
            }
            if (LogicalPlan$LeftOuterJoin$.MODULE$.equals(joinType2)) {
                return new StringBuilder(11).append(l).append(" LEFT JOIN ").append(r4).append(c).toString();
            }
            if (LogicalPlan$RightOuterJoin$.MODULE$.equals(joinType2)) {
                return new StringBuilder(12).append(l).append(" RIGHT JOIN ").append(r4).append(c).toString();
            }
            if (LogicalPlan$FullOuterJoin$.MODULE$.equals(joinType2)) {
                return new StringBuilder(17).append(l).append(" FULL OUTER JOIN ").append(r4).append(c).toString();
            }
            if (LogicalPlan$CrossJoin$.MODULE$.equals(joinType2)) {
                return new StringBuilder(12).append(l).append(" CROSS JOIN ").append(r4).append(c).toString();
            }
            if (LogicalPlan$ImplicitJoin$.MODULE$.equals(joinType2)) {
                return new StringBuilder(2).append(l).append(", ").append(r4).append(c).toString();
            }
            throw new MatchError((Object)joinType2);
        }
        if (relation instanceof LogicalPlan.Values) {
            LogicalPlan.Values values = (LogicalPlan.Values)relation;
            Seq<Expression> exprs = values.rows();
            return new StringBuilder(9).append("(VALUES ").append(((IterableOnceOps)exprs.map((Function1 & Serializable)e -> MODULE$.printExpression((Expression)e))).mkString(", ")).append(")").toString();
        }
        if (relation instanceof LogicalPlan.Unnest) {
            LogicalPlan.Unnest unnest = (LogicalPlan.Unnest)relation;
            Seq<Expression> cols = unnest.columns();
            boolean ord = unnest.withOrdinality();
            Builder<String, Seq<String>> b = this.seqBuilder();
            b.$plus$eq((Object)new StringBuilder(9).append("UNNEST (").append(((IterableOnceOps)cols.map((Function1 & Serializable)e -> MODULE$.printExpression((Expression)e))).mkString(", ")).append(")").toString());
            Object object = ord ? b.$plus$eq((Object)"WITH ORDINALITY") : BoxedUnit.UNIT;
            return ((IterableOnceOps)b.result()).mkString(" ");
        }
        if (relation instanceof LogicalPlan.Lateral) {
            LogicalPlan.Lateral lateral = (LogicalPlan.Lateral)relation;
            LogicalPlan.Relation q2 = lateral.query();
            Builder<String, Seq<String>> b = this.seqBuilder();
            b.$plus$eq((Object)"LATERAL");
            b.$plus$eq((Object)new StringBuilder(2).append("(").append(this.printRelation(q2)).append(")").toString());
            return ((IterableOnceOps)b.result()).mkString(" ");
        }
        if (relation instanceof LogicalPlan.LateralView) {
            LogicalPlan.LateralView lateralView = (LogicalPlan.LateralView)relation;
            LogicalPlan.Relation in = lateralView.child();
            Seq<Expression> exprs = lateralView.exprs();
            Expression.Identifier tableAlias = lateralView.tableAlias();
            Seq<Expression.Identifier> columnAliases = lateralView.columnAliases();
            Builder<String, Seq<String>> b = this.seqBuilder();
            b.$plus$eq((Object)this.printRelation(in));
            b.$plus$eq((Object)"LATERAL VIEW explode (");
            b.$plus$eq((Object)((IterableOnceOps)exprs.map((Function1 & Serializable)e -> MODULE$.printExpression((Expression)e))).mkString(", "));
            b.$plus$eq((Object)")");
            b.$plus$eq((Object)this.printExpression(tableAlias));
            b.$plus$eq((Object)"AS");
            b.$plus$eq((Object)((IterableOnceOps)columnAliases.map((Function1 & Serializable)e -> MODULE$.printExpression((Expression)e))).mkString(", "));
            return ((IterableOnceOps)b.result()).mkString(" ");
        }
        return this.unknown(relation);
    }

    public List<LogicalPlan.Relation> printRelation$default$2() {
        return package$.MODULE$.List().empty();
    }

    public String printRelationWithParenthesesIfNecessary(LogicalPlan.Relation r) {
        LogicalPlan.Relation relation = r;
        if (relation instanceof LogicalPlan.Selection) {
            return new StringBuilder(2).append("(").append(this.printRelation(r)).append(")").toString();
        }
        if (relation instanceof LogicalPlan.SetOperation) {
            return new StringBuilder(2).append("(").append(this.printRelation(r)).append(")").toString();
        }
        if (relation instanceof LogicalPlan.Limit) {
            return new StringBuilder(2).append("(").append(this.printRelation(r)).append(")").toString();
        }
        if (relation instanceof LogicalPlan.Filter) {
            return new StringBuilder(2).append("(").append(this.printRelation(r)).append(")").toString();
        }
        if (relation instanceof LogicalPlan.Sort) {
            return new StringBuilder(2).append("(").append(this.printRelation(r)).append(")").toString();
        }
        if (relation instanceof LogicalPlan.Distinct) {
            return new StringBuilder(2).append("(").append(this.printRelation(r)).append(")").toString();
        }
        return this.printRelation(r);
    }

    public String printDDL(LogicalPlan.DDL e2) {
        LogicalPlan.DDL dDL = e2;
        if (dDL instanceof LogicalPlan.CreateSchema) {
            LogicalPlan.CreateSchema createSchema = (LogicalPlan.CreateSchema)dDL;
            Expression.QName name = createSchema.schema();
            boolean ifNotExists = createSchema.ifNotExists();
            Option<Seq<Expression.SchemaProperty>> propsOpt = createSchema.properties();
            String e3 = ifNotExists ? "IF NOT EXISTS " : "";
            String w = (String)propsOpt.map((Function1 & Serializable)props -> new StringBuilder(8).append(" WITH (").append(((IterableOnceOps)props.map((Function1 & Serializable)e -> MODULE$.printExpression((Expression)e))).mkString(", ")).append(")").toString()).getOrElse((Function0 & Serializable)() -> "");
            return new StringBuilder(14).append("CREATE SCHEMA ").append(e3).append(name.sqlExpr()).append(w).toString();
        }
        if (dDL instanceof LogicalPlan.DropSchema) {
            LogicalPlan.DropSchema dropSchema = (LogicalPlan.DropSchema)dDL;
            Expression.QName name = dropSchema.schema();
            boolean ifExists = dropSchema.ifExists();
            boolean cascade = dropSchema.cascade();
            Builder s = package$.MODULE$.Seq().newBuilder();
            s.$plus$eq((Object)"DROP SCHEMA");
            Object object = ifExists ? s.$plus$eq((Object)"IF EXISTS") : BoxedUnit.UNIT;
            s.$plus$eq((Object)name.sqlExpr());
            Object object2 = cascade ? s.$plus$eq((Object)"CASCADE") : BoxedUnit.UNIT;
            return ((IterableOnceOps)s.result()).mkString(" ");
        }
        if (dDL instanceof LogicalPlan.RenameSchema) {
            LogicalPlan.RenameSchema renameSchema = (LogicalPlan.RenameSchema)dDL;
            Expression.QName from = renameSchema.schema();
            Expression.Identifier to = renameSchema.renameTo();
            return new StringBuilder(24).append("ALTER SCHEMA ").append(from.sqlExpr()).append(" RENAME TO ").append(to.sqlExpr()).toString();
        }
        if (dDL instanceof LogicalPlan.CreateTable) {
            LogicalPlan.CreateTable createTable = (LogicalPlan.CreateTable)dDL;
            Expression.QName name = createTable.table();
            boolean ifNotExists = createTable.ifNotExists();
            Seq<Expression.TableElement> tableElements = createTable.tableElems();
            String e4 = ifNotExists ? "IF NOT EXISTS " : "";
            String elems = ((IterableOnceOps)tableElements.map((Function1 & Serializable)e -> MODULE$.printExpression((Expression)e))).mkString(", ");
            return new StringBuilder(16).append("CREATE TABLE ").append(e4).append(name).append(" (").append(elems).append(")").toString();
        }
        if (dDL instanceof LogicalPlan.CreateTableAs) {
            LogicalPlan.CreateTableAs createTableAs = (LogicalPlan.CreateTableAs)dDL;
            Expression.QName name = createTableAs.table();
            boolean ifNotExists = createTableAs.ifNotEotExists();
            Option<Seq<Expression.Identifier>> columnAliases = createTableAs.columnAliases();
            LogicalPlan.Relation query = createTableAs.query();
            String e5 = ifNotExists ? "IF NOT EXISTS " : "";
            String aliases = (String)columnAliases.map((Function1 & Serializable)x -> new StringBuilder(2).append("(").append(((IterableOnceOps)x.map((Function1 & Serializable)e -> MODULE$.printExpression((Expression)e))).mkString(", ")).append(")").toString()).getOrElse((Function0 & Serializable)() -> "");
            return new StringBuilder(17).append("CREATE TABLE ").append(e5).append(name.sqlExpr()).append(aliases).append(" AS ").append(this.print(query)).toString();
        }
        if (dDL instanceof LogicalPlan.DropTable) {
            LogicalPlan.DropTable dropTable = (LogicalPlan.DropTable)dDL;
            Expression.QName table = dropTable.table();
            boolean ifExists = dropTable.ifExists();
            Builder b = package$.MODULE$.Seq().newBuilder();
            b.$plus$eq((Object)"DROP TABLE");
            Object object = ifExists ? b.$plus$eq((Object)"IF EXISTS") : BoxedUnit.UNIT;
            b.$plus$eq((Object)this.printExpression(table));
            return ((IterableOnceOps)b.result()).mkString(" ");
        }
        if (dDL instanceof LogicalPlan.RenameTable) {
            LogicalPlan.RenameTable renameTable = (LogicalPlan.RenameTable)dDL;
            Expression.QName from = renameTable.table();
            Expression.QName to = renameTable.renameTo();
            Builder<String, Seq<String>> b = this.seqBuilder();
            b.$plus$eq((Object)"ALTER TABLE");
            b.$plus$eq((Object)this.printExpression(from));
            b.$plus$eq((Object)"RENAME TO");
            b.$plus$eq((Object)this.printExpression(to));
            return ((IterableOnceOps)b.result()).mkString(" ");
        }
        if (dDL instanceof LogicalPlan.RenameColumn) {
            LogicalPlan.RenameColumn renameColumn = (LogicalPlan.RenameColumn)dDL;
            Expression.QName table = renameColumn.table();
            Expression.Identifier from = renameColumn.column();
            Expression.Identifier to = renameColumn.renameTo();
            Builder<String, Seq<String>> b = this.seqBuilder();
            b.$plus$eq((Object)"ALTER TABLE");
            b.$plus$eq((Object)this.printExpression(table));
            b.$plus$eq((Object)"RENAME COLUMN");
            b.$plus$eq((Object)this.printExpression(from));
            b.$plus$eq((Object)"TO");
            b.$plus$eq((Object)this.printExpression(to));
            return ((IterableOnceOps)b.result()).mkString(" ");
        }
        if (dDL instanceof LogicalPlan.DropColumn) {
            LogicalPlan.DropColumn dropColumn = (LogicalPlan.DropColumn)dDL;
            Expression.QName table = dropColumn.table();
            Expression.Identifier col = dropColumn.column();
            Builder<String, Seq<String>> b = this.seqBuilder();
            b.$plus$eq((Object)"ALTER TABLE");
            b.$plus$eq((Object)this.printExpression(table));
            b.$plus$eq((Object)"DROP COLUMN");
            b.$plus$eq((Object)this.printExpression(col));
            return ((IterableOnceOps)b.result()).mkString(" ");
        }
        if (dDL instanceof LogicalPlan.AddColumn) {
            LogicalPlan.AddColumn addColumn = (LogicalPlan.AddColumn)dDL;
            Expression.QName table = addColumn.table();
            Expression.ColumnDef colDef = addColumn.column();
            Builder<String, Seq<String>> b = this.seqBuilder();
            b.$plus$eq((Object)"ALTER TABLE");
            b.$plus$eq((Object)this.printExpression(table));
            b.$plus$eq((Object)"ADD COLUMN");
            b.$plus$eq((Object)this.printExpression(colDef));
            return ((IterableOnceOps)b.result()).mkString(" ");
        }
        if (dDL instanceof LogicalPlan.CreateView) {
            LogicalPlan.CreateView createView = (LogicalPlan.CreateView)dDL;
            Expression.QName name = createView.viewName();
            boolean replace = createView.replace();
            LogicalPlan.Relation query = createView.query();
            Builder<String, Seq<String>> b = this.seqBuilder();
            b.$plus$eq((Object)"CREATE");
            Object object = replace ? b.$plus$eq((Object)"OR REPLACE") : BoxedUnit.UNIT;
            b.$plus$eq((Object)"VIEW");
            b.$plus$eq((Object)this.printExpression(name));
            b.$plus$eq((Object)"AS");
            b.$plus$eq((Object)this.print(query));
            return ((IterableOnceOps)b.result()).mkString(" ");
        }
        if (dDL instanceof LogicalPlan.DropView) {
            LogicalPlan.DropView dropView = (LogicalPlan.DropView)dDL;
            Expression.QName name = dropView.viewName();
            boolean ifExists = dropView.ifExists();
            Builder<String, Seq<String>> b = this.seqBuilder();
            b.$plus$eq((Object)"DROP VIEW");
            Object object = ifExists ? b.$plus$eq((Object)"IF EXISTS") : BoxedUnit.UNIT;
            b.$plus$eq((Object)this.printExpression(name));
            return ((IterableOnceOps)b.result()).mkString(" ");
        }
        throw new MatchError((Object)dDL);
    }

    public String printSelectItem(Expression e) {
        Expression expression = e;
        if (expression instanceof ResolvedAttribute) {
            ResolvedAttribute resolvedAttribute = (ResolvedAttribute)expression;
            return resolvedAttribute.sqlExpr();
        }
        return this.printExpression(expression);
    }

    public String printExpression(Expression e2) {
        Expression expression;
        while (true) {
            Expression ex;
            if ((expression = e2) instanceof Expression.Identifier) {
                Expression.Identifier identifier = (Expression.Identifier)expression;
                return identifier.sqlExpr();
            }
            if (expression instanceof Expression.Literal) {
                Expression.Literal literal = (Expression.Literal)expression;
                return literal.sqlExpr();
            }
            if (expression instanceof Expression.GroupingKey) {
                Expression.GroupingKey groupingKey = (Expression.GroupingKey)expression;
                return groupingKey.sqlExpr();
            }
            if (expression instanceof Expression.ParenthesizedExpression) {
                Expression.ParenthesizedExpression parenthesizedExpression = (Expression.ParenthesizedExpression)expression;
                Expression expr = parenthesizedExpression.child();
                return new StringBuilder(2).append("(").append(this.printExpression(expr)).append(")").toString();
            }
            if (expression instanceof Expression.Alias) {
                Expression.Alias alias = (Expression.Alias)expression;
                String e3 = this.printExpression(alias.expr());
                return new StringBuilder(4).append(e3).append(" AS ").append(this.printNameWithQuotationsIfNeeded(alias.name())).toString();
            }
            if (!(expression instanceof Expression.SingleColumn)) break;
            Expression.SingleColumn singleColumn = (Expression.SingleColumn)expression;
            e2 = ex = singleColumn.expr();
        }
        if (expression instanceof Expression.MultiSourceColumn) {
            Expression.MultiSourceColumn multiSourceColumn = (Expression.MultiSourceColumn)expression;
            return multiSourceColumn.sqlExpr();
        }
        if (expression instanceof Expression.AllColumns) {
            Expression.AllColumns allColumns = (Expression.AllColumns)expression;
            return allColumns.fullName();
        }
        if (expression instanceof Attribute) {
            Attribute attribute = (Attribute)expression;
            return this.printNameWithQuotationsIfNeeded(attribute.fullName());
        }
        if (expression instanceof Expression.SortItem) {
            Expression.SortItem sortItem = (Expression.SortItem)expression;
            Expression key = sortItem.sortKey();
            Option<Expression.SortOrdering> ordering = sortItem.ordering();
            Option<Expression.NullOrdering> nullOrdering = sortItem.nullOrdering();
            String k = this.printExpression(key);
            String o = (String)ordering.map((Function1 & Serializable)x -> new StringBuilder(1).append(" ").append(x).toString()).getOrElse((Function0 & Serializable)() -> "");
            String no = (String)nullOrdering.map((Function1 & Serializable)x -> new StringBuilder(1).append(" ").append(x).toString()).getOrElse((Function0 & Serializable)() -> "");
            return new StringBuilder(0).append(k).append(o).append(no).toString();
        }
        if (expression instanceof Expression.FunctionCall) {
            Expression.FunctionCall functionCall = (Expression.FunctionCall)expression;
            String name = functionCall.name();
            Seq<Expression> args = functionCall.args();
            boolean distinct = functionCall.isDistinct();
            Option<Expression> filter = functionCall.filter();
            Option<Expression.Window> window = functionCall.window();
            String argList = ((IterableOnceOps)args.map((Function1 & Serializable)x$4 -> MODULE$.printExpression((Expression)x$4))).mkString(", ");
            String d = distinct ? "DISTINCT " : "";
            String wd = (String)window.map((Function1 & Serializable)w -> {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                Builder s = package$.MODULE$.Seq().newBuilder();
                if (w.partitionBy().nonEmpty()) {
                    s.$plus$eq((Object)"PARTITION BY");
                    boxedUnit2 = s.$plus$eq((Object)((IterableOnceOps)w.partitionBy().map((Function1 & Serializable)x -> MODULE$.printExpression((Expression)x))).mkString(", "));
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (w.orderBy().nonEmpty()) {
                    s.$plus$eq((Object)"ORDER BY");
                    boxedUnit = s.$plus$eq((Object)((IterableOnceOps)w.orderBy().map((Function1 & Serializable)x -> MODULE$.printExpression((Expression)x))).mkString(", "));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                w.frame().map((Function1 & Serializable)x -> (Builder)s.$plus$eq((Object)x.toString()));
                return new StringBuilder(8).append(" OVER (").append(((IterableOnceOps)s.result()).mkString(" ")).append(")").toString();
            }).getOrElse((Function0 & Serializable)() -> "");
            String f = (String)filter.map((Function1 & Serializable)x -> new StringBuilder(16).append(" FILTER (WHERE ").append(MODULE$.printExpression((Expression)x)).append(")").toString()).getOrElse((Function0 & Serializable)() -> "");
            return new StringBuilder(2).append(name).append("(").append(d).append(argList).append(")").append(f).append(wd).toString();
        }
        if (expression instanceof Expression.Extract) {
            Expression.Extract extract = (Expression.Extract)expression;
            Expression.IntervalField interval = extract.interval();
            Expression expr = extract.expr();
            return new StringBuilder(15).append("EXTRACT(").append(interval).append(" FROM ").append(this.printExpression(expr)).append(")").toString();
        }
        if (expression instanceof Expression.QName) {
            Expression.QName qName = (Expression.QName)expression;
            List<String> parts = qName.parts();
            return parts.mkString(".");
        }
        if (expression instanceof Expression.Cast) {
            Expression.Cast cast = (Expression.Cast)expression;
            Expression expr = cast.expr();
            String tpe = cast.tpe();
            boolean tryCast = cast.tryCast();
            String cmd = tryCast ? "TRY_CAST" : "CAST";
            return new StringBuilder(6).append(cmd).append("(").append(this.printExpression(expr)).append(" AS ").append(tpe).append(")").toString();
        }
        if (expression instanceof Expression.ConditionalExpression) {
            Expression.ConditionalExpression conditionalExpression = (Expression.ConditionalExpression)expression;
            return this.printConditionalExpression(conditionalExpression);
        }
        if (expression instanceof Expression.ArithmeticBinaryExpr) {
            Expression.ArithmeticBinaryExpr arithmeticBinaryExpr = (Expression.ArithmeticBinaryExpr)expression;
            Expression.BinaryExprType tpe = arithmeticBinaryExpr.exprType();
            Expression left = arithmeticBinaryExpr.left();
            Expression right = arithmeticBinaryExpr.right();
            return new StringBuilder(2).append(this.printExpression(left)).append(" ").append(tpe.symbol()).append(" ").append(this.printExpression(right)).toString();
        }
        if (expression instanceof Expression.ArithmeticUnaryExpr) {
            Expression.ArithmeticUnaryExpr arithmeticUnaryExpr = (Expression.ArithmeticUnaryExpr)expression;
            Expression.Sign sign = arithmeticUnaryExpr.sign();
            Expression value = arithmeticUnaryExpr.child();
            return new StringBuilder(1).append(sign.symbol()).append(" ").append(this.printExpression(value)).toString();
        }
        if (expression instanceof Expression.Exists) {
            Expression.Exists exists = (Expression.Exists)expression;
            Expression subQuery = exists.child();
            return new StringBuilder(8).append("EXISTS(").append(this.printExpression(subQuery)).append(")").toString();
        }
        if (expression instanceof Expression.SubQueryExpression) {
            Expression.SubQueryExpression subQueryExpression = (Expression.SubQueryExpression)expression;
            LogicalPlan.Relation query = subQueryExpression.query();
            return new StringBuilder(2).append("(").append(this.printRelation(query)).append(")").toString();
        }
        if (expression instanceof Expression.CaseExpr) {
            Expression.CaseExpr caseExpr = (Expression.CaseExpr)expression;
            Option<Expression> operand = caseExpr.operand();
            Seq<Expression.WhenClause> whenClauses = caseExpr.whenClauses();
            Option<Expression> defaultValue = caseExpr.defaultValue();
            Builder s = package$.MODULE$.Seq().newBuilder();
            s.$plus$eq((Object)"CASE");
            operand.map((Function1 & Serializable)x -> (Builder)s.$plus$eq((Object)MODULE$.printExpression((Expression)x)));
            whenClauses.map((Function1 & Serializable)w -> {
                s.$plus$eq((Object)"WHEN");
                s.$plus$eq((Object)MODULE$.printExpression(w.condition()));
                s.$plus$eq((Object)"THEN");
                return (Builder)s.$plus$eq((Object)MODULE$.printExpression(w.result()));
            });
            defaultValue.map((Function1 & Serializable)x -> {
                s.$plus$eq((Object)"ELSE");
                return (Builder)s.$plus$eq((Object)MODULE$.printExpression((Expression)x));
            });
            s.$plus$eq((Object)"END");
            return ((IterableOnceOps)s.result()).mkString(" ");
        }
        if (expression instanceof Expression.WindowFrame) {
            Expression.WindowFrame windowFrame = (Expression.WindowFrame)expression;
            return windowFrame.toString();
        }
        if (expression instanceof Expression.SchemaProperty) {
            Expression.SchemaProperty schemaProperty = (Expression.SchemaProperty)expression;
            Expression.Identifier k = schemaProperty.key();
            Expression v = schemaProperty.value();
            return new StringBuilder(3).append(k.sqlExpr()).append(" = ").append(v.sqlExpr()).toString();
        }
        if (expression instanceof Expression.ColumnDef) {
            Expression.ColumnDef columnDef = (Expression.ColumnDef)expression;
            Expression.Identifier name = columnDef.columnName();
            Expression.ColumnType tpe = columnDef.tpe();
            return new StringBuilder(1).append(this.printExpression(name)).append(" ").append(this.printExpression(tpe)).toString();
        }
        if (expression instanceof Expression.ColumnType) {
            Expression.ColumnType columnType = (Expression.ColumnType)expression;
            String tpe = columnType.tpe();
            return tpe;
        }
        if (expression instanceof Expression.ColumnDefLike) {
            Expression.ColumnDefLike columnDefLike = (Expression.ColumnDefLike)expression;
            Expression.QName table = columnDefLike.tableName();
            boolean includeProperties = columnDefLike.includeProperties();
            String inc = includeProperties ? "INCLUDING" : "EXCLUDING";
            return new StringBuilder(17).append("LIKE ").append(this.printExpression(table)).append(" ").append(inc).append(" PROPERTIES").toString();
        }
        if (expression instanceof Expression.ArrayConstructor) {
            Expression.ArrayConstructor arrayConstructor = (Expression.ArrayConstructor)expression;
            Seq<Expression> values = arrayConstructor.values();
            return new StringBuilder(7).append("ARRAY[").append(((IterableOnceOps)values.map((Function1 & Serializable)e -> MODULE$.printExpression((Expression)e))).mkString(", ")).append("]").toString();
        }
        if (expression instanceof Expression.RowConstructor) {
            Expression.RowConstructor rowConstructor = (Expression.RowConstructor)expression;
            Seq<Expression> values = rowConstructor.values();
            return new StringBuilder(2).append("(").append(((IterableOnceOps)values.map((Function1 & Serializable)e -> MODULE$.printExpression((Expression)e))).mkString(", ")).append(")").toString();
        }
        if (expression instanceof Expression.Parameter) {
            return "?";
        }
        return this.unknown(expression);
    }

    public String printConditionalExpression(Expression.ConditionalExpression c) {
        Expression.ConditionalExpression conditionalExpression = c;
        if (conditionalExpression instanceof Expression.NoOp) {
            return "";
        }
        if (conditionalExpression instanceof Expression.Eq) {
            Expression.Eq eq2 = (Expression.Eq)conditionalExpression;
            Expression a = eq2.left();
            Expression b = eq2.right();
            return new StringBuilder(3).append(this.printExpression(a)).append(" = ").append(this.printExpression(b)).toString();
        }
        if (conditionalExpression instanceof Expression.NotEq) {
            Expression.NotEq notEq = (Expression.NotEq)conditionalExpression;
            Expression a = notEq.left();
            Expression b = notEq.right();
            String operatorName = notEq.operatorName();
            return new StringBuilder(2).append(this.printExpression(a)).append(" ").append(operatorName).append(" ").append(this.printExpression(b)).toString();
        }
        if (conditionalExpression instanceof Expression.And) {
            Expression.And and = (Expression.And)conditionalExpression;
            Expression a = and.left();
            Expression b = and.right();
            return new StringBuilder(5).append(this.printExpression(a)).append(" AND ").append(this.printExpression(b)).toString();
        }
        if (conditionalExpression instanceof Expression.Or) {
            Expression.Or or = (Expression.Or)conditionalExpression;
            Expression a = or.left();
            Expression b = or.right();
            return new StringBuilder(4).append(this.printExpression(a)).append(" OR ").append(this.printExpression(b)).toString();
        }
        if (conditionalExpression instanceof Expression.Not) {
            Expression.Not not = (Expression.Not)conditionalExpression;
            Expression e = not.child();
            return new StringBuilder(4).append("NOT ").append(this.printExpression(e)).toString();
        }
        if (conditionalExpression instanceof Expression.LessThan) {
            Expression.LessThan lessThan = (Expression.LessThan)conditionalExpression;
            Expression a = lessThan.left();
            Expression b = lessThan.right();
            return new StringBuilder(3).append(this.printExpression(a)).append(" < ").append(this.printExpression(b)).toString();
        }
        if (conditionalExpression instanceof Expression.LessThanOrEq) {
            Expression.LessThanOrEq lessThanOrEq = (Expression.LessThanOrEq)conditionalExpression;
            Expression a = lessThanOrEq.left();
            Expression b = lessThanOrEq.right();
            return new StringBuilder(4).append(this.printExpression(a)).append(" <= ").append(this.printExpression(b)).toString();
        }
        if (conditionalExpression instanceof Expression.GreaterThan) {
            Expression.GreaterThan greaterThan = (Expression.GreaterThan)conditionalExpression;
            Expression a = greaterThan.left();
            Expression b = greaterThan.right();
            return new StringBuilder(3).append(this.printExpression(a)).append(" > ").append(this.printExpression(b)).toString();
        }
        if (conditionalExpression instanceof Expression.GreaterThanOrEq) {
            Expression.GreaterThanOrEq greaterThanOrEq = (Expression.GreaterThanOrEq)conditionalExpression;
            Expression a = greaterThanOrEq.left();
            Expression b = greaterThanOrEq.right();
            return new StringBuilder(4).append(this.printExpression(a)).append(" >= ").append(this.printExpression(b)).toString();
        }
        if (conditionalExpression instanceof Expression.Between) {
            Expression.Between between = (Expression.Between)conditionalExpression;
            Expression e = between.e();
            Expression a = between.a();
            Expression b = between.b();
            return new StringBuilder(14).append(this.printExpression(e)).append(" BETWEEN ").append(this.printExpression(a)).append(" and ").append(this.printExpression(b)).toString();
        }
        if (conditionalExpression instanceof Expression.NotBetween) {
            Expression.NotBetween notBetween = (Expression.NotBetween)conditionalExpression;
            Expression e = notBetween.e();
            Expression a = notBetween.a();
            Expression b = notBetween.b();
            return new StringBuilder(18).append(this.printExpression(e)).append(" NOT BETWEEN ").append(this.printExpression(a)).append(" and ").append(this.printExpression(b)).toString();
        }
        if (conditionalExpression instanceof Expression.IsNull) {
            Expression.IsNull isNull = (Expression.IsNull)conditionalExpression;
            Expression a = isNull.child();
            return new StringBuilder(8).append(this.printExpression(a)).append(" IS NULL").toString();
        }
        if (conditionalExpression instanceof Expression.IsNotNull) {
            Expression.IsNotNull isNotNull = (Expression.IsNotNull)conditionalExpression;
            Expression a = isNotNull.child();
            return new StringBuilder(12).append(this.printExpression(a)).append(" IS NOT NULL").toString();
        }
        if (conditionalExpression instanceof Expression.In) {
            Expression.In in = (Expression.In)conditionalExpression;
            Expression a = in.a();
            Seq<Expression> list = in.list();
            String in2 = ((IterableOnceOps)list.map((Function1 & Serializable)x -> MODULE$.printExpression((Expression)x))).mkString(", ");
            return new StringBuilder(6).append(this.printExpression(a)).append(" IN (").append(in2).append(")").toString();
        }
        if (conditionalExpression instanceof Expression.NotIn) {
            Expression.NotIn notIn = (Expression.NotIn)conditionalExpression;
            Expression a = notIn.a();
            Seq<Expression> list = notIn.list();
            String in = ((IterableOnceOps)list.map((Function1 & Serializable)x -> MODULE$.printExpression((Expression)x))).mkString(", ");
            return new StringBuilder(10).append(this.printExpression(a)).append(" NOT IN (").append(in).append(")").toString();
        }
        if (conditionalExpression instanceof Expression.InSubQuery) {
            Expression.InSubQuery inSubQuery = (Expression.InSubQuery)conditionalExpression;
            Expression a = inSubQuery.a();
            LogicalPlan.Relation in = inSubQuery.in();
            return new StringBuilder(6).append(this.printExpression(a)).append(" IN (").append(this.printRelation(in)).append(")").toString();
        }
        if (conditionalExpression instanceof Expression.NotInSubQuery) {
            Expression.NotInSubQuery notInSubQuery = (Expression.NotInSubQuery)conditionalExpression;
            Expression a = notInSubQuery.a();
            LogicalPlan.Relation in = notInSubQuery.in();
            return new StringBuilder(10).append(this.printExpression(a)).append(" NOT IN (").append(this.printRelation(in)).append(")").toString();
        }
        if (conditionalExpression instanceof Expression.Like) {
            Expression.Like like = (Expression.Like)conditionalExpression;
            Expression a = like.left();
            Expression e = like.right();
            return new StringBuilder(6).append(this.printExpression(a)).append(" LIKE ").append(this.printExpression(e)).toString();
        }
        if (conditionalExpression instanceof Expression.NotLike) {
            Expression.NotLike notLike = (Expression.NotLike)conditionalExpression;
            Expression a = notLike.left();
            Expression e = notLike.right();
            return new StringBuilder(10).append(this.printExpression(a)).append(" NOT LIKE ").append(this.printExpression(e)).toString();
        }
        if (conditionalExpression instanceof Expression.DistinctFrom) {
            Expression.DistinctFrom distinctFrom = (Expression.DistinctFrom)conditionalExpression;
            Expression a = distinctFrom.left();
            Expression e = distinctFrom.right();
            return new StringBuilder(18).append(this.printExpression(a)).append(" IS DISTINCT FROM ").append(this.printExpression(e)).toString();
        }
        if (conditionalExpression instanceof Expression.NotDistinctFrom) {
            Expression.NotDistinctFrom notDistinctFrom = (Expression.NotDistinctFrom)conditionalExpression;
            Expression a = notDistinctFrom.left();
            Expression e = notDistinctFrom.right();
            return new StringBuilder(22).append(this.printExpression(a)).append(" IS NOT DISTINCT FROM ").append(this.printExpression(e)).toString();
        }
        return this.unknown(conditionalExpression);
    }

    private String printNameWithQuotationsIfNeeded(String name) {
        return Expression$QName$.MODULE$.apply(name, (Option<NodeLocation>)None$.MODULE$).sqlExpr();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SQLGenerator$.class);
    }

    public static final /* synthetic */ boolean $anonfun$containsDistinctPlan$1(LogicalPlan.Relation x0$1) {
        LogicalPlan.Relation relation = x0$1;
        return relation instanceof LogicalPlan.Distinct;
    }

    private SQLGenerator$() {
    }
}

