/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.sql.model;

import java.io.Serializable;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import wvlet.airframe.sql.model.Expression;
import wvlet.airframe.sql.model.NodeLocation;

public final class Expression$ {
    public static final Expression$ MODULE$ = new Expression$();

    public Expression concat(Seq<Expression> expr, Function2<Expression, Expression, Expression> merger) {
        Predef$.MODULE$.require(expr.length() > 0);
        if (expr.length() == 1) {
            return (Expression)expr.head();
        }
        return (Expression)((IterableOnceOps)expr.tail()).foldLeft(expr.head(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Expression prev = (Expression)tuple2._1();
                Expression next = (Expression)tuple2._2();
                return (Expression)merger.apply((Object)prev, (Object)next);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Expression concatWithAnd(Seq<Expression> expr) {
        return this.concat(expr, (Function2<Expression, Expression, Expression>)(Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Expression a = (Expression)tuple2._1();
                Expression b = (Expression)tuple2._2();
                return new Expression.And(a, b, (Option<NodeLocation>)None$.MODULE$);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Expression concatWithEq(Seq<Expression> expr) {
        return this.concat(expr, (Function2<Expression, Expression, Expression>)(Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Expression a = (Expression)tuple2._1();
                Expression b = (Expression)tuple2._2();
                return new Expression.Eq(a, b, (Option<NodeLocation>)None$.MODULE$);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Expression.Identifier newIdentifier(String x) {
        if (x.startsWith("`") && x.endsWith("`")) {
            return new Expression.BackQuotedIdentifier(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(x), "`")), "`"), (Option<NodeLocation>)None$.MODULE$);
        }
        if (x.startsWith("\"") && x.endsWith("\"")) {
            return new Expression.QuotedIdentifier(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(x), "\"")), "\""), (Option<NodeLocation>)None$.MODULE$);
        }
        if (x.matches("[0-9]+")) {
            return new Expression.DigitId(x, (Option<NodeLocation>)None$.MODULE$);
        }
        return new Expression.UnquotedIdentifier(x, (Option<NodeLocation>)None$.MODULE$);
    }

    private Expression$() {
    }
}

