/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.security.basic;

import java.nio.charset.Charset;
import java.util.Base64;
import javax.ws.rs.core.Response;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.interceptor.RequestInterceptor;

public abstract class AbstractBasicAuthSecurityInterceptor
implements RequestInterceptor {
    private static final String AUTH_TYPE_BASIC = "Basic";
    public static final String CHARSET_UTF_8 = "UTF-8";
    private static final int AUTH_TYPE_BASIC_LENGTH = "Basic".length();

    @Override
    public boolean interceptRequest(Request request, Response response) throws Exception {
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null) {
            String authType = authHeader.substring(0, AUTH_TYPE_BASIC_LENGTH);
            String authEncoded = authHeader.substring(AUTH_TYPE_BASIC_LENGTH).trim();
            if (AUTH_TYPE_BASIC.equals(authType) && !authEncoded.isEmpty()) {
                String password;
                byte[] decodedByte = authEncoded.getBytes(Charset.forName(CHARSET_UTF_8));
                String authDecoded = new String(Base64.getDecoder().decode(decodedByte), Charset.forName(CHARSET_UTF_8));
                String[] authParts = authDecoded.split(":");
                String username = authParts[0];
                if (this.authenticate(username, password = authParts[1])) {
                    return true;
                }
            }
        }
        response.setStatus(Response.Status.UNAUTHORIZED.getStatusCode());
        response.setHeader("WWW-Authenticate", AUTH_TYPE_BASIC);
        return false;
    }

    protected abstract boolean authenticate(String var1, String var2);
}

