/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender.channel;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import java.net.ConnectException;
import org.wso2.transport.http.netty.common.Constants;
import org.wso2.transport.http.netty.common.HttpRoute;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.sender.channel.TargetChannel;

public class TargetChannelListener
implements ChannelFutureListener {
    private TargetChannel targetChannel;
    private HTTPCarbonMessage httpCarbonRequest;
    private HttpRoute httpRoute;
    private int socketIdleTimeout;
    private HttpResponseFuture httpResponseFuture;

    public TargetChannelListener(TargetChannel targetChannel, HTTPCarbonMessage httpCarbonRequest, int socketIdleTimeout, HttpResponseFuture httpResponseFuture) {
        this.targetChannel = targetChannel;
        this.httpCarbonRequest = httpCarbonRequest;
        this.httpRoute = targetChannel.getHttpRoute();
        this.socketIdleTimeout = socketIdleTimeout;
        this.httpResponseFuture = httpResponseFuture;
    }

    public void operationComplete(ChannelFuture channelFuture) throws Exception {
        if (this.isValidateChannel(channelFuture)) {
            this.targetChannel.setChannel(channelFuture.channel());
            channelFuture.channel().attr(Constants.ORIGINAL_REQUEST).set((Object)this.httpCarbonRequest);
            channelFuture.channel().attr(Constants.RESPONSE_FUTURE_OF_ORIGINAL_CHANNEL).set((Object)this.httpResponseFuture);
            this.targetChannel.configTargetHandler(this.httpCarbonRequest, this.httpResponseFuture);
            this.targetChannel.setEndPointTimeout(this.socketIdleTimeout, false);
            this.targetChannel.setCorrelationIdForLogging();
            this.targetChannel.setRequestWritten(true);
            this.targetChannel.writeContent(this.httpCarbonRequest);
        } else {
            this.notifyErrorState(channelFuture);
        }
    }

    private boolean isValidateChannel(ChannelFuture channelFuture) throws Exception {
        return channelFuture.isDone() && channelFuture.isSuccess();
    }

    private void notifyErrorState(ChannelFuture channelFuture) {
        if (channelFuture.isDone() && channelFuture.isCancelled()) {
            ConnectException cause = new ConnectException("Request Cancelled, " + this.httpRoute.toString());
            if (channelFuture.cause() != null) {
                cause.initCause(channelFuture.cause());
            }
            this.targetChannel.getTargetHandler().getHttpResponseFuture().notifyHttpListener(cause);
        } else if (!(channelFuture.isDone() || channelFuture.isSuccess() || channelFuture.isCancelled() || channelFuture.cause() != null)) {
            ConnectException cause = new ConnectException("Connection timeout, " + this.httpRoute.toString());
            this.targetChannel.getTargetHandler().getHttpResponseFuture().notifyHttpListener(cause);
        } else {
            ConnectException cause = new ConnectException("Connection refused, " + this.httpRoute.toString());
            if (channelFuture.cause() != null) {
                cause.initCause(channelFuture.cause());
            }
            this.targetChannel.getTargetHandler().getHttpResponseFuture().notifyHttpListener(cause);
        }
    }
}

