/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.exceptions.MessagingException;
import org.wso2.transport.http.netty.common.HttpRoute;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.transport.http.netty.internal.HandlerExecutor;
import org.wso2.transport.http.netty.listener.HTTPTraceLoggingHandler;
import org.wso2.transport.http.netty.listener.SourceHandler;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.sender.HTTPClientInitializer;
import org.wso2.transport.http.netty.sender.TargetHandler;
import org.wso2.transport.http.netty.sender.channel.pool.ConnectionManager;

public class TargetChannel {
    private static final Logger log = LoggerFactory.getLogger(TargetChannel.class);
    private Channel channel;
    private TargetHandler targetHandler;
    private HTTPClientInitializer httpClientInitializer;
    private HttpRoute httpRoute;
    private SourceHandler correlatedSource;
    private ChannelFuture channelFuture;
    private ConnectionManager connectionManager;
    private boolean isRequestWritten = false;
    private boolean chunkDisabled = false;
    private HandlerExecutor handlerExecutor;

    public TargetChannel(HTTPClientInitializer httpClientInitializer, ChannelFuture channelFuture) {
        this.httpClientInitializer = httpClientInitializer;
        this.channelFuture = channelFuture;
        this.handlerExecutor = HTTPTransportContextHolder.getInstance().getHandlerExecutor();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public TargetChannel setChannel(Channel channel) {
        this.channel = channel;
        return this;
    }

    public TargetHandler getTargetHandler() {
        return this.targetHandler;
    }

    public void setTargetHandler(TargetHandler targetHandler) {
        this.targetHandler = targetHandler;
    }

    public HTTPClientInitializer getHTTPClientInitializer() {
        return this.httpClientInitializer;
    }

    public HttpRoute getHttpRoute() {
        return this.httpRoute;
    }

    public void setHttpRoute(HttpRoute httpRoute) {
        this.httpRoute = httpRoute;
    }

    public SourceHandler getCorrelatedSource() {
        return this.correlatedSource;
    }

    public void setCorrelatedSource(SourceHandler correlatedSource) {
        this.correlatedSource = correlatedSource;
    }

    public boolean isRequestWritten() {
        return this.isRequestWritten;
    }

    public void setRequestWritten(boolean isRequestWritten) {
        this.isRequestWritten = isRequestWritten;
    }

    public void setChunkDisabled(boolean chunkDisabled) {
        this.chunkDisabled = chunkDisabled;
    }

    public void configTargetHandler(HTTPCarbonMessage httpCarbonMessage, HttpResponseFuture httpResponseFuture) {
        this.setTargetHandler(this.getHTTPClientInitializer().getTargetHandler());
        TargetHandler targetHandler = this.getTargetHandler();
        targetHandler.setHttpResponseFuture(httpResponseFuture);
        targetHandler.setIncomingMsg(httpCarbonMessage);
        this.getTargetHandler().setConnectionManager(this.connectionManager);
        targetHandler.setTargetChannel(this);
    }

    public void setEndPointTimeout(int socketIdleTimeout, boolean followRedirect) {
        this.getChannel().pipeline().addBefore(followRedirect ? "redirectHandler" : "targetHandler", "idleStateHandler", (ChannelHandler)new IdleStateHandler((long)socketIdleTimeout, (long)socketIdleTimeout, 0L, TimeUnit.MILLISECONDS));
    }

    public void setCorrelationIdForLogging() {
        ChannelPipeline pipeline = this.getChannel().pipeline();
        SourceHandler srcHandler = this.getCorrelatedSource();
        if (srcHandler != null && pipeline.get("http-trace-logger") != null) {
            HTTPTraceLoggingHandler loggingHandler = (HTTPTraceLoggingHandler)pipeline.get("http-trace-logger");
            loggingHandler.setCorrelatedSourceId(srcHandler.getInboundChannelContext().channel().id().asShortText());
        }
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public ChannelFuture getChannelFuture() {
        return this.channelFuture;
    }

    public void writeContent(HTTPCarbonMessage httpOutboundRequest) {
        try {
            if (this.handlerExecutor != null) {
                this.handlerExecutor.executeAtTargetRequestReceiving(httpOutboundRequest);
            }
            httpOutboundRequest.getHttpContentAsync().setMessageListener(httpContent -> this.channel.eventLoop().execute(() -> {
                if (Util.isLastHttpContent(httpContent)) {
                    if (!this.isRequestWritten) {
                        if (Util.isEntityBodyAllowed(httpOutboundRequest.getProperty("HTTP_METHOD").toString())) {
                            Util.setupTransferEncodingForEmptyRequest(httpOutboundRequest, this.chunkDisabled);
                        }
                        this.writeOutboundRequestHeaders(httpOutboundRequest);
                    }
                    this.getChannel().writeAndFlush((Object)httpContent);
                    httpOutboundRequest.removeHttpContentAsyncFuture();
                    if (this.handlerExecutor != null) {
                        this.handlerExecutor.executeAtTargetRequestSending(httpOutboundRequest);
                    }
                } else {
                    if (!this.isRequestWritten) {
                        Util.setupTransferEncodingForRequest(httpOutboundRequest, this.chunkDisabled);
                        this.writeOutboundRequestHeaders(httpOutboundRequest);
                    }
                    this.getChannel().writeAndFlush((Object)httpContent);
                }
            }));
        }
        catch (Exception e) {
            String msg = e instanceof NullPointerException ? "Failed to send the request" : "Failed to send the request : " + e.getMessage().toLowerCase(Locale.ENGLISH);
            log.error(msg, (Throwable)e);
            MessagingException messagingException = new MessagingException(msg, (Throwable)e, 101500);
            httpOutboundRequest.setMessagingException(messagingException);
            this.targetHandler.getHttpResponseFuture().notifyHttpListener(httpOutboundRequest);
        }
    }

    public void writeOutboundRequestHeaders(HTTPCarbonMessage httpOutboundRequest) {
        HttpRequest httpRequest = Util.createHttpRequest(httpOutboundRequest);
        this.setRequestWritten(true);
        this.getChannel().write((Object)httpRequest);
    }
}

