/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.contract.ClientConnectorException;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.transport.http.netty.internal.HandlerExecutor;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.message.HttpCarbonResponse;
import org.wso2.transport.http.netty.sender.channel.TargetChannel;
import org.wso2.transport.http.netty.sender.channel.pool.ConnectionManager;

public class TargetHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(TargetHandler.class);
    private HttpResponseFuture httpResponseFuture;
    private HTTPCarbonMessage targetRespMsg;
    private ConnectionManager connectionManager;
    private TargetChannel targetChannel;
    private HTTPCarbonMessage incomingMsg;
    private HandlerExecutor handlerExecutor;
    private boolean isKeepAlive;

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.handlerExecutor = HTTPTransportContextHolder.getInstance().getHandlerExecutor();
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtTargetConnectionInitiation(Integer.toString(ctx.hashCode()));
        }
        super.channelActive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.targetChannel.isRequestWritten()) {
            if (msg instanceof HttpResponse) {
                this.targetRespMsg = this.setUpCarbonMessage(ctx, msg);
                if (this.handlerExecutor != null) {
                    this.handlerExecutor.executeAtTargetResponseReceiving(this.targetRespMsg);
                }
                if (this.httpResponseFuture != null) {
                    try {
                        this.httpResponseFuture.notifyHttpListener(this.targetRespMsg);
                    }
                    catch (Exception e) {
                        LOG.error("Error while notifying response to listener ", (Throwable)e);
                    }
                } else {
                    LOG.error("Cannot correlate callback with request callback is null");
                }
            } else if (this.targetRespMsg != null) {
                HttpContent httpContent = (HttpContent)msg;
                this.targetRespMsg.addHttpContent(httpContent);
                if (Util.isLastHttpContent(httpContent)) {
                    if (this.handlerExecutor != null) {
                        this.handlerExecutor.executeAtTargetResponseSending(this.targetRespMsg);
                    }
                    this.targetChannel.getChannel().pipeline().remove("idleStateHandler");
                    this.connectionManager.returnChannel(this.targetChannel);
                    if (!this.isKeepAlive) {
                        this.closeChannel(ctx);
                    }
                }
            }
        } else {
            if (msg instanceof HttpResponse) {
                LOG.warn("Received a response for an obsolete request");
            }
            ReferenceCountUtil.release((Object)msg);
            if (!this.isKeepAlive) {
                this.closeChannel(ctx);
            }
        }
    }

    private HTTPCarbonMessage setUpCarbonMessage(ChannelHandlerContext ctx, Object msg) {
        this.targetRespMsg = new HttpCarbonResponse((HttpResponse)msg);
        this.targetRespMsg.setProperty("DIRECTION", "DIRECTION_RESPONSE");
        HttpResponse httpResponse = (HttpResponse)msg;
        this.targetRespMsg.setProperty("HTTP_STATUS_CODE", httpResponse.getStatus().code());
        this.targetRespMsg.setProperty("executor.workerpool", this.incomingMsg.getProperty("executor.workerpool"));
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtTargetResponseReceiving(this.targetRespMsg);
        }
        return this.targetRespMsg;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Channel " + ctx.channel().id() + " gets inactive so closing it from Target handler.");
        }
        this.closeChannel(ctx);
        this.connectionManager.invalidateTargetChannel(this.targetChannel);
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtTargetConnectionTermination(Integer.toString(ctx.hashCode()));
            this.handlerExecutor = null;
        }
    }

    public void setHttpResponseFuture(HttpResponseFuture httpResponseFuture) {
        this.httpResponseFuture = httpResponseFuture;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void setIncomingMsg(HTTPCarbonMessage incomingMsg) {
        this.incomingMsg = incomingMsg;
    }

    public void setTargetChannel(TargetChannel targetChannel) {
        this.targetChannel = targetChannel;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.isKeepAlive = keepAlive;
    }

    public HttpResponseFuture getHttpResponseFuture() {
        return this.httpResponseFuture;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error("Exception occurred in TargetHandler.", cause);
        this.httpResponseFuture.notifyHttpListener(cause);
        if (ctx != null && ctx.channel().isActive()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(" And Channel ID is : " + ctx.channel().id());
            }
            ctx.close();
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent event;
        if (evt instanceof IdleStateEvent && ((event = (IdleStateEvent)evt).state() == IdleState.READER_IDLE || event.state() == IdleState.WRITER_IDLE)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Timeout occurred in Targethandler. Channel ID : " + ctx.channel().id());
            }
            this.targetChannel.getChannel().pipeline().remove("idleStateHandler");
            this.targetChannel.setRequestWritten(false);
            this.httpResponseFuture.notifyHttpListener(new ClientConnectorException(HttpResponseStatus.GATEWAY_TIMEOUT.reasonPhrase(), HttpResponseStatus.GATEWAY_TIMEOUT.code()));
        }
    }

    private void closeChannel(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive()) {
            ctx.close();
        }
    }
}

