/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.message;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wso2.carbon.messaging.MessageDataSource;
import org.wso2.carbon.messaging.MessageUtil;
import org.wso2.carbon.messaging.exceptions.MessagingException;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.HttpResponseStatusFuture;
import org.wso2.transport.http.netty.contractimpl.HttpWsServerConnectorFuture;
import org.wso2.transport.http.netty.listener.ServerBootstrapConfiguration;
import org.wso2.transport.http.netty.message.BlockingEntityCollector;
import org.wso2.transport.http.netty.message.EntityCollector;
import org.wso2.transport.http.netty.message.MessageFuture;
import org.wso2.transport.http.netty.sender.channel.BootstrapConfiguration;

public class HTTPCarbonMessage {
    protected HttpMessage httpMessage;
    private EntityCollector blockingEntityCollector;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private MessagingException messagingException = null;
    private MessageDataSource messageDataSource;
    private MessageFuture messageFuture;
    private final ServerConnectorFuture httpOutboundRespFuture = new HttpWsServerConnectorFuture();
    private final HttpResponseStatusFuture httpOutboundRespStatusFuture = new HttpResponseStatusFuture();

    public HTTPCarbonMessage(HttpMessage httpMessage) {
        int soTimeOut = 60;
        BootstrapConfiguration clientBootstrapConfig = BootstrapConfiguration.getInstance();
        if (clientBootstrapConfig != null) {
            soTimeOut = clientBootstrapConfig.getSocketTimeout();
        } else {
            ServerBootstrapConfiguration serverBootstrapConfiguration = ServerBootstrapConfiguration.getInstance();
            if (serverBootstrapConfiguration != null) {
                soTimeOut = serverBootstrapConfiguration.getSoTimeOut();
            }
        }
        this.httpMessage = httpMessage;
        this.setBlockingEntityCollector(new BlockingEntityCollector(soTimeOut));
    }

    public synchronized void addHttpContent(HttpContent httpContent) {
        if (this.messageFuture != null) {
            this.messageFuture.notifyMessageListener(httpContent);
        } else {
            this.blockingEntityCollector.addHttpContent(httpContent);
        }
    }

    public HttpContent getHttpContent() {
        return this.blockingEntityCollector.getHttpContent();
    }

    public synchronized MessageFuture getHttpContentAsync() {
        this.messageFuture = new MessageFuture(this);
        return this.messageFuture;
    }

    @Deprecated
    public ByteBuf getMessageBody() {
        return this.blockingEntityCollector.getMessageBody();
    }

    public List<ByteBuffer> getFullMessageBody() {
        return this.blockingEntityCollector.getFullMessageBody();
    }

    public boolean isEmpty() {
        return this.blockingEntityCollector.isEmpty();
    }

    public int getFullMessageLength() {
        return this.blockingEntityCollector.getFullMessageLength();
    }

    @Deprecated
    public boolean isEndOfMsgAdded() {
        return this.blockingEntityCollector.isEndOfMsgAdded();
    }

    @Deprecated
    public void addMessageBody(ByteBuffer msgBody) {
        this.blockingEntityCollector.addMessageBody(msgBody);
    }

    private void markMessageEnd() {
        this.blockingEntityCollector.markMessageEnd();
    }

    @Deprecated
    public void setEndOfMsgAdded(boolean endOfMsgAdded) {
        this.blockingEntityCollector.setEndOfMsgAdded(endOfMsgAdded);
    }

    public HttpHeaders getHeaders() {
        return this.httpMessage.headers();
    }

    public String getHeader(String key) {
        return this.httpMessage.headers().get(key);
    }

    public void setHeader(String key, String value) {
        this.httpMessage.headers().set(key, (Object)value);
    }

    public void setHeaders(HttpHeaders httpHeaders) {
        this.httpMessage.headers().setAll(httpHeaders);
    }

    public void removeHeader(String key) {
        this.httpMessage.headers().remove(key);
    }

    public Object getProperty(String key) {
        if (this.properties != null) {
            return this.properties.get(key);
        }
        return null;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public MessageDataSource getMessageDataSource() {
        return this.messageDataSource;
    }

    public void setMessageDataSource(MessageDataSource messageDataSource) {
        this.messageDataSource = messageDataSource;
    }

    public MessagingException getMessagingException() {
        return this.messagingException;
    }

    public void setMessagingException(MessagingException messagingException) {
        this.messagingException = messagingException;
    }

    private void setBlockingEntityCollector(BlockingEntityCollector blockingEntityCollector) {
        this.blockingEntityCollector = blockingEntityCollector;
    }

    @Deprecated
    public void release() {
        this.blockingEntityCollector.release();
    }

    public ServerConnectorFuture getHttpResponseFuture() {
        return this.httpOutboundRespFuture;
    }

    public HttpResponseStatusFuture getHttpOutboundRespStatusFuture() {
        return this.httpOutboundRespStatusFuture;
    }

    public HttpResponseStatusFuture respond(HTTPCarbonMessage httpCarbonMessage) throws ServerConnectorException {
        this.httpOutboundRespFuture.notifyHttpListener(httpCarbonMessage);
        return this.httpOutboundRespStatusFuture;
    }

    public HTTPCarbonMessage cloneCarbonMessageWithOutData() {
        HTTPCarbonMessage newCarbonMessage = this.getNewHttpCarbonMessage();
        Map<String, Object> propertiesMap = this.getProperties();
        propertiesMap.forEach(newCarbonMessage::setProperty);
        return newCarbonMessage;
    }

    private HTTPCarbonMessage getNewHttpCarbonMessage() {
        DefaultHttpHeaders httpHeaders;
        DefaultFullHttpResponse newHttpMessage;
        if (this.httpMessage instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)this.httpMessage;
            newHttpMessage = new DefaultHttpRequest(this.httpMessage.protocolVersion(), ((HttpRequest)this.httpMessage).method(), httpRequest.uri());
            httpHeaders = new DefaultHttpHeaders();
            List headerList = this.httpMessage.headers().entries();
            for (Map.Entry entry : headerList) {
                httpHeaders.set((String)entry.getKey(), entry.getValue());
            }
        } else {
            HttpResponse httpResponse = (HttpResponse)this.httpMessage;
            newHttpMessage = new DefaultFullHttpResponse(this.httpMessage.protocolVersion(), httpResponse.status());
            httpHeaders = new DefaultHttpHeaders();
            List headerList = this.httpMessage.headers().entries();
            for (Map.Entry entry : headerList) {
                httpHeaders.set((String)entry.getKey(), entry.getValue());
            }
        }
        HTTPCarbonMessage httpCarbonMessage = new HTTPCarbonMessage((HttpMessage)newHttpMessage);
        httpCarbonMessage.setHeaders((HttpHeaders)httpHeaders);
        return httpCarbonMessage;
    }

    public HTTPCarbonMessage cloneCarbonMessageWithData() {
        HTTPCarbonMessage httpCarbonMessage = this.getNewHttpCarbonMessage();
        Map<String, Object> propertiesMap = this.getProperties();
        propertiesMap.forEach(httpCarbonMessage::setProperty);
        this.getCopyOfFullMessageBody().forEach(httpCarbonMessage::addMessageBody);
        httpCarbonMessage.setEndOfMsgAdded(true);
        return httpCarbonMessage;
    }

    private List<ByteBuffer> getCopyOfFullMessageBody() {
        List<ByteBuffer> fullMessageBody = this.getFullMessageBody();
        List<ByteBuffer> newCopy = fullMessageBody.stream().map(MessageUtil::deepCopy).collect(Collectors.toList());
        fullMessageBody.forEach(this::addMessageBody);
        this.markMessageEnd();
        return newCopy;
    }

    public void waitAndReleaseAllEntities() {
        this.blockingEntityCollector.waitAndReleaseAllEntities();
    }

    protected void finalize() {
        this.release();
    }

    public EntityCollector getBlockingEntityCollector() {
        return this.blockingEntityCollector;
    }

    public HttpContent peek() {
        return this.blockingEntityCollector.peek();
    }

    public synchronized void removeHttpContentAsyncFuture() {
        this.messageFuture = null;
    }
}

